/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.tools.areatools;

import com.kwpugh.gobber2.events.TreeAxeBlock;
import com.kwpugh.gobber2.events.TreeAxeManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class TreeAxeBase
extends AxeItem {
    static TreeAxeBlock treeAxeBlock;

    public TreeAxeBase(Tier tier, Item.Properties builder) {
        super(tier, builder);
    }

    public boolean mineBlock(@NotNull ItemStack stack, @NotNull Level level, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            Tool tool = (Tool)stack.get(DataComponents.TOOL);
            if (tool == null) {
                return false;
            }
            if (!level.isClientSide && state.getDestroySpeed((BlockGetter)level, pos) > 0.0f && tool.damagePerBlock() > 0) {
                stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
            if (stack.isCorrectToolForDrops(state) && state.is(BlockTags.LOGS)) {
                Block.dropResources((BlockState)state, (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)player.getMainHandItem());
                if (!this.attemptFellTree(level, pos, player)) {
                    TreeAxeBase.attemptBreakNeighbors(level, pos, player);
                }
            }
        }
        return true;
    }

    private boolean attemptFellTree(Level level, BlockPos pos, Player player) {
        int i;
        ArrayList<BlockPos> logs = new ArrayList<BlockPos>();
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        candidates.add(pos);
        int leaves = 0;
        for (i = 0; i < candidates.size(); ++i) {
            if (logs.size() > 200) {
                return false;
            }
            BlockPos candidate = (BlockPos)candidates.get(i);
            BlockState state = level.getBlockState(candidate);
            Block block = state.getBlock();
            if (state.is(BlockTags.LEAVES)) {
                ++leaves;
                continue;
            }
            if (!logs.isEmpty() && !state.is(BlockTags.LOGS)) continue;
            logs.add(candidate);
            for (int x = -1; x <= 1; ++x) {
                for (int y = 0; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos neighbor = candidate.offset(x, y, z);
                        if (candidates.contains(neighbor)) continue;
                        candidates.add(neighbor);
                    }
                }
            }
        }
        if (logs.isEmpty()) {
            return false;
        }
        if ((double)leaves >= (double)logs.size() / 6.0) {
            for (i = 0; i < logs.size(); ++i) {
                BlockPos log = (BlockPos)logs.get(i);
                treeAxeBlock = new TreeAxeBlock(level, player, log);
                TreeAxeManager.addToList(treeAxeBlock);
            }
            return true;
        }
        return false;
    }

    public static void attemptBreakNeighbors(Level level, BlockPos pos, Player player) {
        level.setBlockAndUpdate(pos, Blocks.GLASS.defaultBlockState());
        HitResult trace = TreeAxeBase.calcRayTrace(level, player, ClipContext.Fluid.ANY);
        level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        if (trace.getType() == HitResult.Type.BLOCK) {
            BlockHitResult blockTrace = (BlockHitResult)trace;
            Direction face = blockTrace.getDirection();
            for (int a = -1; a <= 1; ++a) {
                for (int b = -1; b <= 1; ++b) {
                    if (a == 0 && b == 0) continue;
                    BlockPos target = null;
                    if (face == Direction.UP || face == Direction.DOWN) {
                        target = pos.offset(a, 0, b);
                    }
                    if (face == Direction.NORTH || face == Direction.SOUTH) {
                        target = pos.offset(a, b, 0);
                    }
                    if (face == Direction.EAST || face == Direction.WEST) {
                        target = pos.offset(0, a, b);
                    }
                    TreeAxeBase.attemptBreak(level, target, player);
                }
            }
        }
    }

    public static void attemptBreak(Level level, BlockPos pos, Player player) {
        BlockState state = level.getBlockState(pos);
        boolean validHarvest = player.getMainHandItem().isCorrectToolForDrops(state);
        boolean isEffective = state.is(BlockTags.MINEABLE_WITH_AXE);
        boolean witherImmune = state.is(BlockTags.WITHER_IMMUNE);
        if (validHarvest && isEffective && !witherImmune) {
            treeAxeBlock = new TreeAxeBlock(level, player, pos);
            TreeAxeManager.addToList(treeAxeBlock);
        }
    }

    public static HitResult calcRayTrace(Level worldIn, Player player, ClipContext.Fluid fluidMode) {
        float f = player.xRotO;
        float f1 = player.yRotO;
        Vec3 vec3d = player.getEyePosition(1.0f);
        float f2 = Mth.cos((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.sin((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.cos((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.sin((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.blockInteractionRange() + 1.0;
        Vec3 vec3d1 = vec3d.add((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return worldIn.clip(new ClipContext(vec3d, vec3d1, ClipContext.Block.OUTLINE, fluidMode, (Entity)player));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.gobber2.gobber2_tree_axe.line1").withStyle(ChatFormatting.GREEN));
    }
}

