/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.mixin;

import com.kwpugh.gobber2.util.InfiniteEffectManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixinInfiniteEffect
extends LivingEntity {
    @Shadow
    public abstract void readAdditionalSaveData(CompoundTag var1);

    @Shadow
    public abstract void addAdditionalSaveData(CompoundTag var1);

    protected PlayerEntityMixinInfiniteEffect(EntityType<? extends LivingEntity> type, Level level) {
        super(type, level);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void gobberEffectTick(CallbackInfo ci) {
        Player player = (Player)this;
        Level level = player.level();
        if (level instanceof ServerLevel) {
            InfiniteEffectManager.update(player);
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void writeNbtGobberEffect(CompoundTag nbt, CallbackInfo ci) {
        Player player = (Player)this;
        Level level = player.level();
        if (level instanceof ServerLevel) {
            InfiniteEffectManager.writeNbt(nbt);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readNbtGobberEffect(CompoundTag nbt, CallbackInfo ci) {
        Player player = (Player)this;
        Level level = player.level();
        if (level instanceof ServerLevel && nbt.contains("hasInfiniteVision")) {
            InfiniteEffectManager.readNbt(nbt);
        }
    }
}

