/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.util;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;

public class EnchantmentUtil {
    public static Holder<Enchantment> getEnchantment(Level level, ResourceKey<Enchantment> enchantment) {
        return (Holder)((Registry)level.registryAccess().registry(Registries.ENCHANTMENT).get()).getHolder(enchantment).get();
    }

    public static int getEnchantmentLevel(Level level, ItemStack stack, ResourceKey<Enchantment> key) {
        Registry reg = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        return reg.getHolder(key).map(arg_0 -> ((ItemStack)stack).getEnchantmentLevel(arg_0)).orElse(0);
    }

    public static boolean hasEnchantment(ResourceKey<Enchantment> enchantment, ItemStack stack) {
        ItemEnchantments component = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
        if (component == null) {
            return false;
        }
        Set set = component.entrySet();
        for (Object2IntMap.Entry holderEntry : set) {
            Holder test = (Holder)holderEntry.getKey();
            ResourceKey key = (ResourceKey)test.unwrapKey().get();
            if (enchantment != key) continue;
            return true;
        }
        return false;
    }
}

