/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.util;

import net.minecraft.world.entity.player.Player;

public class ExpUtils {
    public static int getPlayerXP(Player player) {
        return (int)((float)ExpUtils.getExperienceForLevel(player.experienceLevel) + player.experienceProgress * (float)player.getXpNeededForNextLevel());
    }

    public static void addPlayerXP(Player player, int amount) {
        int experience;
        player.totalExperience = experience = ExpUtils.getPlayerXP(player) + amount;
        player.experienceLevel = ExpUtils.getLevelForExperience(experience);
        int expForLevel = ExpUtils.getExperienceForLevel(player.experienceLevel);
        player.experienceProgress = (float)(experience - expForLevel) / (float)player.getXpNeededForNextLevel();
    }

    public static int xpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        return level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2;
    }

    private static int sum(int n, int a0, int d) {
        return n * (2 * a0 + (n - 1) * d) / 2;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level <= 15) {
            return ExpUtils.sum(level, 7, 2);
        }
        if (level <= 30) {
            return 315 + ExpUtils.sum(level - 15, 37, 5);
        }
        return 1395 + ExpUtils.sum(level - 30, 112, 9);
    }

    public static int getXpToNextLevel(int level) {
        int levelXP = ExpUtils.getLevelForExperience(level);
        int nextXP = ExpUtils.getExperienceForLevel(level + 1);
        return nextXP - levelXP;
    }

    public static int getLevelForExperience(int targetXp) {
        int level = 0;
        int xpToNextLevel;
        while (targetXp >= (xpToNextLevel = ExpUtils.xpBarCap(level))) {
            ++level;
            targetXp -= xpToNextLevel;
        }
        return level;
    }
}

