/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.util;

import com.kwpugh.gobber2.config.ConfigJankson;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BambooSaplingBlock;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BuddingAmethystBlock;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CoralBlock;
import net.minecraft.world.level.block.CoralPlantBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FungusBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.KelpBlock;
import net.minecraft.world.level.block.KelpPlantBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.PumpkinBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SeaPickleBlock;
import net.minecraft.world.level.block.SeagrassBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.TallSeagrassBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;

public class GrowingUtil {
    public static void growCrops(Level world, Player player, int baseTickDelay, int radius) {
        BlockPos playerPos = new BlockPos((Vec3i)player.getOnPos());
        for (BlockPos targetPos : BlockPos.betweenClosed((BlockPos)playerPos.offset(-radius, -2, -radius), (BlockPos)playerPos.offset(radius, 3, radius))) {
            BlockState blockstate = world.getBlockState(targetPos);
            Block block = blockstate.getBlock();
            if ((blockstate.getBlock() instanceof CropBlock || block instanceof BonemealableBlock || block instanceof SaplingBlock || block instanceof VineBlock || block instanceof SugarCaneBlock || block instanceof SweetBerryBushBlock || block instanceof NetherWartBlock || block instanceof CactusBlock || block instanceof StemBlock || block instanceof PumpkinBlock || block instanceof BuddingAmethystBlock || block instanceof KelpPlantBlock || block instanceof KelpBlock) && player.tickCount % baseTickDelay == 0) {
                blockstate.randomTick((ServerLevel)world, targetPos, world.random);
            }
            if ((block instanceof CoralBlock || block instanceof BambooSaplingBlock || block instanceof BambooStalkBlock || block instanceof CocoaBlock || block instanceof StemBlock || block instanceof CoralPlantBlock || block instanceof TallSeagrassBlock || block instanceof SeagrassBlock || block instanceof SeaPickleBlock || block instanceof ChorusFlowerBlock) && player.tickCount % (baseTickDelay * 2) == 0) {
                blockstate.randomTick((ServerLevel)world, targetPos, world.random);
            }
            if (block instanceof GrassBlock && player.isShiftKeyDown() && player.tickCount % (baseTickDelay * 6) == 0) {
                ((GrassBlock)block).performBonemeal((ServerLevel)world, world.random, targetPos, blockstate);
            }
            if (!(block instanceof FungusBlock) || player.tickCount % (baseTickDelay * 6) != 0) continue;
            ((FungusBlock)block).performBonemeal((ServerLevel)world, world.random, targetPos, blockstate);
        }
    }

    public static void harvestCrops(Level world, Player player, int radius) {
        if (!world.isClientSide) {
            BlockPos playerPos = new BlockPos((Vec3i)player.getOnPos());
            for (BlockPos targetPos : BlockPos.betweenClosed((BlockPos)playerPos.offset(-radius, -2, -radius), (BlockPos)playerPos.offset(radius, 6, radius))) {
                boolean atMaxAge;
                Block block = world.getBlockState(targetPos).getBlock();
                BlockPos posAbove = targetPos.above();
                Block blockAbove = world.getBlockState(posAbove).getBlock();
                BlockState state = world.getBlockState(targetPos);
                BlockState defaultState = block.defaultBlockState();
                if (ConfigJankson.getConfig().staffFarmerBreaking) {
                    if (block instanceof CocoaBlock || block instanceof StemBlock || block instanceof PumpkinBlock || block instanceof NetherWartBlock) {
                        world.destroyBlock(targetPos, true);
                    }
                    if ((block instanceof CactusBlock || block instanceof SugarCaneBlock || block instanceof BambooStalkBlock) && block == blockAbove) {
                        world.destroyBlock(posAbove, true);
                    }
                }
                if (!(block instanceof CropBlock) || !(atMaxAge = ((CropBlock)block).getAge(state) >= ((CropBlock)block).getMaxAge())) continue;
                world.destroyBlock(targetPos, true);
                if (!ConfigJankson.getConfig().staffFarmerReplant) continue;
                world.setBlockAndUpdate(targetPos, defaultState);
            }
        }
    }
}

