/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.util;

import com.kwpugh.gobber2.init.ItemInit;
import com.kwpugh.gobber2.util.EnableUtil;
import com.kwpugh.gobber2.util.PlayerEquipUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class InfiniteEffectManager {
    static boolean hasInfiniteVision = false;

    public static void update(Player player) {
        if (!(PlayerEquipUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_RING_VISION.get()) && PlayerEquipUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_RING_VISION.get()) || !InfiniteEffectManager.getInfiniteVision(player))) {
            InfiniteEffectManager.setInfiniteVision(player, false);
        }
        if (PlayerEquipUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_RING_VISION.get()) || PlayerEquipUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_RING_VISION.get())) {
            ItemStack stack = ItemStack.EMPTY;
            if (PlayerEquipUtil.hasItemInEnderchest(player, (Item)ItemInit.GOBBER2_RING_VISION.get())) {
                stack = PlayerEquipUtil.getItemInEnderchest(player, (Item)ItemInit.GOBBER2_RING_VISION.get());
            } else if (PlayerEquipUtil.hasItemInInventory(player, (Item)ItemInit.GOBBER2_RING_VISION.get())) {
                stack = PlayerEquipUtil.getItemInInventory(player, (Item)ItemInit.GOBBER2_RING_VISION.get());
            }
            boolean status = EnableUtil.isEnabled(stack);
            if (!InfiniteEffectManager.getInfiniteVision(player) && status) {
                InfiniteEffectManager.setInfiniteVision(player, true);
            }
        }
    }

    public static boolean getInfiniteVision(Player player) {
        return hasInfiniteVision;
    }

    public static void setInfiniteVision(Player player, boolean status) {
        hasInfiniteVision = status;
        if (status) {
            MobEffectInstance effect = new MobEffectInstance(MobEffects.NIGHT_VISION, -1, 0, false, false, false);
            player.addEffect(effect);
            if (player.hasEffect(MobEffects.DARKNESS)) {
                player.removeEffect(MobEffects.DARKNESS);
            }
        } else {
            player.removeEffect(MobEffects.NIGHT_VISION);
            hasInfiniteVision = status;
        }
    }

    public static void readNbt(CompoundTag nbt) {
        if (nbt.contains("hasInfiniteVision")) {
            hasInfiniteVision = nbt.getBoolean("hasInfiniteVision");
        }
    }

    public static void writeNbt(CompoundTag nbt) {
        nbt.putBoolean("hasInfiniteVision", hasInfiniteVision);
    }
}

