/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.util;

import com.kwpugh.gobber2.config.ConfigJankson;
import com.kwpugh.gobber2.util.EnableUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.LlamaSpit;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.entity.projectile.windcharge.BreezeWindCharge;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class PlayerSpecialAbilities {
    public static void giveFullHealth(Level world, Player player, ItemStack itemstack) {
        player.setHealth(player.getMaxHealth());
    }

    public static void giveNewMaxHealth(Level world, Player player, ItemStack itemstack, double newMax) {
        float healthAsFloat = (float)newMax;
        player.setHealth(healthAsFloat);
    }

    public static void giveSaturationEffect(Level world, Player player, ItemStack itemstack) {
        player.getFoodData().setSaturation(7.0f);
    }

    public static void giveRegenEffect(Level world, Player player, ItemStack itemstack, int newfoodlevel, float newsatlevel) {
        if (player.tickCount % 180 == 0) {
            player.getFoodData().eat(newfoodlevel, newsatlevel);
        }
    }

    public static void giveLesserAbsorption(Player player) {
        float current = player.getAbsorptionAmount();
        player.setAbsorptionAmount(current + 1.0f);
        if (player.getHealth() < 20.0f || current >= 10.0f) {
            return;
        }
        if (player.tickCount % 180 == 0) {
            if (current < 9.0f) {
                player.setAbsorptionAmount(current + 0.33f);
            } else if (current >= 9.0f) {
                player.setAbsorptionAmount(10.0f);
            }
        }
    }

    public static void giveGreaterAbsorption(Player player) {
        float current = player.getAbsorptionAmount();
        if (player.getHealth() < 20.0f || current >= 20.0f) {
            return;
        }
        if (current >= 19.0f) {
            if (player.tickCount % 180 == 0) {
                player.setAbsorptionAmount(20.0f);
            }
            return;
        }
        if (current < 19.0f && player.tickCount % 180 == 0) {
            player.setAbsorptionAmount(current + 1.0f);
        }
    }

    public static void giveYellowHearts(Level world, LivingEntity player, ItemStack itemstack, int extraHearts, float absorptionRate) {
        float current = player.getAbsorptionAmount();
        if (player.getHealth() < 20.0f || current >= (float)extraHearts) {
            return;
        }
        if (current >= (float)(extraHearts - 1)) {
            if (player.tickCount % 180 == 0) {
                player.setAbsorptionAmount((float)extraHearts);
            }
            return;
        }
        if (current < (float)(extraHearts - 1) && player.tickCount % 180 == 0) {
            player.setAbsorptionAmount(current + absorptionRate);
        }
    }

    public static void giveNoExtraHearts(Level world, Player player, ItemStack itemstack) {
        player.setAbsorptionAmount(0.0f);
    }

    public static void doAttraction(Level level, Player player, ItemStack stack) {
        int range = ConfigJankson.getConfig().ringAttractionPullRadius;
        int ringAttractionBlocking = ConfigJankson.getConfig().ringAttractionBlockingDistance;
        boolean ringAttractionMode = ConfigJankson.getConfig().ringAttractionMode;
        if (!level.isClientSide && EnableUtil.isEnabled(stack)) {
            double x = player.getX();
            double y = player.getY();
            double z = player.getZ();
            BlockPos playerPos = new BlockPos((Vec3i)player.getOnPos());
            for (Object targetPos : BlockPos.betweenClosed((BlockPos)playerPos.offset(-range, -ringAttractionBlocking, -range), (BlockPos)playerPos.offset(range, ringAttractionBlocking, range))) {
                BlockState blockstate = level.getBlockState((BlockPos)targetPos);
                if (blockstate.getBlock() != Blocks.COAL_BLOCK) continue;
                return;
            }
            List items = player.level().getEntitiesOfClass(ItemEntity.class, new AABB(x - (double)range, y - (double)range, z - (double)range, x + (double)range, y + (double)range, z + (double)range));
            for (ItemEntity e : items) {
                if (player.isShiftKeyDown() || e.getPersistentData().getBoolean("PreventRemoteMovement")) continue;
                if (ringAttractionMode) {
                    e.playerTouch(player);
                    continue;
                }
                double factor = 0.035;
                e.push((x - e.getX()) * factor, (y - e.getY() + 1.25) * factor, (z - e.getZ()) * factor);
            }
            List xp = player.level().getEntitiesOfClass(ExperienceOrb.class, new AABB(x - (double)range, y - (double)range, z - (double)range, x + (double)range, y + (double)range, z + (double)range));
            for (ExperienceOrb orb : xp) {
                if (player.isShiftKeyDown()) continue;
                if (ringAttractionMode) {
                    orb.playerTouch(player);
                    continue;
                }
                double factor = 0.035;
                orb.push((x - orb.getX()) * factor, (y - orb.getY() + 1.25) * factor, (z - orb.getZ()) * factor);
            }
        }
    }

    public static void inflictSuffering(Level level, BlockPos pos, int range, int damage) {
        AABB mobBox = new AABB(pos).inflate((double)range, 2.0, (double)range);
        List list2 = level.getEntitiesOfClass(Entity.class, mobBox);
        for (Entity targetEntity : list2) {
            if (targetEntity instanceof WitherBoss || targetEntity instanceof Guardian || targetEntity instanceof Blaze || targetEntity instanceof Breeze || targetEntity instanceof Vex || !(targetEntity instanceof Monster) && !(targetEntity instanceof Hoglin)) continue;
            DamageSource damageSource = targetEntity.damageSources().generic();
            targetEntity.hurt(damageSource, (float)damage);
        }
    }

    public static void giveProjectileShield(Level level, Player player, int vRadius, int hRadius) {
        AABB mobBoxLoot = new AABB(player.getOnPos()).inflate((double)hRadius, (double)vRadius, (double)hRadius);
        List listShield = level.getEntitiesOfClass(Entity.class, mobBoxLoot);
        for (Entity targetEntity : listShield) {
            ItemStack drop;
            if (targetEntity instanceof Projectile) {
                Projectile projectile = (Projectile)targetEntity;
                drop = Items.FEATHER.getDefaultInstance();
                boolean arrow = targetEntity instanceof Arrow;
                boolean fireball = targetEntity instanceof Fireball;
                boolean small_fireball = targetEntity instanceof SmallFireball;
                boolean shulker = targetEntity instanceof ShulkerBullet;
                boolean llamaSpit = targetEntity instanceof LlamaSpit;
                boolean trident = targetEntity instanceof ThrownTrident;
                boolean witherSkull = targetEntity instanceof WitherSkull;
                boolean dragonball = targetEntity instanceof LargeFireball;
                boolean windCharge = targetEntity instanceof BreezeWindCharge;
                if (arrow) {
                    drop = Items.ARROW.getDefaultInstance();
                }
                if (fireball || small_fireball) {
                    drop = Items.FIRE_CHARGE.getDefaultInstance();
                }
                if (shulker) {
                    drop = Items.POPPED_CHORUS_FRUIT.getDefaultInstance();
                }
                if (llamaSpit) {
                    drop = Items.BONE_MEAL.getDefaultInstance();
                }
                if (trident) {
                    drop = Items.PRISMARINE_SHARD.getDefaultInstance();
                }
                if (witherSkull) {
                    drop = Items.WITHER_SKELETON_SKULL.getDefaultInstance();
                }
                if (dragonball) break;
                if (windCharge) {
                    drop = Items.WIND_CHARGE.getDefaultInstance();
                }
                if (arrow || fireball || small_fireball || shulker || llamaSpit || trident || windCharge) {
                    level.addFreshEntity((Entity)new ItemEntity(level, projectile.getX(), projectile.getY(), projectile.getZ(), drop));
                    projectile.remove(Entity.RemovalReason.DISCARDED);
                }
                if (witherSkull && ConfigJankson.getConfig().medallionShieldingAgainstWither) {
                    level.addFreshEntity((Entity)new ItemEntity(level, projectile.getX(), projectile.getY(), projectile.getZ(), drop));
                    projectile.remove(Entity.RemovalReason.DISCARDED);
                }
            }
            if (!(targetEntity instanceof ThrownPotion)) continue;
            ThrownPotion potionEntity = (ThrownPotion)targetEntity;
            drop = Items.POPPY.getDefaultInstance();
            level.addFreshEntity((Entity)new ItemEntity(level, potionEntity.getX(), potionEntity.getY(), potionEntity.getZ(), drop));
            potionEntity.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public static void doCuring(Player player) {
        if (player.getEffect(MobEffects.BLINDNESS) != null) {
            player.removeEffect(MobEffects.BLINDNESS);
        }
        if (player.getEffect(MobEffects.MOVEMENT_SLOWDOWN) != null) {
            player.removeEffect(MobEffects.MOVEMENT_SLOWDOWN);
        }
        if (player.getEffect(MobEffects.DIG_SLOWDOWN) != null) {
            player.removeEffect(MobEffects.DIG_SLOWDOWN);
        }
        if (player.getEffect(MobEffects.HARM) != null) {
            player.removeEffect(MobEffects.HARM);
        }
        if (player.getEffect(MobEffects.CONFUSION) != null) {
            player.removeEffect(MobEffects.CONFUSION);
        }
        if (player.getEffect(MobEffects.HUNGER) != null) {
            player.removeEffect(MobEffects.HUNGER);
        }
        if (player.getEffect(MobEffects.POISON) != null) {
            player.removeEffect(MobEffects.POISON);
        }
        if (player.getEffect(MobEffects.WITHER) != null) {
            player.removeEffect(MobEffects.WITHER);
        }
        if (player.getEffect(MobEffects.LEVITATION) != null) {
            player.removeEffect(MobEffects.LEVITATION);
        }
        if (player.getEffect(MobEffects.UNLUCK) != null) {
            player.removeEffect(MobEffects.UNLUCK);
        }
        if (player.getEffect(MobEffects.WEAKNESS) != null) {
            player.removeEffect(MobEffects.WEAKNESS);
        }
        if (player.getEffect(MobEffects.DARKNESS) != null) {
            player.removeEffect(MobEffects.DARKNESS);
        }
    }
}

