/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.world;

import com.kwpugh.gobber2.world.ModPlacedFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class ModBiomeModifiers {
    public static final ResourceKey<BiomeModifier> ADD_GOBBER_ORE = ModBiomeModifiers.registerKey("add_gobber_ore");
    public static final ResourceKey<BiomeModifier> ADD_GOBBER_NETHER_ORE = ModBiomeModifiers.registerKey("add_gobber_nether_ore");
    public static final ResourceKey<BiomeModifier> ADD_GOBBER_END_ORE = ModBiomeModifiers.registerKey("add_gobber_end_ore");
    public static final ResourceKey<BiomeModifier> ADD_LUCKY_BLOCK = ModBiomeModifiers.registerKey("add_lucky_block");
    public static final ResourceKey<BiomeModifier> ADD_LUCKY_BLOCK_NETHER = ModBiomeModifiers.registerKey("add_lucky_block_nether");
    public static final ResourceKey<BiomeModifier> ADD_LUCKY_BLOCK_END = ModBiomeModifiers.registerKey("add_lucky_block_end");

    public static void bootstrap(BootstrapContext<BiomeModifier> context) {
        HolderGetter placedFeatures = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter biomes = context.lookup(Registries.BIOME);
        context.register(ADD_GOBBER_ORE, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_OVERWORLD), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ModPlacedFeatures.GOBBER_ORE_PLACED_KEY)}), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.register(ADD_GOBBER_NETHER_ORE, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_NETHER), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ModPlacedFeatures.GOBBER_NETHER_ORE_PLACED_KEY)}), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.register(ADD_GOBBER_END_ORE, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_END), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ModPlacedFeatures.GOBBER_END_ORE_PLACED_KEY)}), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.register(ADD_LUCKY_BLOCK, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_OVERWORLD), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ModPlacedFeatures.LUCKY_BLOCK_PLACED_KEY)}), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.register(ADD_LUCKY_BLOCK_NETHER, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_NETHER), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ModPlacedFeatures.LUCKY_BLOCK_NETHER_PLACED_KEY)}), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.register(ADD_LUCKY_BLOCK_END, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_END), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ModPlacedFeatures.LUCKY_BLOCK_END_PLACED_KEY)}), GenerationStep.Decoration.UNDERGROUND_ORES));
    }

    private static ResourceKey<BiomeModifier> registerKey(String name) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gobber2", (String)name));
    }
}

