/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.world;

import com.kwpugh.gobber2.world.ModConfiguredFeatures;
import com.kwpugh.gobber2.world.ModOrePlacement;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> GOBBER_ORE_PLACED_KEY = ModPlacedFeatures.registerKey("gobber_ore_placed");
    public static final ResourceKey<PlacedFeature> GOBBER_NETHER_ORE_PLACED_KEY = ModPlacedFeatures.registerKey("gobber_nether_ore_placed");
    public static final ResourceKey<PlacedFeature> GOBBER_END_ORE_PLACED_KEY = ModPlacedFeatures.registerKey("gobber_end_ore_placed");
    public static final ResourceKey<PlacedFeature> LUCKY_BLOCK_PLACED_KEY = ModPlacedFeatures.registerKey("lucky_block_placed");
    public static final ResourceKey<PlacedFeature> LUCKY_BLOCK_NETHER_PLACED_KEY = ModPlacedFeatures.registerKey("lucky_block_nether_placed");
    public static final ResourceKey<PlacedFeature> LUCKY_BLOCK_END_PLACED_KEY = ModPlacedFeatures.registerKey("lucky_block_end_placed");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        ModPlacedFeatures.register(context, GOBBER_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.OVERWORLD_GOBBER_ORE_KEY), ModOrePlacement.commonOrePlacement(8, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-40), (VerticalAnchor)VerticalAnchor.absolute((int)30))));
        ModPlacedFeatures.register(context, GOBBER_NETHER_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.NETHER_GOBBER_NETHER_ORE_KEY), ModOrePlacement.commonOrePlacement(8, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)5), (VerticalAnchor)VerticalAnchor.absolute((int)120))));
        ModPlacedFeatures.register(context, GOBBER_END_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.END_GOBBER_END_ORE_KEY), ModOrePlacement.commonOrePlacement(8, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)20), (VerticalAnchor)VerticalAnchor.absolute((int)120))));
        ModPlacedFeatures.register(context, LUCKY_BLOCK_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.OVERWORLD_LUCKY_BLOCK_KEY), ModOrePlacement.commonOrePlacement(12, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-60), (VerticalAnchor)VerticalAnchor.absolute((int)120))));
        ModPlacedFeatures.register(context, LUCKY_BLOCK_NETHER_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.NETHER_LUCKY_BLOCK_KEY), ModOrePlacement.commonOrePlacement(12, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)5), (VerticalAnchor)VerticalAnchor.absolute((int)120))));
        ModPlacedFeatures.register(context, LUCKY_BLOCK_END_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.END_LUCKY_BLOCK_KEY), ModOrePlacement.commonOrePlacement(12, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)20), (VerticalAnchor)VerticalAnchor.absolute((int)120))));
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gobber2", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }
}

