/*
 * Decompiled with CFR 0.152.
 */
package com.pla.pladailyboss.entity;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.pla.pladailyboss.config.PlaDailyBossConfig;
import com.pla.pladailyboss.data.BossLootData;
import com.pla.pladailyboss.data.DailyBossLoader;
import com.pla.pladailyboss.enums.KeyEntityState;
import com.pla.pladailyboss.event.RewardEvent;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class KeyEntity
extends Mob {
    private UUID summonedMobId;
    private String summonedMobRL;
    private KeyEntityState state;
    private long updatedStateTime;
    private boolean multiPhaseBoss = false;
    private final long rechargeCooldown = (Long)PlaDailyBossConfig.COOL_DOWN.get();
    private static final Random RANDOM = new Random();
    private static final Logger LOGGER = LogManager.getLogger();
    private List<String> phaseChain = Collections.emptyList();
    private int phaseIndex = -1;
    private boolean wfActive = false;
    private int wfMinX;
    private int wfMaxX;
    private int wfMinZ;
    private int wfMaxZ;
    private int wfStartY;
    private int wfMaxY;
    private int wfNextY;
    private long wfNextRunTick = 0L;
    private boolean wdActive = false;
    private int wdMinX;
    private int wdMaxX;
    private int wdMinZ;
    private int wdMaxZ;
    private static final int CLEAR_MARGIN = 10;
    private int wdNextY;
    private long wdNextRunTick = 0L;
    private static final int WF_PERIOD_TICKS = 10;
    private static final String NBT_PHASE_CHAIN = "PhaseChain";
    private static final String NBT_PHASE_INDEX = "PhaseIndex";
    private static final EntityDataAccessor<Integer> DATA_STATE = SynchedEntityData.defineId(KeyEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Long> UPDATED_STATE_TIME = SynchedEntityData.defineId(KeyEntity.class, (EntityDataSerializer)EntityDataSerializers.LONG);
    private static final EntityDataAccessor<Long> RECHARGE_COOLDOWN = SynchedEntityData.defineId(KeyEntity.class, (EntityDataSerializer)EntityDataSerializers.LONG);

    public void setSummonedMobId(UUID summonedMobId) {
        this.summonedMobId = summonedMobId;
    }

    public void setSummonedMobRL(String summonedMobRL) {
        this.summonedMobRL = summonedMobRL;
    }

    public void setPhaseChain(List<String> phaseChain) {
        this.phaseChain = phaseChain;
    }

    public String getSummonedMobRL() {
        return this.summonedMobRL;
    }

    public void setPhaseIndex(int phaseIndex) {
        this.phaseIndex = phaseIndex;
    }

    public void setMultiPhaseBoss(boolean multiPhaseBoss) {
        this.multiPhaseBoss = multiPhaseBoss;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_STATE, (Object)KeyEntityState.NORMAL.ordinal());
        builder.define(UPDATED_STATE_TIME, (Object)0L);
        builder.define(RECHARGE_COOLDOWN, (Object)0L);
    }

    public void startWaterFillBox() {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        double halfXZ = 30.0;
        int baseY = Mth.floor((double)this.getY());
        this.wfMinX = Mth.floor((double)(this.getX() - halfXZ));
        this.wfMaxX = Mth.floor((double)(this.getX() + halfXZ));
        this.wfMinZ = Mth.floor((double)(this.getZ() - halfXZ));
        this.wfMaxZ = Mth.floor((double)(this.getZ() + halfXZ));
        this.wfStartY = baseY;
        this.wfMaxY = baseY + 64 - 1;
        this.wfNextY = this.wfStartY;
        this.wfNextRunTick = sl.getGameTime();
        this.wfActive = true;
        this.wdActive = false;
    }

    public void startWaterClearBox() {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.wfMaxY <= this.wfStartY) {
            return;
        }
        this.wdMinX = this.wfMinX - 10;
        this.wdMaxX = this.wfMaxX + 10;
        this.wdMinZ = this.wfMinZ - 10;
        this.wdMaxZ = this.wfMaxZ + 10;
        this.wdNextY = Math.max(this.wfStartY, Math.min(this.wfMaxY, this.wfNextY - 1));
        this.wdNextRunTick = serverLevel.getGameTime();
        this.wdActive = true;
        this.wfActive = false;
    }

    public void stopAllWaterOps() {
        this.wfActive = false;
        this.wdActive = false;
    }

    private void stepWaterFillLayer(ServerLevel level) {
        int flags = 2;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int z = this.wfMinZ; z <= this.wfMaxZ; ++z) {
            for (int x = this.wfMinX; x <= this.wfMaxX; ++x) {
                pos.set(x, this.wfNextY, z);
                if (!level.hasChunkAt((BlockPos)pos)) continue;
                BlockState state = level.getBlockState((BlockPos)pos);
                if (state.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                    if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) continue;
                    level.setBlock((BlockPos)pos, (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)), 2);
                    continue;
                }
                if (!state.isAir()) continue;
                level.setBlock((BlockPos)pos, Blocks.WATER.defaultBlockState(), 2);
            }
        }
        ++this.wfNextY;
        if (this.wfNextY > this.wfMaxY) {
            this.wfActive = false;
        }
    }

    private void stepWaterClearLayer(ServerLevel level) {
        int flags = 2;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int z = this.wdMinZ; z <= this.wdMaxZ; ++z) {
            for (int x = this.wdMinX; x <= this.wdMaxX; ++x) {
                pos.set(x, this.wdNextY, z);
                if (!level.hasChunkAt((BlockPos)pos)) continue;
                BlockState state = level.getBlockState((BlockPos)pos);
                if (state.hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
                    level.setBlock((BlockPos)pos, (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)), 2);
                    continue;
                }
                if (state.getBlock() != Blocks.WATER) continue;
                level.setBlock((BlockPos)pos, Blocks.AIR.defaultBlockState(), 2);
            }
        }
        --this.wdNextY;
        if (this.wdNextY < this.wfStartY - 1) {
            this.wdActive = false;
        }
    }

    public KeyEntity(EntityType<? extends Mob> type, Level level) {
        super(type, level);
        this.noPhysics = true;
        this.setBoundingBox(new AABB(this.getX(), this.getY(), this.getZ(), this.getX(), this.getY(), this.getZ()));
        this.entityData.set(RECHARGE_COOLDOWN, (Object)this.rechargeCooldown);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        if (this.summonedMobId != null) {
            pCompound.putUUID("SummonedMobUUID", this.summonedMobId);
        }
        pCompound.putString("SummonedMobRL", this.summonedMobRL);
        pCompound.putString("KeyState", this.state.name());
        pCompound.putLong("UpdatedStateTime", this.updatedStateTime);
        pCompound.putBoolean("MultiPhaseBoss", this.multiPhaseBoss);
        if (this.phaseChain != null && !this.phaseChain.isEmpty()) {
            ListTag list = new ListTag();
            for (String id : this.phaseChain) {
                list.add((Object)StringTag.valueOf((String)id));
            }
            pCompound.put(NBT_PHASE_CHAIN, (Tag)list);
        }
        pCompound.putInt(NBT_PHASE_INDEX, this.phaseIndex);
        pCompound.putBoolean("wfActive", this.wfActive);
        pCompound.putInt("wfMinX", this.wfMinX);
        pCompound.putInt("wfMaxX", this.wfMaxX);
        pCompound.putInt("wfMinZ", this.wfMinZ);
        pCompound.putInt("wfMaxZ", this.wfMaxZ);
        pCompound.putInt("wfStartY", this.wfStartY);
        pCompound.putInt("wfMaxY", this.wfMaxY);
        pCompound.putInt("wfNextY", this.wfNextY);
        pCompound.putLong("wfNextRunTick", this.wfNextRunTick);
        pCompound.putBoolean("wdActive", this.wdActive);
        pCompound.putInt("wdNextY", this.wdNextY);
        pCompound.putLong("wdNextRunTick", this.wdNextRunTick);
        pCompound.putInt("wdMinX", this.wdMinX);
        pCompound.putInt("wdMaxX", this.wdMaxX);
        pCompound.putInt("wdMinZ", this.wdMinZ);
        pCompound.putInt("wdMaxZ", this.wdMaxZ);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("SummonedMobUUID")) {
            try {
                this.summonedMobId = pCompound.getUUID("SummonedMobUUID");
            }
            catch (Exception e) {
                this.summonedMobId = null;
            }
        } else {
            this.summonedMobId = null;
        }
        String string = this.summonedMobRL = pCompound.contains("SummonedMobRL") ? pCompound.getString("SummonedMobRL") : "";
        if (pCompound.contains("KeyState")) {
            try {
                this.state = KeyEntityState.valueOf(pCompound.getString("KeyState"));
            }
            catch (IllegalArgumentException e) {
                this.state = KeyEntityState.NORMAL;
            }
        } else {
            this.state = KeyEntityState.NORMAL;
        }
        this.updatedStateTime = pCompound.contains("UpdatedStateTime") ? pCompound.getLong("UpdatedStateTime") : 0L;
        this.multiPhaseBoss = pCompound.contains("MultiPhaseBoss") && pCompound.getBoolean("MultiPhaseBoss");
        this.entityData.set(DATA_STATE, (Object)this.state.ordinal());
        this.entityData.set(UPDATED_STATE_TIME, (Object)this.updatedStateTime);
        if (pCompound.contains(NBT_PHASE_CHAIN)) {
            ListTag list = pCompound.getList(NBT_PHASE_CHAIN, 8);
            ArrayList<String> loaded = new ArrayList<String>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                loaded.add(list.getString(i));
            }
            this.phaseChain = loaded.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(loaded);
        } else {
            this.phaseChain = Collections.emptyList();
        }
        int n = this.phaseIndex = pCompound.contains(NBT_PHASE_INDEX) ? pCompound.getInt(NBT_PHASE_INDEX) : -1;
        if (this.phaseIndex < -1) {
            this.phaseIndex = -1;
        }
        if (!this.phaseChain.isEmpty() && this.phaseIndex >= this.phaseChain.size()) {
            this.phaseIndex = this.phaseChain.size() - 1;
        }
        if (this.phaseChain.isEmpty()) {
            if (this.summonedMobRL != null && !this.summonedMobRL.isEmpty()) {
                this.phaseChain = Collections.singletonList(this.summonedMobRL);
                this.phaseIndex = 0;
            } else {
                this.phaseIndex = -1;
            }
        }
        if (this.multiPhaseBoss && (this.phaseChain.isEmpty() || this.phaseIndex < 0)) {
            this.tryRebuildPhaseChainFromData();
        }
        this.wfActive = pCompound.getBoolean("wfActive");
        this.wfMinX = pCompound.getInt("wfMinX");
        this.wfMaxX = pCompound.getInt("wfMaxX");
        this.wfMinZ = pCompound.getInt("wfMinZ");
        this.wfMaxZ = pCompound.getInt("wfMaxZ");
        this.wfStartY = pCompound.getInt("wfStartY");
        this.wfMaxY = pCompound.getInt("wfMaxY");
        this.wfNextY = pCompound.getInt("wfNextY");
        this.wfNextRunTick = pCompound.getLong("wfNextRunTick");
        this.wdActive = pCompound.getBoolean("wdActive");
        this.wdNextY = pCompound.getInt("wdNextY");
        this.wdNextRunTick = pCompound.getLong("wdNextRunTick");
        if (pCompound.contains("wdMinX")) {
            this.wdMinX = pCompound.getInt("wdMinX");
            this.wdMaxX = pCompound.getInt("wdMaxX");
            this.wdMinZ = pCompound.getInt("wdMinZ");
            this.wdMaxZ = pCompound.getInt("wdMaxZ");
        } else {
            this.wdMinX = this.wfMinX - 10;
            this.wdMaxX = this.wfMaxX + 10;
            this.wdMinZ = this.wfMinZ - 10;
            this.wdMaxZ = this.wfMaxZ + 10;
        }
    }

    private void tryRebuildPhaseChainFromData() {
        if (this.summonedMobRL == null || this.summonedMobRL.isEmpty()) {
            return;
        }
        for (Map.Entry<String, BossLootData> e : DailyBossLoader.BOSS_LOOT_TABLES.entrySet()) {
            BossLootData d = e.getValue();
            if (d == null || !d.isMultiPhase() || !d.phases.contains(this.summonedMobRL)) continue;
            this.phaseChain = List.copyOf(d.phases);
            this.phaseIndex = d.phases.indexOf(this.summonedMobRL);
            this.multiPhaseBoss = this.phaseIndex < this.phaseChain.size() - 1;
            return;
        }
        this.phaseChain = Collections.singletonList(this.summonedMobRL);
        this.phaseIndex = 0;
        this.multiPhaseBoss = false;
    }

    public void tick() {
        super.tick();
        Player player = this.level().getNearestPlayer((Entity)this, 10.0);
        if (player != null) {
            this.lookAt(EntityAnchorArgument.Anchor.EYES, player.position());
        }
        if (!this.level().isClientSide) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                long now = serverLevel.getGameTime();
                if (this.wfActive && now >= this.wfNextRunTick) {
                    this.stepWaterFillLayer(serverLevel);
                    this.wfNextRunTick = now + 10L;
                }
                if (this.wdActive && now >= this.wdNextRunTick) {
                    this.stepWaterClearLayer(serverLevel);
                    this.wdNextRunTick = now + 10L;
                }
            }
            if (this.state == KeyEntityState.DISAPPEARED && !this.isInvisible()) {
                this.setInvisible(true);
                this.setSilent(true);
                this.noPhysics = true;
            }
            if (this.state == KeyEntityState.DISABLED) {
                long now = System.currentTimeMillis();
                if (now - this.updatedStateTime >= this.rechargeCooldown) {
                    this.setState(KeyEntityState.NORMAL);
                }
                return;
            }
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.ENCHANT, this.getX(), this.getY() + 3.5, this.getZ(), 2, 0.2, 0.2, 0.2, 0.0);
            if (this.summonedMobId != null) {
                Entity entity = ((ServerLevel)this.level()).getEntity(this.summonedMobId);
                if (entity instanceof Mob) {
                    long now;
                    Mob mob = (Mob)entity;
                    double halfXZ = 30.0;
                    double upY = 62.0;
                    double y0 = this.getBoundingBox().minY;
                    AABB leash = new AABB(this.getX() - halfXZ, y0 - 1.0, this.getZ() - halfXZ, this.getX() + halfXZ, y0 + upY, this.getZ() + halfXZ);
                    if (!leash.intersects(mob.getBoundingBox())) {
                        mob.teleportTo(this.getX(), this.getY(), this.getZ());
                    }
                    if ((now = System.currentTimeMillis()) - this.updatedStateTime >= this.rechargeCooldown) {
                        mob.discard();
                        this.summonedMobId = null;
                        this.postProcessMob(this.summonedMobRL);
                        this.setState(KeyEntityState.NORMAL);
                    }
                } else if (this.multiPhaseBoss && this.phaseChain != null && !this.phaseChain.isEmpty() && this.phaseIndex >= 0 && this.phaseIndex < this.phaseChain.size() - 1) {
                    this.checkMob();
                } else {
                    List<Object> lootTables;
                    this.postProcessMob(this.summonedMobRL);
                    String lastId = this.summonedMobRL;
                    this.summonedMobRL = "";
                    this.summonedMobId = null;
                    this.phaseChain = Collections.emptyList();
                    this.phaseIndex = -1;
                    this.multiPhaseBoss = false;
                    this.setState(KeyEntityState.DISABLED);
                    BossLootData data = DailyBossLoader.BOSS_LOOT_TABLES.get(lastId);
                    List<Object> list = lootTables = data != null ? data.lootTables : Collections.emptyList();
                    if (!lootTables.isEmpty()) {
                        for (int i = 0; i < 5; ++i) {
                            String lootTableId = (String)lootTables.get(RANDOM.nextInt(lootTables.size()));
                            String[] parts = lootTableId.split(":", 2);
                            RewardEvent.dropLoot((ServerLevel)this.level(), ResourceLocation.fromNamespaceAndPath((String)parts[0], (String)parts[1]), this.getOnPos(), 1);
                        }
                    } else {
                        LOGGER.warn("[Daily Boss] No loot tables configured for '{}'; skipping loot drop.", (Object)lastId);
                    }
                    int xpAmount = 1395;
                    this.level().addFreshEntity((Entity)new ExperienceOrb(this.level(), (double)this.getOnPos().getX() + 0.5, (double)(this.getOnPos().getY() + 1), (double)this.getOnPos().getZ() + 0.5, xpAmount));
                }
            }
        }
    }

    private void postProcessMob(String spawnedMobId) {
        BossLootData data = DailyBossLoader.BOSS_LOOT_TABLES.get(spawnedMobId);
        if (data != null && data.isWater) {
            LOGGER.info("[Daily Boss DEBUG]: clearing water");
            this.startWaterClearBox();
        }
    }

    private ResourceLocation preProcessMob(String selectedMobId) {
        BossLootData data = DailyBossLoader.BOSS_LOOT_TABLES.get(selectedMobId);
        if (data != null && data.isWater) {
            this.startWaterFillBox();
        }
        if (data != null && data.isMultiPhase()) {
            this.phaseChain = new ArrayList<String>(data.phases);
            this.phaseIndex = 0;
            this.multiPhaseBoss = true;
            String[] parts = this.phaseChain.get(0).split(":", 2);
            return ResourceLocation.fromNamespaceAndPath((String)parts[0], (String)parts[1]);
        }
        this.phaseChain = Collections.singletonList(selectedMobId);
        this.phaseIndex = 0;
        this.multiPhaseBoss = false;
        String[] parts = selectedMobId.split(":", 2);
        return ResourceLocation.fromNamespaceAndPath((String)parts[0], (String)parts[1]);
    }

    private void processMob(String spawnedMobId, Mob mob, ServerPlayer player) {
    }

    private Mob customizeSpawnMob(String spawnedMobId, Player player) {
        return null;
    }

    private void checkMob() {
        if (this.phaseChain == null || this.phaseChain.isEmpty()) {
            return;
        }
        if (this.phaseIndex < 0 || this.phaseIndex >= this.phaseChain.size() - 1) {
            return;
        }
        String nextPhaseId = this.phaseChain.get(this.phaseIndex + 1);
        String[] parts = nextPhaseId.split(":", 2);
        double halfXZ = 32.0;
        double upY = 64.0;
        double y0 = this.getBoundingBox().minY;
        AABB area = new AABB(this.getX() - halfXZ, y0 - 1.0, this.getZ() - halfXZ, this.getX() + halfXZ, y0 + upY, this.getZ() + halfXZ);
        List nearby = this.level().getEntities((Entity)this, area, e -> Objects.equals(BuiltInRegistries.ENTITY_TYPE.getKey((Object)e.getType()), ResourceLocation.fromNamespaceAndPath((String)parts[0], (String)parts[1])));
        if (!nearby.isEmpty()) {
            Entity next = (Entity)nearby.get(0);
            this.summonedMobId = next.getUUID();
            this.summonedMobRL = nextPhaseId;
            ++this.phaseIndex;
            this.multiPhaseBoss = this.phaseIndex < this.phaseChain.size() - 1;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean spawnBoss(@NotNull Player player) {
        block8: {
            block9: {
                mobIds = DailyBossLoader.getListBasedOnKilledMob((ServerPlayer)player, player.getServer());
                if (mobIds.isEmpty()) {
                    player.displayClientMessage((Component)Component.literal((String)"You're too weak. Come back after you've defeated at least one boss or mini-boss.").withStyle((UnaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$spawnBoss$1(net.minecraft.network.chat.Style ), (Lnet/minecraft/network/chat/Style;)Lnet/minecraft/network/chat/Style;)()), true);
                    return false;
                }
                selectedMobId = ((String)PlaDailyBossConfig.FORCE_SPAWN.get()).isEmpty() == false ? (String)PlaDailyBossConfig.FORCE_SPAWN.get() : mobIds.get(KeyEntity.RANDOM.nextInt(mobIds.size()));
                mobRL = this.preProcessMob(selectedMobId);
                if (mobRL == null) {
                    return true;
                }
                type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(mobRL);
                usedCustomNBT = false;
                if (type == null || !((var8_7 = type.create(this.level())) instanceof Mob)) break block8;
                mob = (Mob)var8_7;
                lootData = DailyBossLoader.BOSS_LOOT_TABLES.get(selectedMobId);
                if (lootData == null || lootData.nbt == null || lootData.nbt.entrySet().isEmpty() || (tag = CompoundTag.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)lootData.nbt).resultOrPartial((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$spawnBoss$2(java.lang.String java.lang.String ), (Ljava/lang/String;)V)((String)selectedMobId)).orElse(new CompoundTag())).isEmpty()) break block9;
                tag.putString("id", mobRL.toString());
                loaded = EntityType.loadEntityRecursive((CompoundTag)tag, (Level)this.level(), (Function<Entity, Entity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$spawnBoss$3(net.minecraft.world.entity.Entity ), (Lnet/minecraft/world/entity/Entity;)Lnet/minecraft/world/entity/Entity;)((KeyEntity)this));
                if (!(loaded instanceof Mob)) ** GOTO lbl-1000
                loadedMob = (Mob)loaded;
                var13_12 = this.level();
                if (var13_12 instanceof ServerLevel) {
                    serverLevel = (ServerLevel)var13_12;
                    loadedMob.setPersistenceRequired();
                    loadedMob.setTarget((LivingEntity)player);
                    loadedMob.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(this.blockPosition()), MobSpawnType.COMMAND, (SpawnGroupData)null);
                    serverLevel.addFreshEntity((Entity)loadedMob);
                    this.summonedMobId = loadedMob.getUUID();
                    this.summonedMobRL = BuiltInRegistries.ENTITY_TYPE.getKey((Object)loadedMob.getType()).toString();
                    usedCustomNBT = true;
                    this.processMob(this.summonedMobRL, loadedMob, (ServerPlayer)player);
                } else if (loaded != null) {
                    KeyEntity.LOGGER.warn("[DailyBoss] Loaded entity from NBT is not a mob: {}", (Object)BuiltInRegistries.ENTITY_TYPE.getKey((Object)loaded.getType()));
                } else {
                    KeyEntity.LOGGER.warn("[DailyBoss] No entity was created from NBT for mob {}", (Object)selectedMobId);
                }
            }
            if (!usedCustomNBT && (loaded = this.level()) instanceof ServerLevel) {
                serverLevel = (ServerLevel)loaded;
                spawned = this.customizeSpawnMob(selectedMobId, player);
                if (spawned == null) {
                    mob.moveTo(this.getX(), this.getY(), this.getZ());
                    mob.setPersistenceRequired();
                    mob.setTarget((LivingEntity)player);
                    spawnedId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)type).toString();
                    mob.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(this.blockPosition()), MobSpawnType.COMMAND, (SpawnGroupData)null);
                    serverLevel.addFreshEntity((Entity)mob);
                    spawned = mob;
                    this.processMob(spawnedId, mob, (ServerPlayer)player);
                }
                this.summonedMobRL = selectedMobId;
                this.summonedMobId = spawned.getUUID();
            }
            this.level().playSound(null, this.blockPosition(), SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.setState(KeyEntityState.DISAPPEARED);
            return true;
        }
        return false;
    }

    @NotNull
    protected InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        if (!this.level().isClientSide && hand == InteractionHand.MAIN_HAND) {
            if (this.state == KeyEntityState.DISABLED) {
                long remaining = this.rechargeCooldown - (System.currentTimeMillis() - this.updatedStateTime);
                long seconds = remaining / 1000L % 60L;
                long minutes = remaining / 60000L % 60L;
                long hours = remaining / 3600000L;
                player.displayClientMessage((Component)Component.literal((String)("Come back after " + hours + "h " + minutes + "m " + seconds + "s")).withStyle(style -> style.withColor(0xFFFF00)), true);
                return InteractionResult.PASS;
            }
            if (this.state == KeyEntityState.DISAPPEARED) {
                return InteractionResult.PASS;
            }
            if (this.spawnBoss(player)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return super.mobInteract(player, hand);
    }

    public KeyEntityState getState() {
        if (this.level().isClientSide) {
            return KeyEntityState.values()[(Integer)this.entityData.get(DATA_STATE)];
        }
        return this.state;
    }

    public Long getUpdatedStateTime() {
        if (this.level().isClientSide) {
            return (Long)this.entityData.get(UPDATED_STATE_TIME);
        }
        return this.updatedStateTime;
    }

    public Long getRechargeCooldown() {
        if (this.level().isClientSide) {
            return (Long)this.entityData.get(RECHARGE_COOLDOWN);
        }
        return this.rechargeCooldown;
    }

    public void setState(KeyEntityState newState) {
        this.state = newState;
        this.entityData.set(DATA_STATE, (Object)newState.ordinal());
        if (newState == KeyEntityState.DISAPPEARED) {
            this.setInvisible(true);
            this.setSilent(true);
            this.noPhysics = true;
            this.updatedStateTime = System.currentTimeMillis();
            this.entityData.set(UPDATED_STATE_TIME, (Object)this.updatedStateTime);
            this.refreshDimensions();
        } else {
            this.setInvisible(false);
            this.setSilent(false);
            this.noPhysics = false;
            this.refreshDimensions();
        }
        if (!this.level().isClientSide) {
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.END_ROD, this.getX(), this.getY() + 1.0, this.getZ(), 20, 0.3, 0.3, 0.3, 0.01);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.0);
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        return false;
    }

    public boolean isInvulnerableTo(@NotNull DamageSource source) {
        return true;
    }

    public void knockback(double strength, double x, double z) {
    }

    public boolean isPushable() {
        return false;
    }

    public boolean isNoAi() {
        return true;
    }

    protected void doPush(@NotNull Entity other) {
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public void remove(@NotNull Entity.RemovalReason reason) {
        if (reason == Entity.RemovalReason.KILLED || reason == Entity.RemovalReason.DISCARDED) {
            return;
        }
        super.remove(reason);
    }

    public void die(@NotNull DamageSource cause) {
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    @NotNull
    public AABB getBoundingBoxForCulling() {
        return new AABB(this.getX(), this.getY(), this.getZ(), this.getX(), this.getY(), this.getZ());
    }

    public boolean canBeSeenAsEnemy() {
        return false;
    }

    public boolean isAttackable() {
        return false;
    }

    public boolean isPickable() {
        return this.state != KeyEntityState.DISAPPEARED;
    }

    private /* synthetic */ Entity lambda$spawnBoss$3(Entity e) {
        e.moveTo(this.getX(), this.getY(), this.getZ());
        return e;
    }

    private static /* synthetic */ void lambda$spawnBoss$2(String selectedMobId, String msg) {
        LOGGER.warn("[Daily Boss] Failed to parse NBT for mob {}: {}", (Object)selectedMobId, (Object)msg);
    }

    private static /* synthetic */ Style lambda$spawnBoss$1(Style style) {
        return style.withColor(0xFFFF00);
    }
}

