/*
 * Decompiled with CFR 0.152.
 */
package com.folumo.mekanism_lasers.common.block;

import com.folumo.mekanism_lasers.common.block_entity.LaserStopperBlockEntity;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.resource.BlockResourceInfo;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class LaserStopper
extends BlockTile.BlockTileModel<LaserStopperBlockEntity, BlockTypeTile<LaserStopperBlockEntity>> {
    public LaserStopper(BlockTypeTile<LaserStopperBlockEntity> type) {
        super(type, properties -> properties.mapColor(BlockResourceInfo.STEEL.getMapColor()));
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        TileEntityMekanism tile = (TileEntityMekanism)WorldUtils.getTileEntity(TileEntityMekanism.class, (BlockGetter)world, (BlockPos)pos);
        if (tile instanceof LaserStopperBlockEntity) {
            LaserStopperBlockEntity laserStopperBlockEntity = (LaserStopperBlockEntity)tile;
            Item item = stack.getItem();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                Block block = blockItem.getBlock();
                laserStopperBlockEntity.changeTexture(block.defaultBlockState());
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(stack, state, world, pos, player, hand, hit);
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        LaserStopperBlockEntity laserStopperBlockEntity;
        BlockState bState;
        TileEntityMekanism tile = (TileEntityMekanism)WorldUtils.getTileEntity(TileEntityMekanism.class, (BlockGetter)world, (BlockPos)pos);
        if (tile instanceof LaserStopperBlockEntity && (bState = (laserStopperBlockEntity = (LaserStopperBlockEntity)tile).getCurrentBlockState()) != null) {
            return bState.getCollisionShape(world, pos);
        }
        return super.getShape(state, world, pos, context);
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState p_60550_) {
        return RenderShape.INVISIBLE;
    }
}

