/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.jei;

import com.christofmeg.justenoughbreeding.recipe.BreedingRecipe;
import com.christofmeg.justenoughbreeding.utils.Utils;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.placement.VerticalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class BreedingCategory
extends AbstractRecipeCategory<BreedingRecipe>
implements IRecipeCategory<BreedingRecipe> {
    public static final RecipeType<BreedingRecipe> TYPE = new RecipeType(ResourceLocation.fromNamespaceAndPath((String)"justenoughbreeding", (String)"breeding"), BreedingRecipe.class);
    private final IDrawableStatic bigSlot;
    final int inputSlotItemX = 69;
    final int inputSlot1ItemY = 58;
    final int outputSlotItemX = 130;
    final int outputSlotItemY = 48;
    final int inputSlot2ItemY = 33;

    public BreedingCategory(IGuiHelper helper, ItemLike itemStack) {
        super(TYPE, (Component)Component.translatable((String)"translation.justenoughbreeding.breeding"), helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(itemStack)), 166, 91);
        this.bigSlot = helper.getOutputSlot();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BreedingRecipe recipe, @NotNull IFocusGroup focuses) {
        boolean hasOutput;
        builder.addInputSlot(149, 1).setStandardSlotBackground().addItemStack(recipe.spawnEgg);
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(recipe.spawnEgg);
        IRecipeSlotBuilder inputSlot = (IRecipeSlotBuilder)((IRecipeSlotBuilder)builder.addInputSlot(69, 58).setStandardSlotBackground().addIngredients(recipe.breedingCatalyst)).setPosition(63, 20, 103, 71, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        boolean hasExtraInput = recipe.extraInputStack != null && !recipe.extraInputStack.isEmpty();
        boolean bl = hasOutput = recipe.resultItemStack != null && !recipe.resultItemStack.isEmpty();
        if (hasOutput) {
            inputSlot.setPosition(74, 38, 78, 35, HorizontalAlignment.LEFT, VerticalAlignment.CENTER);
            ((IRecipeSlotBuilder)builder.addOutputSlot(130, 48).setOutputSlotBackground().addIngredients(recipe.resultItemStack)).setPosition(72, 38, 78, 35, HorizontalAlignment.RIGHT, VerticalAlignment.CENTER);
            if (hasExtraInput) {
                inputSlot.setPosition(74, 38, 78, 35, HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM);
                ((IRecipeSlotBuilder)builder.addInputSlot(69, 33).setStandardSlotBackground().addIngredients(recipe.extraInputStack)).setPosition(74, 38, 78, 35, HorizontalAlignment.LEFT, VerticalAlignment.TOP);
            }
        } else if (hasExtraInput) {
            inputSlot.setPosition(63, 10, 103, 71, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
            ((IRecipeSlotBuilder)builder.addInputSlot(69, 33).setStandardSlotBackground().addIngredients(recipe.extraInputStack)).setPosition(63, 29, 103, 71, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        }
    }

    public void createRecipeExtras(@NotNull IRecipeExtrasBuilder builder, @NotNull BreedingRecipe recipe, @NotNull IFocusGroup focuses) {
        if (recipe.resultItemStack != null && !recipe.resultItemStack.isEmpty()) {
            builder.addRecipeArrow().setPosition(69, 38, 78, 35, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        }
    }

    public void draw(@NotNull BreedingRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics stack, double mouseX, double mouseY) {
        int mobSlotX = 0;
        int mobSlotY = 10;
        this.bigSlot.draw(stack, mobSlotX, mobSlotY, 0, 1, 0, 1);
        this.bigSlot.draw(stack, mobSlotX + 18, mobSlotY, 0, 1, 1, 1);
        this.bigSlot.draw(stack, mobSlotX + 32, mobSlotY, 0, 1, 1, 1);
        this.bigSlot.draw(stack, mobSlotX + 35, mobSlotY, 0, 1, 22, 0);
        this.bigSlot.draw(stack, mobSlotX, mobSlotY + 24, 1, 1, 0, 1);
        this.bigSlot.draw(stack, mobSlotX + 18, mobSlotY + 24, 1, 1, 1, 1);
        this.bigSlot.draw(stack, mobSlotX + 32, mobSlotY + 24, 1, 1, 1, 1);
        this.bigSlot.draw(stack, mobSlotX + 35, mobSlotY + 24, 1, 1, 22, 0);
        this.bigSlot.draw(stack, mobSlotX, mobSlotY + 48, 1, 1, 0, 1);
        this.bigSlot.draw(stack, mobSlotX + 18, mobSlotY + 48, 1, 1, 1, 1);
        this.bigSlot.draw(stack, mobSlotX + 32, mobSlotY + 48, 1, 1, 1, 1);
        this.bigSlot.draw(stack, mobSlotX + 35, mobSlotY + 48, 1, 1, 22, 0);
        this.bigSlot.draw(stack, mobSlotX, mobSlotY + 55, 18, 0, 0, 1);
        this.bigSlot.draw(stack, mobSlotX + 18, mobSlotY + 55, 18, 0, 1, 1);
        this.bigSlot.draw(stack, mobSlotX + 32, mobSlotY + 55, 18, 0, 1, 1);
        this.bigSlot.draw(stack, mobSlotX + 35, mobSlotY + 55, 18, 0, 22, 0);
        EntityType<?> entityType = recipe.entityType;
        if (entityType != null) {
            LivingEntity currentLivingEntity;
            Font font = Minecraft.getInstance().font;
            MutableComponent entityName = Component.translatable((String)entityType.getDescriptionId());
            Object entityNameString = entityName.getString();
            if (recipe.needsToBeTamed != null) {
                MutableComponent tamed = Component.translatable((String)"translation.justenoughbreeding.tamed");
                entityNameString = (String)entityNameString + " (" + tamed.getString() + ")";
            } else if (recipe.animalTrusting != null) {
                MutableComponent trusting = Component.translatable((String)"translation.justenoughbreeding.trusting");
                entityNameString = (String)entityNameString + " (" + trusting.getString() + ")";
            }
            int stringWidth = font.width((String)entityNameString);
            int availableWidth = 148;
            if (stringWidth > availableWidth) {
                float pixelWidthPerCharacter = (float)stringWidth / (float)((String)entityNameString).length();
                int maxCharacters = (int)((float)availableWidth / pixelWidthPerCharacter);
                entityNameString = ((String)entityNameString).substring(0, maxCharacters);
            }
            if (!((String)entityNameString).isEmpty()) {
                Component abbreviatedEntityName = Component.nullToEmpty((String)entityNameString);
                stack.drawString(font, abbreviatedEntityName, 0, 0, DyeColor.BLACK.getTextColor(), false);
            }
            if ((currentLivingEntity = recipe.doRendering()) != null) {
                Utils.renderEntity(stack.pose(), mouseX, currentLivingEntity);
            }
        }
    }
}

