/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.api.util;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenCustomHashMap;
import java.util.Collection;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import team.chisel.ctm.api.texture.ICTMTexture;
import team.chisel.ctm.api.texture.ITextureContext;
import team.chisel.ctm.client.util.IdentityStrategy;
import team.chisel.ctm.client.util.ProfileUtil;

@ParametersAreNonnullByDefault
public class RenderContextList {
    private final Map<ICTMTexture<?>, ITextureContext> contextMap = Maps.newIdentityHashMap();
    private final Object2LongMap<ICTMTexture<?>> serialized = new Object2LongOpenCustomHashMap(new IdentityStrategy());

    public RenderContextList(BlockState state, Collection<ICTMTexture<?>> textures, BlockAndTintGetter world, BlockPos pos) {
        ProfileUtil.start("ctm_region_cache_update");
        ProfileUtil.endAndStart("ctm_context_gather");
        for (ICTMTexture<?> iCTMTexture : textures) {
            Object type = iCTMTexture.getType();
            ITextureContext ctx = type.getBlockRenderContext(state, world, pos, iCTMTexture);
            if (ctx == null) continue;
            this.contextMap.put(iCTMTexture, ctx);
        }
        ProfileUtil.endAndStart("ctm_context_serialize");
        for (Map.Entry entry : this.contextMap.entrySet()) {
            this.serialized.put((Object)((ICTMTexture)entry.getKey()), ((ITextureContext)entry.getValue()).getCompressedData());
        }
        ProfileUtil.end();
    }

    @Nullable
    public ITextureContext getRenderContext(ICTMTexture<?> tex) {
        return this.contextMap.get(tex);
    }

    public boolean contains(ICTMTexture<?> tex) {
        return this.getRenderContext(tex) != null;
    }

    public Object2LongMap<ICTMTexture<?>> serialized() {
        return this.serialized;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RenderContextList)) {
            return false;
        }
        RenderContextList other = (RenderContextList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object2LongMap<ICTMTexture<?>> this$serialized = this.serialized;
        Object2LongMap<ICTMTexture<?>> other$serialized = other.serialized;
        return !(this$serialized == null ? other$serialized != null : !this$serialized.equals(other$serialized));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RenderContextList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object2LongMap<ICTMTexture<?>> $serialized = this.serialized;
        result = result * 59 + ($serialized == null ? 43 : $serialized.hashCode());
        return result;
    }
}

