/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.texture;

import com.google.common.collect.ObjectArrays;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.chisel.ctm.CTM;
import team.chisel.ctm.api.texture.ICTMTexture;
import team.chisel.ctm.api.texture.ITextureType;
import team.chisel.ctm.api.util.TextureInfo;
import team.chisel.ctm.client.texture.type.TextureTypeRegistry;
import team.chisel.ctm.client.util.BlockRenderLayer;
import team.chisel.ctm.client.util.ResourceUtil;

@ParametersAreNonnullByDefault
public interface IMetadataSectionCTM {
    public static final String SECTION_NAME = "ctm";

    public int getVersion();

    public ITextureType getType();

    public BlockRenderLayer getLayer();

    public ResourceLocation[] getAdditionalTextures();

    @Nullable
    public String getProxy();

    public JsonObject getExtraData();

    default public ICTMTexture<?> makeTexture(TextureAtlasSprite sprite, Function<Material, TextureAtlasSprite> bakedTextureGetter) {
        boolean hasProxy;
        IMetadataSectionCTM meta = this;
        boolean bl = hasProxy = this.getProxy() != null;
        if (hasProxy) {
            TextureAtlasSprite proxySprite = bakedTextureGetter.apply(new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.parse((String)this.getProxy())));
            try {
                meta = ResourceUtil.getMetadata(proxySprite).orElse(new V1());
                sprite = proxySprite;
            }
            catch (IOException e) {
                CTM.logger.error("Could not parse metadata of proxy, ignoring proxy and using base texture. {}", (Object)this.getProxy(), (Object)e);
                meta = this;
                hasProxy = false;
            }
        }
        return meta.getType().makeTexture(new TextureInfo((TextureAtlasSprite[])Arrays.stream((ResourceLocation[])ObjectArrays.concat((Object)sprite.contents().name(), (Object[])meta.getAdditionalTextures())).map(rl -> new Material(TextureAtlas.LOCATION_BLOCKS, rl)).map(bakedTextureGetter).toArray(TextureAtlasSprite[]::new), Optional.of(meta.getExtraData()), meta.getLayer(), hasProxy));
    }

    public static class V1
    implements IMetadataSectionCTM {
        private ITextureType type = TextureTypeRegistry.getType("NORMAL");
        private BlockRenderLayer layer = null;
        private String proxy;
        private ResourceLocation[] additionalTextures = new ResourceLocation[0];
        private JsonObject extraData = new JsonObject();

        @Override
        public int getVersion() {
            return 1;
        }

        public static IMetadataSectionCTM fromJson(JsonObject obj) throws JsonParseException {
            JsonElement texturesEle;
            JsonElement layerEle;
            JsonElement typeEle;
            V1 ret = new V1();
            if (obj.has("proxy")) {
                JsonElement proxyEle = obj.get("proxy");
                if (proxyEle.isJsonPrimitive() && proxyEle.getAsJsonPrimitive().isString()) {
                    ret.proxy = proxyEle.getAsString();
                }
                if (obj.entrySet().stream().filter(e -> ((String)e.getKey()).equals("ctm_version")).count() > 1L) {
                    throw new JsonParseException("Cannot define other fields when using proxy");
                }
            }
            if (obj.has("type") && (typeEle = obj.get("type")).isJsonPrimitive() && typeEle.getAsJsonPrimitive().isString()) {
                ITextureType type = TextureTypeRegistry.getType(typeEle.getAsString());
                if (type == null) {
                    throw new JsonParseException("Invalid render type given: " + String.valueOf(typeEle));
                }
                ret.type = type;
            }
            if (obj.has("layer") && (layerEle = obj.get("layer")).isJsonPrimitive() && layerEle.getAsJsonPrimitive().isString()) {
                try {
                    ret.layer = BlockRenderLayer.valueOf(layerEle.getAsString());
                }
                catch (IllegalArgumentException e2) {
                    throw new JsonParseException("Invalid block layer given: " + String.valueOf(layerEle));
                }
            }
            if (obj.has("textures") && (texturesEle = obj.get("textures")).isJsonArray()) {
                JsonArray texturesArr = texturesEle.getAsJsonArray();
                ret.additionalTextures = new ResourceLocation[texturesArr.size()];
                for (int i = 0; i < texturesArr.size(); ++i) {
                    JsonElement e3 = texturesArr.get(i);
                    if (!e3.isJsonPrimitive() || !e3.getAsJsonPrimitive().isString()) continue;
                    ret.additionalTextures[i] = ResourceLocation.parse((String)e3.getAsString());
                }
            }
            if (obj.has("extra") && obj.get("extra").isJsonObject()) {
                ret.extraData = obj.getAsJsonObject("extra");
            }
            return ret;
        }

        public String toString() {
            return "IMetadataSectionCTM.V1(type=" + String.valueOf(this.getType()) + ", layer=" + String.valueOf((Object)this.getLayer()) + ", proxy=" + this.getProxy() + ", additionalTextures=" + Arrays.deepToString(this.getAdditionalTextures()) + ", extraData=" + String.valueOf(this.getExtraData()) + ")";
        }

        @Override
        public ITextureType getType() {
            return this.type;
        }

        @Override
        public BlockRenderLayer getLayer() {
            return this.layer;
        }

        @Override
        public String getProxy() {
            return this.proxy;
        }

        @Override
        public ResourceLocation[] getAdditionalTextures() {
            return this.additionalTextures;
        }

        @Override
        public JsonObject getExtraData() {
            return this.extraData;
        }
    }

    public static class Serializer
    implements MetadataSectionSerializer<IMetadataSectionCTM> {
        @Nullable
        public IMetadataSectionCTM fromJson(@Nullable JsonObject json) throws JsonParseException {
            if (json != null && json.isJsonObject()) {
                JsonObject obj = json.getAsJsonObject();
                if (obj.has("ctm_version")) {
                    JsonElement version = obj.get("ctm_version");
                    if (version.isJsonPrimitive() && version.getAsJsonPrimitive().isNumber()) {
                        switch (version.getAsInt()) {
                            case 1: {
                                return V1.fromJson(obj);
                            }
                        }
                    }
                } else {
                    throw new JsonParseException("Found ctm section without ctm_version");
                }
            }
            return null;
        }

        @NotNull
        public String getMetadataSectionName() {
            return IMetadataSectionCTM.SECTION_NAME;
        }
    }
}

