/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import net.minecraft.core.Direction;

public final class DirectionHelper {
    public static Direction rotateAround(Direction dir, Direction.Axis axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> {
                if (dir != Direction.WEST && dir != Direction.EAST) {
                    yield DirectionHelper.rotateX(dir);
                }
                yield dir;
            }
            case Direction.Axis.Y -> {
                if (dir != Direction.UP && dir != Direction.DOWN) {
                    yield dir.getClockWise();
                }
                yield dir;
            }
            case Direction.Axis.Z -> dir != Direction.NORTH && dir != Direction.SOUTH ? DirectionHelper.rotateZ(dir) : dir;
        };
    }

    public static Direction rotateX(Direction dir) {
        return switch (dir) {
            case Direction.NORTH -> Direction.DOWN;
            case Direction.SOUTH -> Direction.UP;
            case Direction.UP -> Direction.NORTH;
            case Direction.DOWN -> Direction.SOUTH;
            default -> throw new IllegalStateException("Unable to get X-rotated facing of " + String.valueOf(dir));
        };
    }

    public static Direction rotateZ(Direction dir) {
        return switch (dir) {
            case Direction.EAST -> Direction.DOWN;
            case Direction.WEST -> Direction.UP;
            case Direction.UP -> Direction.EAST;
            case Direction.DOWN -> Direction.WEST;
            default -> throw new IllegalStateException("Unable to get Z-rotated facing of " + String.valueOf(dir));
        };
    }

    private DirectionHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

