/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.api.common.world.structure.processor;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.FluidState;
import net.valhelsia.valhelsia_core.core.registry.ValhelsiaStructureProcessors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveWaterProcessor
extends StructureProcessor {
    public static final RemoveWaterProcessor INSTANCE = new RemoveWaterProcessor();
    public static final MapCodec<RemoveWaterProcessor> CODEC = MapCodec.unit(() -> INSTANCE);

    private RemoveWaterProcessor() {
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo processBlock(@NotNull LevelReader level, @NotNull BlockPos jigsawPiecePos, @NotNull BlockPos jigsawPieceBottomCenterPos, @NotNull StructureTemplate.StructureBlockInfo blockInfoLocal, @NotNull StructureTemplate.StructureBlockInfo blockInfoGlobal, @NotNull StructurePlaceSettings settings) {
        if (blockInfoGlobal.state().hasProperty((Property)BlockStateProperties.WATERLOGGED) && !((Boolean)blockInfoGlobal.state().getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            ChunkPos chunkPos = new ChunkPos(blockInfoGlobal.pos());
            ChunkAccess chunk = level.getChunk(chunkPos.x, chunkPos.z);
            int sectionIndex = chunk.getSectionIndex(blockInfoGlobal.pos().getY());
            if (sectionIndex < 0) {
                return blockInfoGlobal;
            }
            LevelChunkSection section = chunk.getSection(sectionIndex);
            if (this.getFluidState(section, blockInfoGlobal.pos()).is(FluidTags.WATER)) {
                this.setBlock(section, blockInfoGlobal.pos(), blockInfoGlobal.state());
            }
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (Direction direction : Direction.values()) {
                BlockState state;
                mutable.set((Vec3i)blockInfoGlobal.pos()).move(direction);
                if (chunkPos.x != mutable.getX() >> 4 || chunkPos.z != mutable.getZ() >> 4) {
                    chunkPos = new ChunkPos((BlockPos)mutable);
                    chunk = level.getChunk(chunkPos.x, chunkPos.z);
                    sectionIndex = chunk.getSectionIndex(mutable.getY());
                    if (sectionIndex < 0) {
                        return blockInfoGlobal;
                    }
                    section = chunk.getSection(sectionIndex);
                }
                if (!this.getFluidState(section, (BlockPos)mutable).is(FluidTags.WATER) || (state = level.getBlockState((BlockPos)mutable)).hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) continue;
                this.setBlock(section, (BlockPos)mutable, Blocks.STONE.defaultBlockState());
            }
        }
        return blockInfoGlobal;
    }

    private void setBlock(LevelChunkSection section, BlockPos pos, BlockState state) {
        section.setBlockState(SectionPos.sectionRelative((int)pos.getX()), SectionPos.sectionRelative((int)pos.getY()), SectionPos.sectionRelative((int)pos.getZ()), state);
    }

    private FluidState getFluidState(LevelChunkSection section, BlockPos pos) {
        return section.getFluidState(SectionPos.sectionRelative((int)pos.getX()), SectionPos.sectionRelative((int)pos.getY()), SectionPos.sectionRelative((int)pos.getZ()));
    }

    @NotNull
    protected StructureProcessorType<?> getType() {
        return ValhelsiaStructureProcessors.REMOVE_WATER.get();
    }
}

