/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.api.book;

import com.mojang.serialization.Codec;
import net.favouriteless.modopedia.api.book.BookType;
import net.favouriteless.modopedia.book.BookImpl;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.CreativeModeTab;
import org.jetbrains.annotations.Nullable;

public interface Book {
    public BookType getType();

    public String getTitle();

    @Nullable
    public String getSubtitle();

    @Nullable
    public String getRawLandingText();

    public ResourceLocation getTexture();

    public ResourceLocation getItemModelLocation();

    public Holder<SoundEvent> getOpenSound();

    public Holder<SoundEvent> getFlipSound();

    public ResourceLocation getFont();

    public int getTextColour();

    public int getHeaderColour();

    public int getLineWidth();

    @Nullable
    public ResourceKey<CreativeModeTab> getCreativeTab();

    public static Codec<Book> persistentCodec() {
        return BookImpl.PERSISTENT_CODEC;
    }

    public static StreamCodec<RegistryFriendlyByteBuf, Book> streamCodec() {
        return BookImpl.STREAM_CODEC;
    }
}

