/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.book;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.Lookup;
import net.favouriteless.modopedia.api.Variable;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.page_components.PageComponent;
import net.favouriteless.modopedia.api.registries.common.BookRegistry;
import net.favouriteless.modopedia.book.variables.VariableLookup;
import net.favouriteless.modopedia.client.page_components.ErrorPageComponent;
import net.minecraft.world.level.Level;

public class PageComponentHolder
implements Lookup.MutableLookup {
    private final Map<PageComponent, Lookup> components = new LinkedHashMap<PageComponent, Lookup>();
    private final VariableLookup lookup = new VariableLookup();

    public void addComponent(PageComponent component, Lookup lookup) {
        this.components.put(component, lookup);
    }

    public void initComponents(Book book, String entryId, Level level) {
        HashMap<Lookup, String> malformedComponents = new HashMap<Lookup, String>();
        Iterator<Map.Entry<PageComponent, Lookup>> iterator = this.components.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<PageComponent, Lookup> entry = iterator.next();
            try {
                entry.getKey().init(book, entry.getValue(), level);
            }
            catch (Exception e2) {
                iterator.remove();
                malformedComponents.put(entry.getValue(), e2.getMessage());
                Modopedia.LOG.error("Error loading PageComponent of type {} for entry {} of book {}: {}", new Object[]{entry.getKey().getClass().getName(), entryId, BookRegistry.get().getId(book), e2.getMessage()});
            }
        }
        malformedComponents.forEach((l, e) -> {
            ErrorPageComponent component = new ErrorPageComponent((String)e);
            this.components.put(component, (Lookup)l);
            component.init(book, (Lookup)l, level);
        });
    }

    public Set<PageComponent> getComponents() {
        return this.components.keySet();
    }

    public PageComponent getComponent(int index) {
        return ((PageComponent[])this.components.keySet().toArray(PageComponent[]::new))[index];
    }

    @Override
    public Variable set(String key, Variable variable) {
        return this.lookup.set(key, variable);
    }

    @Override
    public Variable get(String key) {
        return this.lookup.get(key);
    }

    @Override
    public Variable getOrDefault(String key, Object def) {
        return this.lookup.getOrDefault(key, def);
    }

    @Override
    public boolean has(String key) {
        return this.lookup.has(key);
    }

    @Override
    public Collection<String> keys() {
        return this.lookup.keys();
    }
}

