/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.book.loading;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.Variable;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.BookContent;
import net.favouriteless.modopedia.api.book.Category;
import net.favouriteless.modopedia.api.book.Entry;
import net.favouriteless.modopedia.api.book.Page;
import net.favouriteless.modopedia.api.book.page_components.PageComponent;
import net.favouriteless.modopedia.api.registries.client.BookContentRegistry;
import net.favouriteless.modopedia.api.registries.client.PageComponentRegistry;
import net.favouriteless.modopedia.api.registries.client.TemplateRegistry;
import net.favouriteless.modopedia.api.registries.common.BookRegistry;
import net.favouriteless.modopedia.book.BookContentImpl;
import net.favouriteless.modopedia.book.CategoryImpl;
import net.favouriteless.modopedia.book.EntryImpl;
import net.favouriteless.modopedia.book.PageComponentHolder;
import net.favouriteless.modopedia.book.PageImpl;
import net.favouriteless.modopedia.book.Template;
import net.favouriteless.modopedia.book.loading.BookTextureLoader;
import net.favouriteless.modopedia.book.loading.MultiblockLoader;
import net.favouriteless.modopedia.book.loading.TemplateLoader;
import net.favouriteless.modopedia.book.variables.JsonVariable;
import net.favouriteless.modopedia.book.variables.RemoteVariable;
import net.favouriteless.modopedia.book.variables.VariableLookup;
import net.favouriteless.modopedia.client.ScreenCacheImpl;
import net.favouriteless.modopedia.client.page_components.GalleryPageComponent;
import net.favouriteless.modopedia.client.page_components.TemplatePageComponent;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;

public class BookContentLoader {
    public static final String BOOK_DIR = "modopedia/books";
    public static final String TEMPLATE_DIR = "modopedia/templates";
    public static final String BOOK_TEX_DIR = "modopedia/book_textures";
    public static final String MULTIBLOCK_DIR = "modopedia/multiblocks";
    private static final Gson GSON = new Gson();
    private static final TemplateLoader templateLoader = new TemplateLoader(GSON, "modopedia/templates");
    private static final BookTextureLoader textureLoader = new BookTextureLoader(GSON, "modopedia/book_textures");
    private static final MultiblockLoader multiblockLoader = new MultiblockLoader(GSON, "modopedia/multiblocks");

    public static void reloadAll() {
        ScreenCacheImpl.INSTANCE.clear();
        BookContentLoader.reload((ResourceManager manager, Level level) -> BookRegistry.get().getBookIds().forEach(id -> BookContentLoader.reloadBook(id, manager, level)));
    }

    public static void reload(ResourceLocation id) {
        ScreenCacheImpl.INSTANCE.remove(id);
        BookContentLoader.reload((ResourceManager manager, Level level) -> BookContentLoader.reloadBook(id, manager, level));
    }

    private static void reload(BiConsumer<ResourceManager, Level> reloader) {
        Minecraft mc = Minecraft.getInstance();
        ResourceManager rm = mc.getResourceManager();
        if (mc.level != null) {
            BookContentLoader.preReload(rm).thenRun(() -> reloader.accept(rm, (Level)mc.level));
        }
    }

    private static CompletableFuture<Void> preReload(ResourceManager manager) {
        return CompletableFuture.allOf(templateLoader.reload(manager), textureLoader.reload(manager), multiblockLoader.reload(manager));
    }

    private static CompletableFuture<Void> reloadBook(ResourceLocation id, ResourceManager manager, Level level) {
        Book book = BookRegistry.get().getBook(id);
        if (book == null) {
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> BookContentLoader.getBookResources(id, manager), Util.backgroundExecutor()).thenApplyAsync(map -> BookContentLoader.parseBookResources(map, book, level), (Executor)Util.backgroundExecutor())).thenAcceptAsync(content -> {
            BookContentRegistry.get().register(id, new BookContentImpl((Map<String, BookContent.LocalisedBookContent>)content));
            Modopedia.LOG.info("Reloaded book: {}", (Object)id);
        }, (Executor)Minecraft.getInstance());
    }

    private static Map<ResourceLocation, JsonElement> getBookResources(ResourceLocation bookId, ResourceManager manager) {
        HashMap<ResourceLocation, JsonElement> out = new HashMap<ResourceLocation, JsonElement>();
        FileToIdConverter converter = FileToIdConverter.json((String)("modopedia/books/" + bookId.getPath()));
        for (Map.Entry entry : converter.listMatchingResources(manager).entrySet()) {
            try {
                BufferedReader reader = ((Resource)entry.getValue()).openAsReader();
                try {
                    out.put(converter.fileToId((ResourceLocation)entry.getKey()), (JsonElement)GsonHelper.fromJson((Gson)GSON, (Reader)reader, JsonElement.class));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                Modopedia.LOG.error("Error trying to fetch resource {}: {}", entry.getKey(), (Object)exception);
            }
        }
        return out;
    }

    private static Map<String, BookContent.LocalisedBookContent> parseBookResources(Map<ResourceLocation, JsonElement> jsonMap, Book book, Level level) {
        HashMap<String, BookContentImpl.LocalisedBookContentImpl> content = new HashMap<String, BookContentImpl.LocalisedBookContentImpl>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsonMap.entrySet()) {
            String[] splitPath = entry.getKey().getPath().split("/", 3);
            if (splitPath.length < 3) {
                Modopedia.LOG.error("Invalid book resource found: {}", (Object)entry.getKey());
                continue;
            }
            String language = splitPath[0];
            String type = splitPath[1];
            String id = splitPath[2];
            if (type.equals("categories")) {
                BookContentLoader.loadCategory(entry.getValue(), book, language, id, level, content.computeIfAbsent(language, k -> BookContentImpl.LocalisedBookContentImpl.create()).categories());
                continue;
            }
            if (!type.equals("entries")) continue;
            BookContentLoader.loadEntry(entry.getValue(), book, language, id, level, content.computeIfAbsent(language, k -> BookContentImpl.LocalisedBookContentImpl.create()).entries());
        }
        return new HashMap<String, BookContent.LocalisedBookContent>(content);
    }

    private static void loadEntry(JsonElement json, Book book, String language, String id, Level level, Map<String, Entry> entries) {
        EntryImpl.CODEC.decode((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)level.registryAccess()), (Object)json).ifSuccess(p -> entries.put(id, ((EntryImpl)p.getFirst()).addPages(BookContentLoader.loadPages(id, json.getAsJsonObject().getAsJsonArray("pages"), book, language, level)))).ifError(e -> Modopedia.LOG.error("Error loading entry json {}: {}", (Object)id, (Object)e.message()));
    }

    private static void loadCategory(JsonElement json, Book book, String language, String id, Level level, Map<String, Category> categories) {
        CategoryImpl.CODEC.decode((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)level.registryAccess()), (Object)json).ifSuccess(p -> categories.put(id, ((CategoryImpl)p.getFirst()).init(book, language))).ifError(e -> Modopedia.LOG.error("Error loading entry {}: {}", (Object)id, (Object)e.message()));
    }

    private static List<Page> loadPages(String entry, JsonArray array, Book book, String language, Level level) {
        ArrayList<Page> out = new ArrayList<Page>();
        RegistryOps ops = level.registryAccess().createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        for (JsonElement element : array) {
            try {
                PageImpl page = new PageImpl(BookContentLoader.loadPageComponentHolder(entry, element.getAsJsonObject(), language, out.size(), (RegistryOps<JsonElement>)ops));
                page.init(book, entry, level);
                out.add(page);
            }
            catch (Exception e) {
                Modopedia.LOG.error("Error loading page for entry {}: {}", (Object)entry, (Object)e.getMessage());
            }
        }
        return out;
    }

    private static PageComponentHolder loadPageComponentHolder(String entry, JsonObject json, String language, int pageNum, RegistryOps<JsonElement> ops) {
        PageComponentHolder holder = new PageComponentHolder();
        holder.set("page_num", Variable.of(pageNum));
        holder.set("entry", Variable.of(entry));
        json.keySet().forEach(key -> {
            if (!key.equals("components")) {
                holder.set((String)key, JsonVariable.of(json.get(key), ops));
            }
        });
        if (!json.has("components")) {
            return holder;
        }
        JsonArray components = json.getAsJsonArray("components");
        if (components.isEmpty()) {
            return holder;
        }
        for (JsonElement element : components) {
            if (element.isJsonObject()) {
                BookContentLoader.loadComponent(entry, holder, element.getAsJsonObject(), language, pageNum, ops);
                continue;
            }
            Modopedia.LOG.error("Invalid component found in {}", (Object)entry);
        }
        return holder;
    }

    private static void loadComponent(String entry, PageComponentHolder holder, JsonObject json, String language, int pageNum, RegistryOps<JsonElement> ops) {
        PageComponent component;
        if (json.has("type")) {
            id = ResourceLocation.parse((String)json.get("type").getAsString());
            Supplier<PageComponent> type = PageComponentRegistry.get().get(id);
            if (type == null) {
                throw new JsonParseException(String.format("Error creating PageComponent: %s is not a registered component type", id));
            }
            component = type.get();
        } else if (json.has("template")) {
            id = ResourceLocation.parse((String)json.get("template").getAsString());
            Template template = TemplateRegistry.get().getTemplate(id);
            if (template == null) {
                throw new JsonParseException(String.format("Error creating PageComponent: %s is not a registered template", id));
            }
            component = new TemplatePageComponent(BookContentLoader.loadPageComponentHolder(entry, template.getData(), language, pageNum, ops));
        } else if (json.has("components")) {
            component = new GalleryPageComponent(BookContentLoader.loadPageComponentHolder(entry, json, language, pageNum, ops));
        } else {
            throw new JsonParseException("Error creating PageComponent: component does not have a type, template or gallery");
        }
        VariableLookup lookup = new VariableLookup();
        lookup.set("page_num", Variable.of(pageNum));
        lookup.set("entry", Variable.of(entry));
        lookup.set("language", Variable.of(language));
        for (String key : json.keySet()) {
            String val;
            JsonPrimitive primitive;
            if (key.equals("type")) continue;
            JsonElement element = json.get(key);
            if (element instanceof JsonPrimitive && (primitive = (JsonPrimitive)element).isString() && (val = primitive.getAsString()).startsWith("#")) {
                lookup.set(key, RemoteVariable.of(val.substring(1), holder));
                continue;
            }
            lookup.set(key, JsonVariable.of(element, ops));
        }
        holder.addComponent(component, lookup);
    }
}

