/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.book.variables;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.favouriteless.modopedia.api.Variable;
import net.favouriteless.modopedia.api.book.page_components.ItemDisplay;
import net.favouriteless.modopedia.api.multiblock.Multiblock;
import net.favouriteless.modopedia.book.text.Justify;
import net.favouriteless.modopedia.client.multiblock.BlockStateCodec;
import net.favouriteless.modopedia.util.common.MExtraCodecs;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class JsonVariable
implements Variable {
    private static final Map<TypeToken<?>, Codec<?>> tokenCodecs = new HashMap();
    private final JsonElement internal;
    private final RegistryOps<JsonElement> ops;
    private Object cached;

    private JsonVariable(JsonElement internal, RegistryOps<JsonElement> ops) {
        this.internal = internal;
        this.ops = ops;
    }

    @Override
    public <T> T as(Class<T> clazz) {
        return this.as(TypeToken.of(clazz));
    }

    @Override
    public <T> T as(TypeToken<T> token) {
        Codec<T> codec = JsonVariable.getCodec(token);
        if (codec == null) {
            throw new JsonParseException(String.format("Could not decode JsonVariable: %s does not have a codec.", token.getType().getTypeName()));
        }
        if (this.cached == null || token.getType() != this.cached.getClass()) {
            this.cached = codec.decode(this.ops, (Object)this.internal).resultOrPartial(error -> {
                throw new JsonParseException("Could not decode JsonVariable: " + error);
            }).map(Pair::getFirst).orElse(null);
        }
        return (T)this.cached;
    }

    @Override
    public int asInt() {
        return this.internal.getAsInt();
    }

    @Override
    public long asLong() {
        return this.internal.getAsLong();
    }

    @Override
    public float asFloat() {
        return this.internal.getAsFloat();
    }

    @Override
    public double asDouble() {
        return this.internal.getAsDouble();
    }

    @Override
    public boolean asBoolean() {
        return this.internal.getAsBoolean();
    }

    @Override
    public String asString() {
        return this.internal.getAsString();
    }

    @Override
    public Stream<Variable> asStream() {
        if (!this.internal.isJsonArray()) {
            throw new JsonParseException("Could not decode JsonVariable: Cannot convert non-array variable to a stream");
        }
        return StreamSupport.stream(this.internal.getAsJsonArray().spliterator(), false).map(element -> JsonVariable.of(element, this.ops));
    }

    public static <T> void registerCodec(Class<T> clazz, Codec<T> codec) {
        JsonVariable.registerCodec(TypeToken.of(clazz), codec);
    }

    public static <T> void registerCodec(TypeToken<T> token, Codec<T> codec) {
        tokenCodecs.put(token, codec);
    }

    public static Variable of(JsonElement internal, RegistryOps<JsonElement> ops) {
        return new JsonVariable(internal, ops);
    }

    private static <T> Codec<T> getCodec(TypeToken<T> token) {
        return tokenCodecs.get(token);
    }

    static {
        JsonVariable.registerCodec(ResourceLocation.class, ResourceLocation.CODEC);
        JsonVariable.registerCodec(CompoundTag.class, CompoundTag.CODEC);
        JsonVariable.registerCodec(ItemStack.class, ItemStack.CODEC);
        JsonVariable.registerCodec(ResourceLocation[].class, ResourceLocation.CODEC.listOf().xmap(l -> l.toArray(new ResourceLocation[0]), Arrays::asList));
        JsonVariable.registerCodec(CompoundTag[].class, CompoundTag.CODEC.listOf().xmap(l -> l.toArray(new CompoundTag[0]), Arrays::asList));
        JsonVariable.registerCodec(ItemStack[].class, MExtraCodecs.ITEM_LIST.xmap(l -> l.toArray(new ItemStack[0]), Arrays::asList));
        JsonVariable.registerCodec(new TypeToken<List<ResourceLocation>>(){}, ResourceLocation.CODEC.listOf());
        JsonVariable.registerCodec(new TypeToken<List<CompoundTag>>(){}, CompoundTag.CODEC.listOf());
        JsonVariable.registerCodec(new TypeToken<List<ItemStack>>(){}, ItemStack.CODEC.listOf());
        JsonVariable.registerCodec(new TypeToken<List<ItemStack>>(){}, MExtraCodecs.ITEM_LIST);
        JsonVariable.registerCodec(Multiblock.class, Multiblock.codec());
        JsonVariable.registerCodec(Justify.class, Justify.CODEC);
        JsonVariable.registerCodec(CompoundTag.class, CompoundTag.CODEC);
        JsonVariable.registerCodec(BlockState.class, BlockStateCodec.CODEC);
        JsonVariable.registerCodec(ItemDisplay.class, ItemDisplay.codec());
    }
}

