/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client;

import java.util.function.Function;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.ScreenCache;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.BookContent;
import net.favouriteless.modopedia.api.book.BookScreenFactory;
import net.favouriteless.modopedia.api.book.BookType;
import net.favouriteless.modopedia.api.registries.client.BookContentRegistry;
import net.favouriteless.modopedia.api.registries.client.BookScreenFactoryRegistry;
import net.favouriteless.modopedia.api.registries.common.BookRegistry;
import net.favouriteless.modopedia.client.screens.books.BookScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;

public class BookOpenHandler {
    public static void tryOpenBook(ResourceLocation id) {
        Book book = BookRegistry.get().getBook(id);
        if (book == null) {
            return;
        }
        String lang = Minecraft.getInstance().options.languageCode;
        BookScreen last = ScreenCache.get().getLastScreen(id, lang);
        BookContent.LocalisedBookContent content = BookContentRegistry.get().getContent(id, lang);
        if (content == null) {
            return;
        }
        BookType type = book.getType();
        BookOpenHandler.openBookScreen(BookOpenHandler.tryUseFactory(type, f -> last != null ? last : f.openLandingScreen(book, type, lang, content, null)));
    }

    public static void tryOpenCategory(ResourceLocation id, String category) {
        Book book = BookRegistry.get().getBook(id);
        if (book == null) {
            return;
        }
        String lang = Minecraft.getInstance().options.languageCode;
        BookScreen last = ScreenCache.get().getLastScreen(id, lang);
        BookContent.LocalisedBookContent content = BookContentRegistry.get().getContent(id, lang);
        if (content == null) {
            return;
        }
        BookType type = book.getType();
        BookOpenHandler.openBookScreen(BookOpenHandler.tryUseFactory(type, f -> f.openCategoryScreen(book, type, lang, content, category, last)));
    }

    public static void tryOpenEntry(ResourceLocation id, String entry) {
        Book book = BookRegistry.get().getBook(id);
        if (book == null) {
            return;
        }
        String lang = Minecraft.getInstance().options.languageCode;
        BookScreen last = ScreenCache.get().getLastScreen(id, lang);
        BookContent.LocalisedBookContent content = BookContentRegistry.get().getContent(id, lang);
        if (content == null) {
            return;
        }
        BookType type = book.getType();
        BookOpenHandler.openBookScreen(BookOpenHandler.tryUseFactory(type, f -> f.openEntryScreen(book, type, lang, content, entry, last)));
    }

    public static void tryOpenCategory(String category) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof BookScreen) {
            BookScreen screen2 = (BookScreen)screen;
            BookOpenHandler.tryOpenCategory(BookRegistry.get().getId(screen2.getBook()), category);
        }
    }

    public static void tryOpenEntry(String entry) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof BookScreen) {
            BookScreen screen2 = (BookScreen)screen;
            BookOpenHandler.tryOpenEntry(BookRegistry.get().getId(screen2.getBook()), entry);
        }
    }

    private static void openBookScreen(BookScreen<?> screen) {
        if (screen != null) {
            BookScreen s;
            Holder<SoundEvent> sound;
            Minecraft mc = Minecraft.getInstance();
            Book book = screen.getBook();
            Screen screen2 = mc.screen;
            Holder<SoundEvent> holder = sound = screen2 instanceof BookScreen && (s = (BookScreen)screen2).getBook() == book ? book.getFlipSound() : book.getOpenSound();
            if (sound != null) {
                mc.level.playSound((Player)mc.player, mc.player.getX(), mc.player.getY(), mc.player.getZ(), sound, SoundSource.MASTER, 0.3f, 1.0f);
            }
            Minecraft.getInstance().setScreen(screen);
        }
    }

    private static <T extends BookType> BookScreen<?> tryUseFactory(T type, Function<BookScreenFactory<T>, BookScreen<?>> user) {
        BookScreenFactory<T> factory = BookScreenFactoryRegistry.get().get(type);
        if (factory == null) {
            Modopedia.LOG.error("Could not find a BookScreenFactory for {}", (Object)type.type().id());
        }
        return factory != null ? user.apply(factory) : null;
    }
}

