/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.registries.common.BookRegistry;
import net.favouriteless.modopedia.common.MBookItem;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MBookModel
implements BakedModel {
    private final BakedModel defaultModel;
    private final ItemOverrides overrides;

    public MBookModel(BakedModel defaultModel, final Function<ResourceLocation, BakedModel> modelGetter) {
        this.defaultModel = defaultModel;
        this.overrides = new ItemOverrides(this, FakeModelBaker.INSTANCE, null, Collections.emptyList()){

            public BakedModel resolve(@NotNull BakedModel original, @NotNull ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
                Book book = BookRegistry.get().getBook(MBookItem.getBookId(stack));
                return book == null ? original : (BakedModel)modelGetter.apply(book.getItemModelLocation());
            }
        };
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, RandomSource random) {
        return this.defaultModel.getQuads(state, direction, random);
    }

    public boolean useAmbientOcclusion() {
        return this.defaultModel.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.defaultModel.isGui3d();
    }

    public boolean usesBlockLight() {
        return this.defaultModel.usesBlockLight();
    }

    public boolean isCustomRenderer() {
        return this.defaultModel.isCustomRenderer();
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.defaultModel.getParticleIcon();
    }

    public ItemTransforms getTransforms() {
        return this.defaultModel.getTransforms();
    }

    public ItemOverrides getOverrides() {
        return this.overrides;
    }

    private static class FakeModelBaker
    implements ModelBaker {
        private static final ModelBaker INSTANCE = new FakeModelBaker();

        private FakeModelBaker() {
        }

        public UnbakedModel getModel(ResourceLocation location) {
            return null;
        }

        @Nullable
        public BakedModel bake(ResourceLocation location, ModelState transform) {
            return null;
        }

        public UnbakedModel getTopLevelModel(ModelResourceLocation location) {
            return null;
        }

        public BakedModel bake(ResourceLocation location, ModelState state, Function<Material, TextureAtlasSprite> sprites) {
            return null;
        }

        public BakedModel bakeUncached(UnbakedModel model, ModelState state, Function<Material, TextureAtlasSprite> sprites) {
            return null;
        }

        public Function<Material, TextureAtlasSprite> getModelTextureGetter() {
            return null;
        }
    }
}

