/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.multiblock;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.favouriteless.modopedia.api.multiblock.Multiblock;
import net.favouriteless.modopedia.api.multiblock.MultiblockInstance;
import net.favouriteless.modopedia.api.multiblock.StateMatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class PlacedMultiblock
implements MultiblockInstance {
    public static final int TICKS_PER_STATE = 20;
    private final Multiblock multiblock;
    private final Level level;
    public BlockPos pos;
    private int ticks = 0;
    private final Map<BlockPos, BlockEntity> blockEntities = new HashMap<BlockPos, BlockEntity>();

    public PlacedMultiblock(Multiblock multiblock, Level level, BlockPos pos) {
        this.multiblock = multiblock;
        this.level = level;
        this.pos = pos;
    }

    public PlacedMultiblock(Multiblock multiblock, Level level) {
        this(multiblock, level, BlockPos.ZERO);
    }

    public float getShade(Direction direction, boolean shade) {
        return 1.0f;
    }

    public LevelLightEngine getLightEngine() {
        return null;
    }

    public int getBlockTint(BlockPos pos, ColorResolver resolver) {
        Biome biome = (Biome)this.level.registryAccess().registryOrThrow(Registries.BIOME).getOrThrow(Biomes.FOREST);
        return resolver.getColor(biome, (double)pos.getX(), (double)pos.getY());
    }

    public BlockEntity getBlockEntity(BlockPos pos) {
        BlockState state = this.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof EntityBlock) {
            EntityBlock block2 = (EntityBlock)block;
            if (this.blockEntities.containsKey(pos) && !this.blockEntities.get(pos).getBlockState().equals(state)) {
                this.blockEntities.remove(pos);
            }
            return this.blockEntities.computeIfAbsent(pos, k -> block2.newBlockEntity(pos, state));
        }
        return null;
    }

    public BlockState getBlockState(BlockPos pos) {
        Vec3i dim = this.multiblock.getDimensions();
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        if (x < 0 || y < 0 || z < 0 || x >= dim.getX() || y >= dim.getY() || z >= dim.getZ()) {
            return Blocks.AIR.defaultBlockState();
        }
        StateMatcher matcher = this.multiblock.getStateMatcher(pos);
        if (matcher == null) {
            return Blocks.AIR.defaultBlockState();
        }
        List<BlockState> states = matcher.getDisplayStates();
        if (states.isEmpty()) {
            return Blocks.AIR.defaultBlockState();
        }
        return states.get(this.ticks / 20 % states.size());
    }

    public FluidState getFluidState(BlockPos pos) {
        return Fluids.EMPTY.defaultFluidState();
    }

    public int getHeight() {
        return this.level.getMaxBuildHeight();
    }

    public int getMinBuildHeight() {
        return this.level.getMinBuildHeight();
    }

    public int getBrightness(LightLayer layer, BlockPos pos) {
        return 15;
    }

    public int getRawBrightness(BlockPos pos, int amount) {
        return 15 - amount;
    }

    @Override
    public Multiblock getMultiblock() {
        return this.multiblock;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public void tick() {
        ++this.ticks;
    }
}

