/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.page_components;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.Lookup;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.page_components.BookRenderContext;
import net.favouriteless.modopedia.api.book.page_components.PageComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class EntityPageComponent
extends PageComponent {
    public static final ResourceLocation ID = Modopedia.id("entity");
    protected Entity entity;
    protected float offsetY;
    protected float scale;
    protected int width;
    protected int height;

    @Override
    public void init(Book book, Lookup lookup, Level level) {
        super.init(book, lookup, level);
        ResourceLocation id = lookup.get("entity").as(ResourceLocation.class);
        EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(id);
        if (type == null) {
            throw new IllegalArgumentException(String.valueOf(id) + " is not a valid entity type");
        }
        this.entity = type.create(level);
        if (lookup.has("tag")) {
            this.entity.load(lookup.get("tag").as(CompoundTag.class));
        }
        this.offsetY = lookup.getOrDefault("offset_y", Float.valueOf(0.0f)).asFloat();
        this.scale = lookup.getOrDefault("scale", Float.valueOf(1.0f)).asFloat();
        this.width = lookup.getOrDefault("width", 100).asInt();
        this.height = lookup.getOrDefault("height", 100).asInt();
    }

    @Override
    public void render(GuiGraphics graphics, BookRenderContext context, int mouseX, int mouseY, float partialTick) {
        float ySize;
        float ySizeBb;
        Minecraft mc = Minecraft.getInstance();
        EntityRenderDispatcher dispatcher = mc.getEntityRenderDispatcher();
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        PoseStack pose = graphics.pose();
        float xSizeBb = this.entity.getBbWidth();
        float xSize = Math.max(1.0f, Mth.sqrt((float)(xSizeBb * xSizeBb + (ySizeBb = this.entity.getBbHeight()) * ySizeBb)));
        float renderScale = (xSize > (ySize = Math.max(1.0f, ySizeBb)) ? (float)this.width / xSize : (float)this.height / ySize) * 0.8f * this.scale;
        float pixelHeight = ySizeBb * renderScale;
        float yOff = -((float)this.height - pixelHeight) / 2.0f;
        pose.pushPose();
        pose.translate((float)this.x, (float)this.y, 50.0f);
        pose.translate((float)this.width / 2.0f, yOff + (float)this.height - this.offsetY, 0.0f);
        pose.scale(-renderScale, -renderScale, -renderScale);
        pose.translate(0.0f, ySize / 2.0f, 0.0f);
        pose.mulPose(Axis.XN.rotationDegrees(15.0f));
        pose.translate(0.0f, -ySize / 2.0f, 0.0f);
        pose.mulPose(Axis.YP.rotationDegrees((float)(180 + context.getTicks()) + partialTick));
        boolean renderBoxes = dispatcher.shouldRenderHitBoxes();
        dispatcher.setRenderHitBoxes(false);
        dispatcher.render(this.entity, 0.0, 0.0, 0.0, 0.0f, partialTick, pose, (MultiBufferSource)bufferSource, 0xF000F0);
        dispatcher.setRenderHitBoxes(renderBoxes);
        pose.popPose();
    }
}

