/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.page_components;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.Lookup;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.page_components.BookRenderContext;
import net.favouriteless.modopedia.api.book.page_components.PageComponent;
import net.favouriteless.modopedia.api.multiblock.Multiblock;
import net.favouriteless.modopedia.api.multiblock.MultiblockInstance;
import net.favouriteless.modopedia.api.registries.client.MultiblockRegistry;
import net.favouriteless.modopedia.client.multiblock.PlacedMultiblock;
import net.favouriteless.modopedia.platform.ClientServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class MultiblockPageComponent
extends PageComponent {
    public static final ResourceLocation ID = Modopedia.id("multiblock");
    private static final RandomSource RANDOM = RandomSource.createNewThreadLocalInstance();
    private MultiblockInstance multiblock;
    private int width;
    private int height;
    private float offsetX;
    private float offsetY;
    private float scale;
    private boolean noOffsets;
    private float viewAngle;

    @Override
    public void init(Book book, Lookup lookup, Level level) {
        super.init(book, lookup, level);
        Multiblock multiblock = null;
        if (lookup.has("multiblock_id")) {
            ResourceLocation id = lookup.get("multiblock_id").as(ResourceLocation.class);
            multiblock = MultiblockRegistry.get().get(id);
            if (multiblock == null) {
                throw new IllegalArgumentException(String.valueOf(id) + " is not a registered multiblock");
            }
        }
        if (multiblock == null && lookup.has("multiblock")) {
            multiblock = lookup.get("multiblock").as(Multiblock.class);
        }
        if (multiblock == null) {
            throw new NullPointerException("Lookup is missing a \"multiblock_id\" or \"multiblock\" key");
        }
        this.multiblock = new PlacedMultiblock(multiblock, level);
        this.width = lookup.getOrDefault("width", 100).asInt();
        this.height = lookup.getOrDefault("height", 100).asInt();
        this.offsetX = lookup.getOrDefault("offset_x", Float.valueOf(0.0f)).asFloat();
        this.offsetY = lookup.getOrDefault("offset_y", Float.valueOf(0.0f)).asFloat();
        this.scale = lookup.getOrDefault("scale", Float.valueOf(1.0f)).asFloat();
        this.noOffsets = lookup.getOrDefault("no_offsets", false).asBoolean();
        this.viewAngle = lookup.getOrDefault("view_angle", Float.valueOf(30.0f)).asFloat();
    }

    @Override
    public void tick(BookRenderContext context) {
        this.multiblock.tick();
    }

    @Override
    public void render(GuiGraphics graphics, BookRenderContext context, int mouseX, int mouseY, float partialTick) {
        Minecraft mc = Minecraft.getInstance();
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        if (this.multiblock.getLevel() != mc.level) {
            this.multiblock = new PlacedMultiblock(this.multiblock.getMultiblock(), (Level)mc.level, this.multiblock.getPos());
        }
        PoseStack pose = graphics.pose();
        Multiblock m = this.multiblock.getMultiblock();
        Vec3i dims = m.getDimensions();
        float scale = (float)(-Math.min(this.width, this.height)) / Mth.sqrt((float)(dims.getX() * dims.getX() + dims.getY() * dims.getY() + dims.getZ() * dims.getZ()));
        pose.pushPose();
        pose.translate(this.offsetX, this.offsetY, 0.0f);
        pose.translate((float)this.x + (float)this.width / 2.0f, (float)this.y + (float)this.height / 2.0f, 100.0f);
        pose.scale(scale, scale, scale);
        pose.translate((float)(-dims.getX()) / 2.0f, (float)(-dims.getY()) / 2.0f, 0.0f);
        pose.translate((float)dims.getX() / 2.0f, (float)dims.getY() / 2.0f, (float)dims.getZ() / 2.0f);
        pose.scale(this.scale, this.scale, this.scale);
        pose.mulPose(Axis.XN.rotationDegrees(this.viewAngle));
        pose.mulPose(Axis.YP.rotationDegrees((float)(180 + context.getTicks()) + partialTick));
        pose.translate((float)(-dims.getX()) / 2.0f, (float)(-dims.getY()) / 2.0f, (float)(-dims.getZ()) / 2.0f);
        this.renderBlocks(pose, (MultiBufferSource)bufferSource, dims, partialTick);
        this.renderBlockEntities(pose, (MultiBufferSource)bufferSource, dims, partialTick);
        pose.popPose();
    }

    protected void renderBlocks(PoseStack pose, MultiBufferSource bufferSource, Vec3i dims, float partialTicks) {
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        for (BlockPos pos : BlockPos.betweenClosed((int)0, (int)0, (int)0, (int)dims.getX(), (int)dims.getY(), (int)dims.getZ())) {
            pose.pushPose();
            pose.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            BlockState state = this.multiblock.getBlockState(pos);
            if (state.getRenderShape() == RenderShape.MODEL) {
                for (RenderType type : ClientServices.PLATFORM.getRenderTypes(this.multiblock, pos, state)) {
                    VertexConsumer buffer = bufferSource.getBuffer(type);
                    if (this.noOffsets) {
                        Vec3 offset = state.getOffset((BlockGetter)this.multiblock, pos);
                        pose.translate(-offset.x, -offset.y, -offset.z);
                    }
                    dispatcher.renderBatched(state, pos, (BlockAndTintGetter)this.multiblock, pose, buffer, false, RANDOM);
                }
            }
            pose.popPose();
        }
    }

    protected void renderBlockEntities(PoseStack pose, MultiBufferSource bufferSource, Vec3i dims, float partialTicks) {
        Minecraft mc = Minecraft.getInstance();
        for (BlockPos pos : BlockPos.betweenClosed((int)0, (int)0, (int)0, (int)dims.getX(), (int)dims.getY(), (int)dims.getZ())) {
            BlockEntity be = this.multiblock.getBlockEntity(pos);
            if (be == null) continue;
            be.setLevel((Level)mc.level);
            pose.pushPose();
            pose.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            try {
                BlockEntityRenderer renderer = mc.getBlockEntityRenderDispatcher().getRenderer(be);
                if (renderer != null) {
                    renderer.render(be, partialTicks, pose, bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            pose.popPose();
        }
    }
}

