/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.page_components.item_displays;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.book.page_components.BookRenderContext;
import net.favouriteless.modopedia.api.book.page_components.ItemDisplay;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class TagItemDisplay
implements ItemDisplay {
    public static final ResourceLocation ID = Modopedia.id("tag");
    public static final MapCodec<TagItemDisplay> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("tag").forGetter(d -> d.tag)).apply((Applicative)instance, TagItemDisplay::new));
    private final TagKey<Item> tag;
    private final HolderSet.Named<Item> items;

    public TagItemDisplay(TagKey<Item> tag) {
        Optional optional = BuiltInRegistries.ITEM.getTag(tag);
        if (optional.isEmpty()) {
            throw new IllegalArgumentException(String.valueOf(tag) + " is not a valid item tag");
        }
        this.tag = tag;
        this.items = (HolderSet.Named)optional.get();
        if (this.items.size() == 0) {
            throw new IllegalArgumentException("TagItemDisplay cannot have zero items.");
        }
    }

    @Override
    public void render(GuiGraphics graphics, BookRenderContext context, int mouseX, int mouseY, String entry) {
        ItemStack item = ((Item)this.items.get(context.getTicks() / 20 % this.items.size()).value()).getDefaultInstance();
        context.renderItem(graphics, item, 0, 0, mouseX, mouseY, entry);
    }

    @Override
    public MapCodec<? extends ItemDisplay> typeCodec() {
        return CODEC;
    }
}

