/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.screens.books;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.BookContent;
import net.favouriteless.modopedia.api.book.BookTexture;
import net.favouriteless.modopedia.api.book.BookType;
import net.favouriteless.modopedia.client.screens.books.BookScreen;
import net.favouriteless.modopedia.client.screens.books.book_screen_pages.ScreenPage;
import net.favouriteless.modopedia.client.screens.widgets.BookImageButton;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class MultiPageBookScreen<T extends BookType>
extends BookScreen<T> {
    private final List<ScreenPage> pages = new ArrayList<ScreenPage>();
    private int leftPage = 0;
    private BookImageButton leftButton;
    private BookImageButton rightButton;
    private BookImageButton backButton;

    public MultiPageBookScreen(Book book, T type, String language, BookContent.LocalisedBookContent content, BookScreen<?> lastScreen, Component title) {
        super(book, type, language, content, lastScreen, title);
    }

    protected abstract void initPages(Consumer<ScreenPage> var1);

    @Override
    protected void init() {
        super.init();
        this.pages.clear();
        this.initPages(page -> {
            this.pages.add((ScreenPage)page);
            for (AbstractWidget widget : page.getWidgets()) {
                this.addRenderableWidget((GuiEventListener)widget);
            }
        });
        ResourceLocation tex = this.texture.location();
        int texWidth = this.texture.texWidth();
        int texHeight = this.texture.texHeight();
        BookTexture.FixedRectangle left = this.texture.left();
        BookTexture.FixedRectangle right = this.texture.right();
        BookTexture.FixedRectangle back = this.texture.back();
        this.leftButton = (BookImageButton)this.addRenderableWidget((GuiEventListener)new BookImageButton(tex, this.leftPos + left.x(), this.topPos + left.y(), left.width(), left.height(), left.u(), left.v(), texWidth, texHeight, b -> this.turnPageLeft(1), this.book.getFlipSound()));
        this.rightButton = (BookImageButton)this.addRenderableWidget((GuiEventListener)new BookImageButton(tex, this.leftPos + right.x(), this.topPos + right.y(), right.width(), right.height(), right.u(), right.v(), texWidth, texHeight, b -> this.turnPageRight(1), this.book.getFlipSound()));
        this.backButton = (BookImageButton)this.addRenderableWidget((GuiEventListener)new BookImageButton(tex, this.leftPos + back.x(), this.topPos + back.y(), back.width(), back.height(), back.u(), back.v(), texWidth, texHeight, b -> this.tryBackButton(), this.book.getFlipSound()));
        this.updateHiddenWidgets();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        PoseStack poseStack = graphics.pose();
        for (int i = 0; i < this.texture.pages().size() && this.leftPage + i < this.pages.size(); ++i) {
            ScreenPage page = this.pages.get(this.leftPage + i);
            BookTexture.Rectangle details = this.texture.pages().get(i);
            int xShift = this.leftPos + details.u();
            int yShift = this.topPos + details.v();
            poseStack.pushPose();
            poseStack.translate((float)xShift, (float)yShift, 0.0f);
            page.render(graphics, poseStack, details, mouseX - xShift, mouseY - yShift, partialTick);
            poseStack.popPose();
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        for (int i = 0; i < this.texture.pages().size() && this.leftPage + i < this.pages.size(); ++i) {
            int yShift;
            int xShift;
            BookTexture.Rectangle details;
            ScreenPage page = this.pages.get(this.leftPage + i);
            if (!page.mouseClicked(details = this.texture.pages().get(i), mouseX - (double)(xShift = this.leftPos + details.u()), mouseY - (double)(yShift = this.topPos + details.v()), button)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void tick() {
        super.tick();
        for (ScreenPage page : this.pages) {
            page.tick(this);
        }
    }

    protected void turnPageRight(int by) {
        int pageCount = this.texture.pages().size();
        if (this.leftPage + pageCount >= this.pages.size()) {
            return;
        }
        this.leftPage += pageCount;
        this.updateHiddenWidgets();
    }

    protected void turnPageLeft(int by) {
        int pageCount = this.texture.pages().size();
        if (this.leftPage - pageCount < 0) {
            return;
        }
        this.leftPage -= pageCount;
        this.updateHiddenWidgets();
    }

    protected void updateHiddenWidgets() {
        for (int i = 0; i < this.pages.size(); ++i) {
            if (i < this.leftPage || i >= this.leftPage + this.texture.pages().size()) {
                this.pages.get(i).hideWidgets();
                continue;
            }
            this.pages.get(i).showWidgets();
        }
        this.updateHiddenNavigation();
    }

    protected void updateHiddenNavigation() {
        if (this.lastScreen == null && this.isTopLevel()) {
            this.backButton.active = false;
            this.backButton.visible = false;
        } else {
            this.backButton.active = true;
            this.backButton.visible = true;
        }
        if (this.leftPage == 0) {
            this.leftButton.active = false;
            this.leftButton.visible = false;
        } else {
            this.leftButton.active = true;
            this.leftButton.visible = true;
        }
        if (this.leftPage + this.texture.pages().size() >= this.pages.size()) {
            this.rightButton.active = false;
            this.rightButton.visible = false;
        } else {
            this.rightButton.active = true;
            this.rightButton.visible = true;
        }
    }

    protected int getPageCount() {
        return this.pages.size();
    }

    protected int getLeftPage() {
        return this.leftPage;
    }

    protected ScreenPage getPage(int index) {
        return this.pages.get(index);
    }
}

