/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.common;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Map;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.registries.common.BookRegistry;
import net.favouriteless.modopedia.book.registries.common.BookRegistryImpl;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class BookReloadListener
extends SimpleJsonResourceReloadListener {
    public BookReloadListener(String directory) {
        super(new Gson(), directory);
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonMap, ResourceManager manager, ProfilerFiller profiler) {
        BookRegistryImpl.INSTANCE.clear();
        jsonMap.forEach((id, jsonElement) -> {
            try {
                Book.persistentCodec().decode((DynamicOps)JsonOps.INSTANCE, jsonElement).resultOrPartial(error -> Modopedia.LOG.error("Error attempting to load book {}: {}", id, error)).ifPresent(result -> BookRegistry.get().register((ResourceLocation)id, (Book)result.getFirst()));
            }
            catch (JsonParseException | IllegalArgumentException exception) {
                Modopedia.LOG.error("Critical error attempting to load book {}: {}", id, (Object)exception.getMessage());
            }
        });
    }
}

