/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.common;

import java.util.function.Consumer;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.registries.common.BookRegistry;
import net.favouriteless.modopedia.common.init.MDataComponents;
import net.favouriteless.modopedia.common.init.MItems;
import net.favouriteless.modopedia.common.network.packets.client.ClearBooksPayload;
import net.favouriteless.modopedia.common.network.packets.client.SyncBookPayload;
import net.favouriteless.modopedia.platform.CommonServices;
import net.favouriteless.modopedia.platform.services.INetworkHelper;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CommonEvents {
    public static void datapackSync(ServerPlayer player) {
        INetworkHelper networkHelper = CommonServices.NETWORK;
        networkHelper.sendToPlayer(new ClearBooksPayload(), player);
        BookRegistry.get().getBooks().forEach(book -> networkHelper.sendToPlayer(new SyncBookPayload(BookRegistry.get().getId((Book)book), (Book)book), player));
    }

    public static void onTabContents(ResourceKey<CreativeModeTab> tab, Consumer<ItemStack> output) {
        for (Book book : BookRegistry.get().getBooks()) {
            if (!tab.equals((Object)CreativeModeTabs.SEARCH) && !tab.equals(book.getCreativeTab())) continue;
            ItemStack item = new ItemStack((ItemLike)MItems.BOOK.get(), 1);
            item.set(MDataComponents.BOOK.get(), (Object)BookRegistry.get().getId(book));
            output.accept(item);
        }
    }
}

