/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.common;

import java.util.List;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.registries.common.BookRegistry;
import net.favouriteless.modopedia.client.BookOpenHandler;
import net.favouriteless.modopedia.common.init.MDataComponents;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class MBookItem
extends Item {
    public MBookItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack;
        if (level.isClientSide() && (stack = player.getItemInHand(hand)).has(MDataComponents.BOOK.get())) {
            BookOpenHandler.tryOpenBook(MBookItem.getBookId(stack));
        }
        return InteractionResultHolder.consume((Object)player.getItemInHand(hand));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        ResourceLocation bookId = MBookItem.getBookId(stack);
        if (bookId == null) {
            return;
        }
        Book book = BookRegistry.get().getBook(bookId);
        if (book != null && book.getSubtitle() != null) {
            tooltip.add((Component)Component.translatable((String)book.getSubtitle()).withStyle(ChatFormatting.GRAY));
        }
        if (flag.isAdvanced()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.modopedia.book_id", (Object[])new Object[]{bookId.toString()}).withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    public Component getName(ItemStack stack) {
        Book book = BookRegistry.get().getBook(MBookItem.getBookId(stack));
        if (book != null) {
            return Component.translatable((String)book.getTitle());
        }
        return super.getName(stack);
    }

    public String getCreatorModId(ItemStack item) {
        ResourceLocation book = (ResourceLocation)item.get(MDataComponents.BOOK.get());
        return book != null ? book.getNamespace() : BuiltInRegistries.ITEM.getKey((Object)item.getItem()).getNamespace();
    }

    public static ResourceLocation getBookId(ItemStack stack) {
        return (ResourceLocation)stack.get(MDataComponents.BOOK.get());
    }
}

