/*
 * Decompiled with CFR 0.152.
 */
package com.diontryban.ash_api.resources;

import com.diontryban.ash_api.AshApi;
import com.diontryban.ash_api.resources.ResourceLoader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ResourceLoaderNeoForge
extends ResourceLoader {
    private static final List<PreparableReloadListener> SERVER_RELOAD_LISTENERS = new ArrayList<PreparableReloadListener>();
    private final PackType type;

    public ResourceLoaderNeoForge() {
        this.type = null;
    }

    private ResourceLoaderNeoForge(PackType type) {
        this.type = type;
    }

    @Override
    public void registerReloadListener(@NotNull PreparableReloadListener reloadListener) {
        if (this.type == PackType.CLIENT_RESOURCES) {
            ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
            if (resourceManager instanceof ReloadableResourceManager) {
                ((ReloadableResourceManager)resourceManager).registerReloadListener(reloadListener);
            }
        } else if (this.type == PackType.SERVER_DATA) {
            if (SERVER_RELOAD_LISTENERS.isEmpty()) {
                NeoForge.EVENT_BUS.addListener(this::onAddReloadListener);
            }
            SERVER_RELOAD_LISTENERS.add(reloadListener);
        } else {
            AshApi.LOG.error("Attempted to register a resource loader of type {}. This is unsupported. Please file an issue.", (Object)this.type);
        }
    }

    private void onAddReloadListener(AddReloadListenerEvent event) {
        for (PreparableReloadListener reloadListener : SERVER_RELOAD_LISTENERS) {
            event.addListener(reloadListener);
        }
    }

    @Override
    @NotNull
    protected ResourceLoader getImpl(PackType type) {
        return new ResourceLoaderNeoForge(type);
    }
}

