/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.api.sizing;

import com.mojang.serialization.MapCodec;
import com.teamresourceful.bytecodecs.base.ByteCodec;
import earth.terrarium.tempad.TempadKt;
import earth.terrarium.tempad.api.locations.NamedGlobalVec3Kt;
import earth.terrarium.tempad.api.sizing.DoorType;
import earth.terrarium.tempad.api.sizing.SizingType;
import earth.terrarium.tempad.api.sizing.TimedoorPlacementSettings;
import earth.terrarium.tempad.common.config.CommonConfig;
import earth.terrarium.tempad.common.entity.TimedoorEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 (2\u00020\u0001:\u0001(B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J(\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020$H\u0016J\u0014\u0010%\u001a\u00020\r*\u00020$2\u0006\u0010&\u001a\u00020'H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011X\u0096\u0004\u00a2\u0006\n\n\u0002\b\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006)"}, d2={"Learth/terrarium/tempad/api/sizing/DynamicAngledPlacement;", "Learth/terrarium/tempad/api/sizing/TimedoorPlacementSettings;", "<init>", "()V", "width", "", "getWidth", "()F", "height", "getHeight", "depth", "getDepth", "showLineAnimation", "", "getShowLineAnimation", "()Z", "type", "Learth/terrarium/tempad/api/sizing/SizingType;", "getType", "()Learth/terrarium/tempad/api/sizing/SizingType;", "type$1", "dimensions", "Lnet/minecraft/world/entity/EntityDimensions;", "getDimensions", "()Lnet/minecraft/world/entity/EntityDimensions;", "widthAtPercent", "percent", "heightAtPercent", "depthAtPercent", "placeTimedoor", "", "Learth/terrarium/tempad/api/sizing/DoorType;", "anchor", "Lnet/minecraft/world/phys/Vec3;", "angle", "timedoor", "Learth/terrarium/tempad/common/entity/TimedoorEntity;", "isInside", "entity", "Lnet/minecraft/world/entity/Entity;", "Companion", "tempad-1.21.1"})
public class DynamicAngledPlacement
implements TimedoorPlacementSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float width;
    private final float height;
    private final float depth;
    private final boolean showLineAnimation;
    @NotNull
    private final SizingType<?> type$1 = type;
    @NotNull
    private final EntityDimensions dimensions;
    @NotNull
    private static final SizingType<DynamicAngledPlacement> type;

    public DynamicAngledPlacement() {
        this.width = 1.25f;
        this.height = 2.25f;
        this.depth = 0.375f;
        this.showLineAnimation = true;
        EntityDimensions entityDimensions = EntityDimensions.fixed((float)this.width, (float)this.height);
        Intrinsics.checkNotNullExpressionValue((Object)entityDimensions, (String)"fixed(...)");
        this.dimensions = entityDimensions;
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    public final float getDepth() {
        return this.depth;
    }

    @Override
    public boolean getShowLineAnimation() {
        return this.showLineAnimation;
    }

    @Override
    @NotNull
    public SizingType<?> getType() {
        return this.type$1;
    }

    @Override
    @NotNull
    public EntityDimensions getDimensions() {
        return this.dimensions;
    }

    @Override
    public float widthAtPercent(float percent) {
        if ((double)percent < 0.5) {
            return this.width * percent * (float)2;
        }
        return this.width;
    }

    @Override
    public float heightAtPercent(float percent) {
        if ((double)percent > 0.5) {
            return Mth.lerp((float)((percent - 0.5f) * (float)2), (float)0.2f, (float)this.height);
        }
        return 0.2f;
    }

    @Override
    public float depthAtPercent(float percent) {
        return this.depth;
    }

    @Override
    public void placeTimedoor(@NotNull DoorType type2, @NotNull Vec3 anchor, float angle, @NotNull TimedoorEntity timedoor) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)((Object)timedoor), (String)"timedoor");
        Vec3 offset = NamedGlobalVec3Kt.offsetLocation(anchor, angle, type2 == DoorType.ENTRY ? CommonConfig.TimeDoor.placementDistance : 1);
        timedoor.setPos(offset.x, anchor.y, offset.z);
        timedoor.setYRot(angle + (float)(type2 == DoorType.ENTRY ? 180 : 0));
    }

    @Override
    public boolean isInside(@NotNull TimedoorEntity $this$isInside, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$isInside), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        double hypotenuse = (entity.getX() - $this$isInside.getX()) * (entity.getX() - $this$isInside.getX()) + (entity.getZ() - $this$isInside.getZ()) * (entity.getZ() - $this$isInside.getZ());
        float alpha = (float)Mth.atan2((double)(entity.getZ() - $this$isInside.getZ()), (double)(entity.getX() - $this$isInside.getX()));
        float theta = Mth.sin((float)(alpha - $this$isInside.getYRot() * ((float)Math.PI / 180)));
        float maxDistance = this.depth / (float)2 + entity.getBbWidth() / 2.0f;
        return (double)(theta * theta) * hypotenuse < (double)(maxDistance * maxDistance);
    }

    static {
        ResourceLocation resourceLocation = TempadKt.getTempadId("default");
        ByteCodec byteCodec2 = ByteCodec.unit(DynamicAngledPlacement::new);
        Intrinsics.checkNotNullExpressionValue((Object)byteCodec2, (String)"unit(...)");
        MapCodec mapCodec = MapCodec.unit(DynamicAngledPlacement::new);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"unit(...)");
        type = new SizingType(resourceLocation, byteCodec2, mapCodec);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001f\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Learth/terrarium/tempad/api/sizing/DynamicAngledPlacement$Companion;", "", "<init>", "()V", "type", "Learth/terrarium/tempad/api/sizing/SizingType;", "Learth/terrarium/tempad/api/sizing/DynamicAngledPlacement;", "kotlin.jvm.PlatformType", "getType", "()Learth/terrarium/tempad/api/sizing/SizingType;", "tempad-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SizingType<DynamicAngledPlacement> getType() {
            return type;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

