/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.client.entity;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import earth.terrarium.tempad.TempadKt;
import earth.terrarium.tempad.api.sizing.TimedoorPlacementSettings;
import earth.terrarium.tempad.client.ShaderModBridge;
import earth.terrarium.tempad.client.TempadClient;
import earth.terrarium.tempad.client.entity.TimedoorRendererKt;
import earth.terrarium.tempad.common.entity.TimedoorEntity;
import java.util.HashMap;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector2i;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002&'B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J8\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJP\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u00152\b\b\u0002\u0010$\u001a\u00020%\u00a8\u0006("}, d2={"Learth/terrarium/tempad/client/entity/TimedoorRenderer;", "Lnet/minecraft/client/renderer/entity/EntityRenderer;", "Learth/terrarium/tempad/common/entity/TimedoorEntity;", "ctx", "Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)V", "getTextureLocation", "Lnet/minecraft/resources/ResourceLocation;", "pEntity", "render", "", "entity", "entityYaw", "", "partialTick", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "texture", "Lcom/mojang/blaze3d/platform/NativeImage;", "Learth/terrarium/tempad/api/sizing/TimedoorPlacementSettings;", "face", "Learth/terrarium/tempad/client/entity/TimedoorRenderer$BoxFace;", "registerFaceTexture", "sizing", "renderTimedoor", "multiBufferSource", "width", "height", "depth", "color", "age", "animate", "", "Companion", "BoxFace", "tempad-1.21.1"})
public final class TimedoorRenderer
extends EntityRenderer<TimedoorEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final HashMap<Pair<TimedoorPlacementSettings, BoxFace>, ResourceLocation> faceTextures = new HashMap();

    public TimedoorRenderer(@NotNull EntityRendererProvider.Context ctx2) {
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        super(ctx2);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull TimedoorEntity pEntity) {
        Intrinsics.checkNotNullParameter((Object)((Object)pEntity), (String)"pEntity");
        return TempadKt.getTempadId("");
    }

    public void render(@NotNull TimedoorEntity entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int tickCount = entity.tickCount + entity.getAnimationOffset();
        if (tickCount < 26) {
            return;
        }
        int tickLength = 5;
        float animation = 0.0f;
        float ticks = (float)tickCount + partialTick;
        if (entity.getClosingTime() < 5) {
            if (entity.getBeganClosing() == 0) {
                entity.setBeganClosing(tickCount);
            }
            animation = Mth.clamp((float)(1.0f - (ticks - (float)entity.getBeganClosing()) / (float)tickLength), (float)0.0f, (float)1.0f);
        } else {
            animation = Mth.clamp((float)((ticks - (float)26) / (float)tickLength), (float)0.0f, (float)1.0f);
        }
        float width = entity.getSizing().widthAtPercent(animation);
        float height = entity.getSizing().heightAtPercent(animation);
        float depth = entity.getSizing().depthAtPercent(animation);
        float finalHeight = entity.getSizing().getDimensions().height();
        poseStack.pushPose();
        poseStack.mulPose(Axis.YN.rotationDegrees(entity.getYRot() + (float)180));
        poseStack.translate((double)width / -2.0, (double)finalHeight / 2.0 - (double)height / 2.0 + 0.01, (double)depth / -2.0);
        if (entity.getGlitching() && ticks % (float)65 > 60.0f) {
            float randomX = Mth.randomBetween((RandomSource)entity.getRandom(), (float)-0.05f, (float)0.05f);
            float randomY = Mth.randomBetween((RandomSource)entity.getRandom(), (float)-0.05f, (float)0.05f);
            float randomZ = Mth.randomBetween((RandomSource)entity.getRandom(), (float)-0.05f, (float)0.05f);
            poseStack.translate(randomX, randomY, randomZ);
        }
        if (width > 0.0f) {
            this.renderTimedoor(entity.getSizing(), poseStack, buffer, width, height, depth, entity.getColor().getValue(), tickCount, entity.getSizing().getShowLineAnimation());
        }
        super.render((Entity)entity, entityYaw, partialTick, poseStack, buffer, packedLight);
        poseStack.popPose();
    }

    @NotNull
    public final NativeImage texture(@NotNull TimedoorPlacementSettings $this$texture, @NotNull BoxFace face) {
        NativeImage nativeImage;
        Intrinsics.checkNotNullParameter((Object)$this$texture, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)face), (String)"face");
        Vector2i vector2i = face.getDimensions($this$texture);
        int textureWidth = TimedoorRendererKt.component1(vector2i);
        int textureHeight = TimedoorRendererKt.component2(vector2i);
        NativeImage $this$texture_u24lambda_u242 = nativeImage = new NativeImage(textureWidth, textureHeight, true);
        boolean bl = false;
        for (int j = 0; j < textureWidth; ++j) {
            int x = j;
            boolean bl2 = false;
            for (int k = 0; k < textureHeight; ++k) {
                int y = k;
                boolean bl3 = false;
                float x2 = (float)x * 2.0f / (float)textureWidth - 1.0f;
                float y2 = (float)y * 2.0f / (float)textureHeight - 1.0f;
                float alpha = x2 * x2 / (float)3 + y2 * y2 / (float)3;
                float f = alpha;
                double d = 0.07;
                double d2 = (double)f % d;
                double modAlpha = (double)alpha - (!(d2 == 0.0) && !(Math.signum(d2) == Math.signum(d)) ? d2 + d : d2);
                $this$texture_u24lambda_u242.setPixelRGBA(x, y, (int)(modAlpha * (double)255) + 26 << 24 | 0xFFFFFF);
            }
        }
        return nativeImage;
    }

    @Nullable
    public final ResourceLocation registerFaceTexture(@NotNull TimedoorPlacementSettings sizing, @NotNull BoxFace face) {
        Intrinsics.checkNotNullParameter((Object)sizing, (String)"sizing");
        Intrinsics.checkNotNullParameter((Object)((Object)face), (String)"face");
        if (!ShaderModBridge.INSTANCE.getShadersEnabled()) {
            return null;
        }
        return faceTextures.computeIfAbsent((Pair<TimedoorPlacementSettings, BoxFace>)TuplesKt.to((Object)sizing, (Object)((Object)face)), arg_0 -> TimedoorRenderer.registerFaceTexture$lambda$4(arg_0 -> TimedoorRenderer.registerFaceTexture$lambda$3(sizing, face, this, arg_0), arg_0));
    }

    public final void renderTimedoor(@NotNull TimedoorPlacementSettings sizing, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, float width, float height, float depth, int color, int age, boolean animate) {
        Intrinsics.checkNotNullParameter((Object)sizing, (String)"sizing");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)multiBufferSource, (String)"multiBufferSource");
        float maxX = width;
        float maxY = height;
        float maxZ = depth;
        float minX = 0.0f;
        float minY = 0.0f;
        float minZ = 0.0f;
        Matrix4f matrix4f = poseStack.last().pose();
        Intrinsics.checkNotNullExpressionValue((Object)matrix4f, (String)"pose(...)");
        Matrix4f model = matrix4f;
        PoseStack.Pose matrix3f = poseStack.last();
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        VertexConsumer buffer = multiBufferSource.getBuffer(TempadClient.INSTANCE.renderType(this.registerFaceTexture(sizing, BoxFace.FrontBack)));
        VertexConsumer vertexConsumer = buffer.addVertex(model, minX, maxY, minZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer, (String)"addVertex(...)");
        VertexConsumer vertexConsumer2 = TimedoorRenderer.renderTimedoor$color(vertexConsumer, red, green, blue).setUv(0.0f, 1.0f);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer2, (String)"setUv(...)");
        VertexConsumer vertexConsumer3 = TimedoorRenderer.renderTimedoor$size(vertexConsumer2, minX, maxY).addVertex(model, maxX, maxY, minZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer3, (String)"addVertex(...)");
        VertexConsumer vertexConsumer4 = TimedoorRenderer.renderTimedoor$color(vertexConsumer3, red, green, blue).setUv(1.0f, 1.0f);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer4, (String)"setUv(...)");
        VertexConsumer vertexConsumer5 = TimedoorRenderer.renderTimedoor$size(vertexConsumer4, maxX, maxY).addVertex(model, maxX, minY, minZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer5, (String)"addVertex(...)");
        VertexConsumer vertexConsumer6 = TimedoorRenderer.renderTimedoor$color(vertexConsumer5, red, green, blue).setUv(1.0f, 0.0f);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer6, (String)"setUv(...)");
        VertexConsumer vertexConsumer7 = TimedoorRenderer.renderTimedoor$size(vertexConsumer6, maxX, minY).addVertex(model, minX, minY, minZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer7, (String)"addVertex(...)");
        VertexConsumer vertexConsumer8 = TimedoorRenderer.renderTimedoor$color(vertexConsumer7, red, green, blue).setUv(0.0f, 0.0f);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer8, (String)"setUv(...)");
        VertexConsumer vertexConsumer9 = TimedoorRenderer.renderTimedoor$size(vertexConsumer8, minX, minY).addVertex(model, maxX, maxY, maxZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer9, (String)"addVertex(...)");
        VertexConsumer vertexConsumer10 = TimedoorRenderer.renderTimedoor$color(vertexConsumer9, red, green, blue).setUv(1.0f, 1.0f);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer10, (String)"setUv(...)");
        VertexConsumer vertexConsumer11 = TimedoorRenderer.renderTimedoor$size(vertexConsumer10, maxX, maxY).addVertex(model, minX, maxY, maxZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer11, (String)"addVertex(...)");
        VertexConsumer vertexConsumer12 = TimedoorRenderer.renderTimedoor$color(vertexConsumer11, red, green, blue).setUv(0.0f, 1.0f);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer12, (String)"setUv(...)");
        VertexConsumer vertexConsumer13 = TimedoorRenderer.renderTimedoor$size(vertexConsumer12, minX, maxY).addVertex(model, minX, minY, maxZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer13, (String)"addVertex(...)");
        VertexConsumer vertexConsumer14 = TimedoorRenderer.renderTimedoor$color(vertexConsumer13, red, green, blue).setUv(0.0f, 0.0f);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer14, (String)"setUv(...)");
        VertexConsumer vertexConsumer15 = TimedoorRenderer.renderTimedoor$size(vertexConsumer14, minX, minY).addVertex(model, maxX, minY, maxZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer15, (String)"addVertex(...)");
        VertexConsumer vertexConsumer16 = TimedoorRenderer.renderTimedoor$color(vertexConsumer15, red, green, blue).setUv(1.0f, 0.0f);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer16, (String)"setUv(...)");
        TimedoorRenderer.renderTimedoor$size(vertexConsumer16, maxX, minY);
        if (ShaderModBridge.INSTANCE.getShadersEnabled()) {
            buffer = multiBufferSource.getBuffer(TempadClient.INSTANCE.renderType(this.registerFaceTexture(sizing, BoxFace.TopBottom)));
        }
        VertexConsumer vertexConsumer17 = buffer.addVertex(model, minX, maxY, maxZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer17, (String)"addVertex(...)");
        VertexConsumer vertexConsumer18 = TimedoorRenderer.renderTimedoor$color(vertexConsumer17, red, green, blue).setUv(0.0f, 1.0f);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer18, (String)"setUv(...)");
        vertexConsumer3 = TimedoorRenderer.renderTimedoor$size(vertexConsumer18, minX, maxZ).addVertex(model, maxX, maxY, maxZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer3, (String)"addVertex(...)");
        vertexConsumer4 = TimedoorRenderer.renderTimedoor$color(vertexConsumer3, red, green, blue).setUv(1.0f, 1.0f);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer4, (String)"setUv(...)");
        vertexConsumer5 = TimedoorRenderer.renderTimedoor$size(vertexConsumer4, maxX, maxZ).addVertex(model, maxX, maxY, minZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer5, (String)"addVertex(...)");
        vertexConsumer6 = TimedoorRenderer.renderTimedoor$color(vertexConsumer5, red, green, blue).setUv(1.0f, 0.0f);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer6, (String)"setUv(...)");
        vertexConsumer7 = TimedoorRenderer.renderTimedoor$size(vertexConsumer6, maxX, minZ).addVertex(model, minX, maxY, minZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer7, (String)"addVertex(...)");
        vertexConsumer8 = TimedoorRenderer.renderTimedoor$color(vertexConsumer7, red, green, blue).setUv(0.0f, 0.0f);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer8, (String)"setUv(...)");
        vertexConsumer9 = TimedoorRenderer.renderTimedoor$size(vertexConsumer8, minX, minZ).addVertex(model, minX, minY, minZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer9, (String)"addVertex(...)");
        vertexConsumer10 = TimedoorRenderer.renderTimedoor$color(vertexConsumer9, red, green, blue).setUv(0.0f, 0.0f);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer10, (String)"setUv(...)");
        vertexConsumer11 = TimedoorRenderer.renderTimedoor$size(vertexConsumer10, minX, minZ).addVertex(model, maxX, minY, minZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer11, (String)"addVertex(...)");
        vertexConsumer12 = TimedoorRenderer.renderTimedoor$color(vertexConsumer11, red, green, blue).setUv(1.0f, 0.0f);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer12, (String)"setUv(...)");
        vertexConsumer13 = TimedoorRenderer.renderTimedoor$size(vertexConsumer12, maxX, minZ).addVertex(model, maxX, minY, maxZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer13, (String)"addVertex(...)");
        vertexConsumer14 = TimedoorRenderer.renderTimedoor$color(vertexConsumer13, red, green, blue).setUv(1.0f, 1.0f);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer14, (String)"setUv(...)");
        vertexConsumer15 = TimedoorRenderer.renderTimedoor$size(vertexConsumer14, maxX, maxZ).addVertex(model, minX, minY, maxZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer15, (String)"addVertex(...)");
        vertexConsumer16 = TimedoorRenderer.renderTimedoor$color(vertexConsumer15, red, green, blue).setUv(0.0f, 1.0f);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer16, (String)"setUv(...)");
        TimedoorRenderer.renderTimedoor$size(vertexConsumer16, minX, maxZ);
        if (ShaderModBridge.INSTANCE.getShadersEnabled()) {
            buffer = multiBufferSource.getBuffer(TempadClient.INSTANCE.renderType(this.registerFaceTexture(sizing, BoxFace.LeftRight)));
        }
        VertexConsumer vertexConsumer19 = buffer.addVertex(model, minX, maxY, maxZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer19, (String)"addVertex(...)");
        VertexConsumer vertexConsumer20 = TimedoorRenderer.renderTimedoor$color(vertexConsumer19, red, green, blue).setUv(1.0f, 1.0f);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer20, (String)"setUv(...)");
        vertexConsumer3 = TimedoorRenderer.renderTimedoor$size(vertexConsumer20, maxZ, maxY).addVertex(model, minX, maxY, minZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer3, (String)"addVertex(...)");
        vertexConsumer4 = TimedoorRenderer.renderTimedoor$color(vertexConsumer3, red, green, blue).setUv(0.0f, 1.0f);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer4, (String)"setUv(...)");
        vertexConsumer5 = TimedoorRenderer.renderTimedoor$size(vertexConsumer4, minZ, maxY).addVertex(model, minX, minY, minZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer5, (String)"addVertex(...)");
        vertexConsumer6 = TimedoorRenderer.renderTimedoor$color(vertexConsumer5, red, green, blue).setUv(0.0f, 0.0f);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer6, (String)"setUv(...)");
        vertexConsumer7 = TimedoorRenderer.renderTimedoor$size(vertexConsumer6, minZ, minY).addVertex(model, minX, minY, maxZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer7, (String)"addVertex(...)");
        vertexConsumer8 = TimedoorRenderer.renderTimedoor$color(vertexConsumer7, red, green, blue).setUv(1.0f, 0.0f);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer8, (String)"setUv(...)");
        vertexConsumer9 = TimedoorRenderer.renderTimedoor$size(vertexConsumer8, maxZ, minY).addVertex(model, maxX, maxY, minZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer9, (String)"addVertex(...)");
        vertexConsumer10 = TimedoorRenderer.renderTimedoor$color(vertexConsumer9, red, green, blue).setUv(0.0f, 1.0f);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer10, (String)"setUv(...)");
        vertexConsumer11 = TimedoorRenderer.renderTimedoor$size(vertexConsumer10, minZ, maxY).addVertex(model, maxX, maxY, maxZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer11, (String)"addVertex(...)");
        vertexConsumer12 = TimedoorRenderer.renderTimedoor$color(vertexConsumer11, red, green, blue).setUv(1.0f, 1.0f);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer12, (String)"setUv(...)");
        vertexConsumer13 = TimedoorRenderer.renderTimedoor$size(vertexConsumer12, maxZ, maxY).addVertex(model, maxX, minY, maxZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer13, (String)"addVertex(...)");
        vertexConsumer14 = TimedoorRenderer.renderTimedoor$color(vertexConsumer13, red, green, blue).setUv(1.0f, 0.0f);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer14, (String)"setUv(...)");
        vertexConsumer15 = TimedoorRenderer.renderTimedoor$size(vertexConsumer14, maxZ, minY).addVertex(model, maxX, minY, minZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer15, (String)"addVertex(...)");
        vertexConsumer16 = TimedoorRenderer.renderTimedoor$color(vertexConsumer15, red, green, blue).setUv(0.0f, 0.0f);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer16, (String)"setUv(...)");
        TimedoorRenderer.renderTimedoor$size(vertexConsumer16, minZ, minY);
        VertexConsumer lineBuffer = multiBufferSource.getBuffer(RenderType.lines());
        float widthPart = width * 20.0f;
        float heightPart = height * 20.0f;
        float total = widthPart * (float)2 + heightPart * (float)2;
        float widthLine = total / widthPart * 0.0625f;
        float heightLine = total / heightPart * 0.0625f;
        float topPercent = 0.0f;
        float rightPercent = 0.0f;
        float bottomPercent = 0.0f;
        float leftPercent = 0.0f;
        if (widthPart > heightPart) {
            topPercent = 1.0f - (((float)age + widthPart) % total - widthPart) / (widthPart - widthPart * widthLine * 1.5f) + widthLine;
            rightPercent = 1.0f - ((float)age % total - widthPart) / heightPart;
            bottomPercent = 1.0f - ((float)age % total - widthPart - heightPart) / (widthPart - widthPart * widthLine * 1.5f) + widthLine;
            leftPercent = 1.0f - (((float)age - widthPart) % total - widthPart - heightPart) / heightPart;
        } else {
            topPercent = 1.0f - (((float)age + widthPart) % total - widthPart) / widthPart;
            rightPercent = 1.0f - (((float)age + widthPart) % total - widthPart * (float)2) / (heightPart - heightPart * heightLine * 1.5f) + heightLine;
            bottomPercent = 1.0f - ((float)age % total - widthPart - heightPart) / widthPart;
            leftPercent = 1.0f - (((float)age - widthPart) % total - widthPart - heightPart) / (heightPart - heightPart * heightLine * 1.5f) + heightLine;
        }
        VertexConsumer vertexConsumer21 = lineBuffer.addVertex(model, minX, maxY, minZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer21, (String)"addVertex(...)");
        TimedoorRenderer.renderTimedoor$color(vertexConsumer21, red, green, blue).setNormal(matrix3f, -1.0f, 0.0f, 0.0f);
        if (animate && topPercent > -widthLine && topPercent < 1.0f + widthLine) {
            float start = Mth.clamp((float)(topPercent - widthLine), (float)0.0f, (float)1.0f);
            float end = Mth.clamp((float)(topPercent + widthLine), (float)0.0f, (float)1.0f);
            float middle = Mth.clamp((float)topPercent, (float)0.0f, (float)1.0f);
            VertexConsumer vertexConsumer22 = lineBuffer.addVertex(model, Mth.lerp((float)start, (float)0.0f, (float)maxX), maxY, minZ);
            Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer22, (String)"addVertex(...)");
            TimedoorRenderer.renderTimedoor$color(vertexConsumer22, red, green, blue).setNormal(matrix3f, -1.0f, 0.0f, 0.0f);
            VertexConsumer vertexConsumer23 = lineBuffer.addVertex(model, Mth.lerp((float)start, (float)0.0f, (float)maxX), maxY, minZ);
            Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer23, (String)"addVertex(...)");
            TimedoorRenderer.renderTimedoor$color(vertexConsumer23, red, green, blue).setNormal(matrix3f, -1.0f, 0.0f, 0.0f);
            lineBuffer.addVertex(model, Mth.lerp((float)middle, (float)0.0f, (float)maxX), maxY, minZ).setColor(-1).setNormal(matrix3f, -1.0f, 0.0f, 0.0f);
            lineBuffer.addVertex(model, Mth.lerp((float)middle, (float)0.0f, (float)maxX), maxY, minZ).setColor(-1).setNormal(matrix3f, -1.0f, 0.0f, 0.0f);
            VertexConsumer vertexConsumer24 = lineBuffer.addVertex(model, Mth.lerp((float)end, (float)0.0f, (float)maxX), maxY, minZ);
            Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer24, (String)"addVertex(...)");
            TimedoorRenderer.renderTimedoor$color(vertexConsumer24, red, green, blue).setNormal(matrix3f, -1.0f, 0.0f, 0.0f);
            VertexConsumer vertexConsumer25 = lineBuffer.addVertex(model, Mth.lerp((float)end, (float)0.0f, (float)maxX), maxY, minZ);
            Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer25, (String)"addVertex(...)");
            TimedoorRenderer.renderTimedoor$color(vertexConsumer25, red, green, blue).setNormal(matrix3f, -1.0f, 0.0f, 0.0f);
        }
        VertexConsumer vertexConsumer26 = lineBuffer.addVertex(model, maxX, maxY, minZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer26, (String)"addVertex(...)");
        TimedoorRenderer.renderTimedoor$color(vertexConsumer26, red, green, blue).setNormal(matrix3f, -1.0f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer27 = lineBuffer.addVertex(model, minX, minY, minZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer27, (String)"addVertex(...)");
        TimedoorRenderer.renderTimedoor$color(vertexConsumer27, red, green, blue).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
        if (animate && rightPercent > -heightLine && rightPercent < 1.0f + heightLine) {
            float start = Mth.clamp((float)(rightPercent - heightLine), (float)0.0f, (float)1.0f);
            float end = Mth.clamp((float)(rightPercent + heightLine), (float)0.0f, (float)1.0f);
            float middle = Mth.clamp((float)rightPercent, (float)0.0f, (float)1.0f);
            VertexConsumer vertexConsumer28 = lineBuffer.addVertex(model, minX, Mth.lerp((float)start, (float)0.0f, (float)maxY), minZ);
            Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer28, (String)"addVertex(...)");
            TimedoorRenderer.renderTimedoor$color(vertexConsumer28, red, green, blue).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
            VertexConsumer vertexConsumer29 = lineBuffer.addVertex(model, minX, Mth.lerp((float)start, (float)0.0f, (float)maxY), minZ);
            Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer29, (String)"addVertex(...)");
            TimedoorRenderer.renderTimedoor$color(vertexConsumer29, red, green, blue).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
            lineBuffer.addVertex(model, minX, Mth.lerp((float)middle, (float)0.0f, (float)maxY), minZ).setColor(-1).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
            lineBuffer.addVertex(model, minX, Mth.lerp((float)middle, (float)0.0f, (float)maxY), minZ).setColor(-1).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
            VertexConsumer vertexConsumer30 = lineBuffer.addVertex(model, minX, Mth.lerp((float)end, (float)0.0f, (float)maxY), minZ);
            Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer30, (String)"addVertex(...)");
            TimedoorRenderer.renderTimedoor$color(vertexConsumer30, red, green, blue).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
            VertexConsumer vertexConsumer31 = lineBuffer.addVertex(model, minX, Mth.lerp((float)end, (float)0.0f, (float)maxY), minZ);
            Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer31, (String)"addVertex(...)");
            TimedoorRenderer.renderTimedoor$color(vertexConsumer31, red, green, blue).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
        }
        VertexConsumer vertexConsumer32 = lineBuffer.addVertex(model, minX, maxY, minZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer32, (String)"addVertex(...)");
        TimedoorRenderer.renderTimedoor$color(vertexConsumer32, red, green, blue).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
        VertexConsumer vertexConsumer33 = lineBuffer.addVertex(model, minX, minY, minZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer33, (String)"addVertex(...)");
        TimedoorRenderer.renderTimedoor$color(vertexConsumer33, red, green, blue).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
        if (animate && bottomPercent > -widthLine && bottomPercent < 1.0f + widthLine) {
            float start = Mth.clamp((float)(bottomPercent + widthLine), (float)0.0f, (float)1.0f);
            float end = Mth.clamp((float)(bottomPercent - widthLine), (float)0.0f, (float)1.0f);
            float middle = Mth.clamp((float)bottomPercent, (float)0.0f, (float)1.0f);
            VertexConsumer vertexConsumer34 = lineBuffer.addVertex(model, Mth.lerp((float)(1.0f - start), (float)0.0f, (float)maxX), minY, minZ);
            Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer34, (String)"addVertex(...)");
            TimedoorRenderer.renderTimedoor$color(vertexConsumer34, red, green, blue).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
            VertexConsumer vertexConsumer35 = lineBuffer.addVertex(model, Mth.lerp((float)(1.0f - start), (float)0.0f, (float)maxX), minY, minZ);
            Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer35, (String)"addVertex(...)");
            TimedoorRenderer.renderTimedoor$color(vertexConsumer35, red, green, blue).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
            lineBuffer.addVertex(model, Mth.lerp((float)(1.0f - middle), (float)0.0f, (float)maxX), minY, minZ).setColor(-1).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
            lineBuffer.addVertex(model, Mth.lerp((float)(1.0f - middle), (float)0.0f, (float)maxX), minY, minZ).setColor(-1).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
            VertexConsumer vertexConsumer36 = lineBuffer.addVertex(model, Mth.lerp((float)(1.0f - end), (float)0.0f, (float)maxX), minY, minZ);
            Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer36, (String)"addVertex(...)");
            TimedoorRenderer.renderTimedoor$color(vertexConsumer36, red, green, blue).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
            VertexConsumer vertexConsumer37 = lineBuffer.addVertex(model, Mth.lerp((float)(1.0f - end), (float)0.0f, (float)maxX), minY, minZ);
            Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer37, (String)"addVertex(...)");
            TimedoorRenderer.renderTimedoor$color(vertexConsumer37, red, green, blue).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
        }
        VertexConsumer vertexConsumer38 = lineBuffer.addVertex(model, maxX, minY, minZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer38, (String)"addVertex(...)");
        TimedoorRenderer.renderTimedoor$color(vertexConsumer38, red, green, blue).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer39 = lineBuffer.addVertex(model, maxX, maxY, minZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer39, (String)"addVertex(...)");
        TimedoorRenderer.renderTimedoor$color(vertexConsumer39, red, green, blue).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
        if (animate && leftPercent > -heightLine && leftPercent < 1.0f + heightLine) {
            float start = Mth.clamp((float)(leftPercent - heightLine), (float)0.0f, (float)1.0f);
            float end = Mth.clamp((float)(leftPercent + heightLine), (float)0.0f, (float)1.0f);
            float middle = Mth.clamp((float)leftPercent, (float)0.0f, (float)1.0f);
            VertexConsumer vertexConsumer40 = lineBuffer.addVertex(model, maxX, Mth.lerp((float)start, (float)maxY, (float)0.0f), minZ);
            Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer40, (String)"addVertex(...)");
            TimedoorRenderer.renderTimedoor$color(vertexConsumer40, red, green, blue).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
            VertexConsumer vertexConsumer41 = lineBuffer.addVertex(model, maxX, Mth.lerp((float)start, (float)maxY, (float)0.0f), minZ);
            Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer41, (String)"addVertex(...)");
            TimedoorRenderer.renderTimedoor$color(vertexConsumer41, red, green, blue).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
            lineBuffer.addVertex(model, maxX, Mth.lerp((float)middle, (float)maxY, (float)0.0f), minZ).setColor(-1).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
            lineBuffer.addVertex(model, maxX, Mth.lerp((float)middle, (float)maxY, (float)0.0f), minZ).setColor(-1).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
            VertexConsumer vertexConsumer42 = lineBuffer.addVertex(model, maxX, Mth.lerp((float)end, (float)maxY, (float)0.0f), minZ);
            Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer42, (String)"addVertex(...)");
            TimedoorRenderer.renderTimedoor$color(vertexConsumer42, red, green, blue).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
            VertexConsumer vertexConsumer43 = lineBuffer.addVertex(model, maxX, Mth.lerp((float)end, (float)maxY, (float)0.0f), minZ);
            Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer43, (String)"addVertex(...)");
            TimedoorRenderer.renderTimedoor$color(vertexConsumer43, red, green, blue).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
        }
        VertexConsumer vertexConsumer44 = lineBuffer.addVertex(model, maxX, minY, minZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer44, (String)"addVertex(...)");
        VertexConsumer vertexConsumer45 = TimedoorRenderer.renderTimedoor$color(vertexConsumer44, red, green, blue).setNormal(matrix3f, 0.0f, 1.0f, 0.0f).addVertex(model, minX, minY, minZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer45, (String)"addVertex(...)");
        VertexConsumer vertexConsumer46 = TimedoorRenderer.renderTimedoor$color(vertexConsumer45, red, green, blue).setNormal(matrix3f, 0.0f, 0.0f, 1.0f).addVertex(model, minX, minY, maxZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer46, (String)"addVertex(...)");
        VertexConsumer vertexConsumer47 = TimedoorRenderer.renderTimedoor$color(vertexConsumer46, red, green, blue).setNormal(matrix3f, 0.0f, 0.0f, 1.0f).addVertex(model, maxX, minY, minZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer47, (String)"addVertex(...)");
        VertexConsumer vertexConsumer48 = TimedoorRenderer.renderTimedoor$color(vertexConsumer47, red, green, blue).setNormal(matrix3f, 0.0f, 0.0f, -1.0f).addVertex(model, maxX, minY, maxZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer48, (String)"addVertex(...)");
        VertexConsumer vertexConsumer49 = TimedoorRenderer.renderTimedoor$color(vertexConsumer48, red, green, blue).setNormal(matrix3f, 0.0f, 0.0f, -1.0f).addVertex(model, minX, maxY, minZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer49, (String)"addVertex(...)");
        VertexConsumer vertexConsumer50 = TimedoorRenderer.renderTimedoor$color(vertexConsumer49, red, green, blue).setNormal(matrix3f, 0.0f, 0.0f, 1.0f).addVertex(model, minX, maxY, maxZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer50, (String)"addVertex(...)");
        VertexConsumer vertexConsumer51 = TimedoorRenderer.renderTimedoor$color(vertexConsumer50, red, green, blue).setNormal(matrix3f, 0.0f, 0.0f, 1.0f).addVertex(model, maxX, maxY, minZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer51, (String)"addVertex(...)");
        VertexConsumer vertexConsumer52 = TimedoorRenderer.renderTimedoor$color(vertexConsumer51, red, green, blue).setNormal(matrix3f, 0.0f, 0.0f, 1.0f).addVertex(model, maxX, maxY, maxZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer52, (String)"addVertex(...)");
        VertexConsumer vertexConsumer53 = TimedoorRenderer.renderTimedoor$color(vertexConsumer52, red, green, blue).setNormal(matrix3f, 0.0f, 0.0f, 1.0f).addVertex(model, minX, maxY, maxZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer53, (String)"addVertex(...)");
        VertexConsumer vertexConsumer54 = TimedoorRenderer.renderTimedoor$color(vertexConsumer53, red, green, blue).setNormal(matrix3f, 0.0f, -1.0f, 0.0f).addVertex(model, minX, minY, maxZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer54, (String)"addVertex(...)");
        VertexConsumer vertexConsumer55 = TimedoorRenderer.renderTimedoor$color(vertexConsumer54, red, green, blue).setNormal(matrix3f, 0.0f, -1.0f, 0.0f).addVertex(model, minX, minY, maxZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer55, (String)"addVertex(...)");
        VertexConsumer vertexConsumer56 = TimedoorRenderer.renderTimedoor$color(vertexConsumer55, red, green, blue).setNormal(matrix3f, 1.0f, 0.0f, 0.0f).addVertex(model, maxX, minY, maxZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer56, (String)"addVertex(...)");
        vertexConsumer3 = TimedoorRenderer.renderTimedoor$color(vertexConsumer56, red, green, blue).setNormal(matrix3f, 1.0f, 0.0f, 0.0f).addVertex(model, maxX, minY, maxZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer3, (String)"addVertex(...)");
        VertexConsumer vertexConsumer57 = TimedoorRenderer.renderTimedoor$color(vertexConsumer3, red, green, blue).setNormal(matrix3f, 0.0f, 1.0f, 0.0f).addVertex(model, maxX, maxY, maxZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer57, (String)"addVertex(...)");
        VertexConsumer vertexConsumer58 = TimedoorRenderer.renderTimedoor$color(vertexConsumer57, red, green, blue).setNormal(matrix3f, 0.0f, 1.0f, 0.0f).addVertex(model, maxX, maxY, maxZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer58, (String)"addVertex(...)");
        VertexConsumer vertexConsumer59 = TimedoorRenderer.renderTimedoor$color(vertexConsumer58, red, green, blue).setNormal(matrix3f, 1.0f, 0.0f, 0.0f).addVertex(model, minX, maxY, maxZ);
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer59, (String)"addVertex(...)");
        TimedoorRenderer.renderTimedoor$color(vertexConsumer59, red, green, blue).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
    }

    public static /* synthetic */ void renderTimedoor$default(TimedoorRenderer timedoorRenderer, TimedoorPlacementSettings timedoorPlacementSettings, PoseStack poseStack, MultiBufferSource multiBufferSource, float f, float f2, float f3, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 0x100) != 0) {
            bl = true;
        }
        timedoorRenderer.renderTimedoor(timedoorPlacementSettings, poseStack, multiBufferSource, f, f2, f3, n, n2, bl);
    }

    private static final ResourceLocation registerFaceTexture$lambda$3(TimedoorPlacementSettings $sizing, BoxFace $face, TimedoorRenderer this$0, Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<unused var>");
        TextureManager textureManager = Minecraft.getInstance().getTextureManager();
        String string = $sizing.getType().getId().getPath();
        String string2 = $face.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return textureManager.register(string + string2, new DynamicTexture(this$0.texture($sizing, $face)));
    }

    private static final ResourceLocation registerFaceTexture$lambda$4(Function1 $tmp0, Object p0) {
        return (ResourceLocation)$tmp0.invoke(p0);
    }

    private static final VertexConsumer renderTimedoor$color(VertexConsumer $this$renderTimedoor_u24color, float red, float green, float blue) {
        return $this$renderTimedoor_u24color.setColor(red, green, blue, 1.0f);
    }

    private static final VertexConsumer renderTimedoor$size(VertexConsumer $this$renderTimedoor_u24size, float u, float v) {
        if (!ShaderModBridge.INSTANCE.getShadersEnabled()) {
            $this$renderTimedoor_u24size.setUv2((int)(u * (float)16), (int)(v * (float)16));
        }
        return $this$renderTimedoor_u24size;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nj\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u000b"}, d2={"Learth/terrarium/tempad/client/entity/TimedoorRenderer$BoxFace;", "", "<init>", "(Ljava/lang/String;I)V", "FrontBack", "TopBottom", "LeftRight", "getDimensions", "Lorg/joml/Vector2i;", "sizing", "Learth/terrarium/tempad/api/sizing/TimedoorPlacementSettings;", "tempad-1.21.1"})
    public static final class BoxFace
    extends Enum<BoxFace> {
        public static final /* enum */ BoxFace FrontBack = new BoxFace();
        public static final /* enum */ BoxFace TopBottom = new BoxFace();
        public static final /* enum */ BoxFace LeftRight = new BoxFace();
        private static final /* synthetic */ BoxFace[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        @NotNull
        public final Vector2i getDimensions(@NotNull TimedoorPlacementSettings sizing) {
            Intrinsics.checkNotNullParameter((Object)sizing, (String)"sizing");
            return switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1 -> new Vector2i((int)(sizing.widthAtPercent(1.0f) * (float)16), (int)(sizing.heightAtPercent(1.0f) * (float)16));
                case 2 -> new Vector2i((int)(sizing.widthAtPercent(1.0f) * (float)16), (int)(sizing.depthAtPercent(1.0f) * (float)16));
                case 3 -> new Vector2i((int)(sizing.depthAtPercent(1.0f) * (float)16), (int)(sizing.heightAtPercent(1.0f) * (float)16));
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public static BoxFace[] values() {
            return (BoxFace[])$VALUES.clone();
        }

        public static BoxFace valueOf(String value) {
            return Enum.valueOf(BoxFace.class, value);
        }

        @NotNull
        public static EnumEntries<BoxFace> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = boxFaceArray = new BoxFace[]{BoxFace.FrontBack, BoxFace.TopBottom, BoxFace.LeftRight};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=50)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[BoxFace.values().length];
                try {
                    nArray[BoxFace.FrontBack.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BoxFace.TopBottom.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[BoxFace.LeftRight.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003RB\u0010\u0004\u001a6\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0004\u0012\u00020\t0\u0005j\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Learth/terrarium/tempad/client/entity/TimedoorRenderer$Companion;", "", "<init>", "()V", "faceTextures", "Ljava/util/HashMap;", "Lkotlin/Pair;", "Learth/terrarium/tempad/api/sizing/TimedoorPlacementSettings;", "Learth/terrarium/tempad/client/entity/TimedoorRenderer$BoxFace;", "Lnet/minecraft/resources/ResourceLocation;", "Lkotlin/collections/HashMap;", "tempad-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

