/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.common.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.tempad.common.config.CommonConfig;
import earth.terrarium.tempad.common.config.CommonConfigCache;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.UUIDUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB5\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0005J\u000e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0004J\u000e\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0004J\u0006\u0010\u0019\u001a\u00020\u0013J\u0016\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\bR#\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Learth/terrarium/tempad/common/data/MetronomeData;", "", "stored", "", "Ljava/util/UUID;", "", "positions", "", "Lnet/minecraft/core/GlobalPos;", "<init>", "(Ljava/util/Map;Ljava/util/Map;)V", "", "", "getPositions", "()Ljava/util/Map;", "Lit/unimi/dsi/fastutil/objects/Object2IntMap;", "getStored", "()Lit/unimi/dsi/fastutil/objects/Object2IntMap;", "add", "", "player", "pos", "contents", "getCount", "getCapacity", "tick", "remove", "Companion", "tempad-1.21.1"})
@SourceDebugExtension(value={"SMAP\nMetronomeData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetronomeData.kt\nearth/terrarium/tempad/common/data/MetronomeData\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,74:1\n381#2,7:75\n381#2,7:82\n*S KotlinDebug\n*F\n+ 1 MetronomeData.kt\nearth/terrarium/tempad/common/data/MetronomeData\n*L\n42#1:75,7\n70#1:82,7\n*E\n"})
public final class MetronomeData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<UUID, List<GlobalPos>> positions;
    @NotNull
    private final Object2IntMap<UUID> stored;
    @NotNull
    private static final Codec<MetronomeData> codec;

    public MetronomeData(@NotNull Map<UUID, Integer> stored, @NotNull Map<UUID, ? extends List<GlobalPos>> positions) {
        Intrinsics.checkNotNullParameter(stored, (String)"stored");
        Intrinsics.checkNotNullParameter(positions, (String)"positions");
        this.positions = new LinkedHashMap();
        this.stored = (Object2IntMap)new Object2IntOpenHashMap();
        for (Map.Entry<UUID, ? extends List<GlobalPos>> entry : positions.entrySet()) {
            UUID player = entry.getKey();
            List<GlobalPos> blocks = entry.getValue();
            this.positions.put(player, CollectionsKt.toMutableList((Collection)blocks));
        }
        this.stored.putAll(stored);
    }

    @NotNull
    public final Map<UUID, List<GlobalPos>> getPositions() {
        return this.positions;
    }

    @NotNull
    public final Object2IntMap<UUID> getStored() {
        return this.stored;
    }

    public final void add(@NotNull UUID player, @NotNull GlobalPos pos, int contents) {
        List list;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (this.positions.get(player) != null) {
            List<GlobalPos> list2 = this.positions.get(player);
            Intrinsics.checkNotNull(list2);
            if (list2.contains(pos)) {
                return;
            }
        }
        Map<UUID, List<GlobalPos>> $this$getOrPut$iv = this.positions;
        boolean $i$f$getOrPut = false;
        List value$iv = $this$getOrPut$iv.get(player);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(player, answer$iv);
            list = answer$iv;
        } else {
            list = value$iv;
        }
        ((Collection)list).add(pos);
        Map map = (Map)this.stored;
        Integer n = (Integer)this.stored.get((Object)player);
        Integer n2 = contents + (n != null ? n : 0);
        map.put(player, n2);
    }

    public final int getCount(@NotNull UUID player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        List<GlobalPos> list = this.positions.get(player);
        return list != null ? list.size() : 0;
    }

    public final int getCapacity(@NotNull UUID player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        List<GlobalPos> list = this.positions.get(player);
        return (list != null ? list.size() : 0) * CommonConfigCache.Metronome.INSTANCE.getCapacity();
    }

    public final int getStored(@NotNull UUID player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Integer n = (Integer)this.stored.get((Object)player);
        return n != null ? n : 0;
    }

    public final void tick() {
        Object2IntOpenHashMap test = new Object2IntOpenHashMap();
        for (Map.Entry entry : ((Map)this.stored).entrySet()) {
            int n;
            UUID player = (UUID)entry.getKey();
            Integer amount = (Integer)entry.getValue();
            Map map = (Map)this.stored;
            if (CommonConfigCache.Metronome.INSTANCE.getScaleGeneration()) {
                Intrinsics.checkNotNull((Object)player);
                n = this.getCount(player);
            } else {
                n = 1;
            }
            int n2 = CommonConfig.Metronome.generationAmount * n;
            Intrinsics.checkNotNull((Object)amount);
            int n3 = n2 + amount;
            Intrinsics.checkNotNull((Object)player);
            map.put(player, RangesKt.coerceAtMost((int)n3, (int)this.getCapacity(player)));
        }
    }

    public final int remove(@NotNull UUID player, @NotNull GlobalPos pos) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (this.getCapacity(player) == 0) {
            return 0;
        }
        Integer n = (Integer)this.stored.get((Object)player);
        if (n != null) {
            List list;
            int it = ((Number)n).intValue();
            boolean bl = false;
            int amount = it / this.getCount(player);
            ((Map)this.stored).put(player, it - amount);
            Map<UUID, List<GlobalPos>> $this$getOrPut$iv = this.positions;
            boolean $i$f$getOrPut = false;
            List value$iv = $this$getOrPut$iv.get(player);
            if (value$iv == null) {
                boolean bl2 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(player, answer$iv);
                list = answer$iv;
            } else {
                list = value$iv;
            }
            ((Collection)list).remove(pos);
            return amount;
        }
        return 0;
    }

    private static final Map codec$lambda$5$lambda$3(MetronomeData it) {
        return (Map)it.stored;
    }

    private static final Map codec$lambda$5$lambda$4(MetronomeData it) {
        return it.positions;
    }

    private static final App codec$lambda$5(RecordCodecBuilder.Instance it) {
        return it.group((App)Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, (Codec)((Codec)Codec.INT)).fieldOf("stored").forGetter(MetronomeData::codec$lambda$5$lambda$3), (App)Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, (Codec)GlobalPos.CODEC.listOf()).fieldOf("positions").forGetter(MetronomeData::codec$lambda$5$lambda$4)).apply((Applicative)it, MetronomeData::new);
    }

    static {
        Codec codec2 = RecordCodecBuilder.create(MetronomeData::codec$lambda$5);
        Intrinsics.checkNotNullExpressionValue((Object)codec2, (String)"create(...)");
        codec = codec2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Learth/terrarium/tempad/common/data/MetronomeData$Companion;", "", "<init>", "()V", "codec", "Lcom/mojang/serialization/Codec;", "Learth/terrarium/tempad/common/data/MetronomeData;", "getCodec", "()Lcom/mojang/serialization/Codec;", "tempad-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Codec<MetronomeData> getCodec() {
            return codec;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

