/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.common.items;

import earth.terrarium.tempad.api.tva_device.ChrononHandler;
import earth.terrarium.tempad.api.tva_device.ChrononHandlerKt;
import earth.terrarium.tempad.common.items.ChrononItem;
import earth.terrarium.tempad.common.registries.ModTags;
import earth.terrarium.tempad.common.utils.ExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007H\u0016J(\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a8\u0006\u001d"}, d2={"Learth/terrarium/tempad/common/items/CapacitorItem;", "Learth/terrarium/tempad/common/items/ChrononItem;", "<init>", "()V", "inventoryTick", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "entity", "Lnet/minecraft/world/entity/Entity;", "slot", "", "selected", "", "isChargable", "source", "target", "overrideStackedOnOther", "Lnet/minecraft/world/inventory/Slot;", "action", "Lnet/minecraft/world/inventory/ClickAction;", "player", "Lnet/minecraft/world/entity/player/Player;", "useOn", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "tempad-1.21.1"})
@SourceDebugExtension(value={"SMAP\nCapacitorItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CapacitorItem.kt\nearth/terrarium/tempad/common/items/CapacitorItem\n+ 2 Extensions.kt\nearth/terrarium/tempad/common/utils/ExtensionsKt\n*L\n1#1,52:1\n212#2:53\n*S KotlinDebug\n*F\n+ 1 CapacitorItem.kt\nearth/terrarium/tempad/common/items/CapacitorItem\n*L\n31#1:53\n*E\n"})
public class CapacitorItem
extends ChrononItem {
    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean selected) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        super.inventoryTick(stack, level, entity, slot, selected);
        if (level.isClientSide || entity.tickCount % 10 != 0 || this.cannotDistribute(entity, stack)) {
            return;
        }
        this.distribute((Player)entity, stack);
    }

    @Override
    public boolean isChargable(@NotNull ItemStack source, @NotNull ItemStack target) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return super.isChargable(source, target) && !ExtensionsKt.contains(ModTags.INSTANCE.getBatteries(), target);
    }

    /*
     * WARNING - void declaration
     */
    public boolean overrideStackedOnOther(@NotNull ItemStack stack, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (action == ClickAction.SECONDARY && slot.hasItem()) {
            ItemStack itemStack = ExtensionsKt.getContents(slot);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"<get-contents>(...)");
            if (ChrononHandlerKt.getChronons(itemStack) != null) {
                void p1$iv;
                ChrononHandler chrononHandler = ChrononHandlerKt.getChronons(stack);
                ItemStack itemStack2 = ExtensionsKt.getContents(slot);
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"<get-contents>(...)");
                ChrononHandler p2$iv = ChrononHandlerKt.getChronons(itemStack2);
                boolean $i$f$safeLet = false;
                if (p1$iv != null && p2$iv != null) {
                    void to;
                    ChrononHandler chrononHandler2 = p2$iv;
                    void from = p1$iv;
                    boolean bl = false;
                    ChrononHandlerKt.move((ChrononHandler)from, (ChrononHandler)to, 1000);
                }
                return true;
            }
        }
        return super.overrideStackedOnOther(stack, slot, action, player);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        block1: {
            ChrononHandler it;
            Object block;
            block2: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Object object = context.getLevel().getBlockEntity(context.getClickedPos());
                if (object == null || (object = ChrononHandlerKt.getChronons((BlockEntity)object)) == null) {
                    InteractionResult interactionResult = super.useOn(context);
                    Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useOn(...)");
                    return interactionResult;
                }
                block = object;
                if (context.getLevel().isClientSide) break block1;
                ItemStack itemStack = context.getItemInHand();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInHand(...)");
                ChrononHandler chrononHandler = ChrononHandlerKt.getChronons(itemStack);
                if (chrononHandler == null) break block1;
                it = chrononHandler;
                boolean bl = false;
                if (it.getPower() != 0 || !block.getCanExtract()) break block2;
                ChrononHandlerKt.move((ChrononHandler)block, it, it.getMaxPower());
                break block1;
            }
            if (!block.getCanInsert()) break block1;
            ChrononHandlerKt.move(it, (ChrononHandler)block, block.getMaxPower());
        }
        return InteractionResult.SUCCESS;
    }
}

