/*
 * Decompiled with CFR 0.152.
 */
package gisellevonbingen.mmp.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gisellevonbingen.mmp.common.MoreMekanismProcessing;
import gisellevonbingen.mmp.common.RepresentationUtils;
import gisellevonbingen.mmp.common.crafting.ITaggedOutputRecipe;
import gisellevonbingen.mmp.common.crafting.MMPRecipeSerializers;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.basic.BasicChemicalCrystallizerRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.registries.MekanismItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class ChemicalCrystallizerTaggedOutputRecipe
extends BasicChemicalCrystallizerRecipe
implements ITaggedOutputRecipe {
    protected final ItemStackIngredient output;
    private int revision;
    private ItemStack cachedResult;

    public ChemicalCrystallizerTaggedOutputRecipe(ChemicalStackIngredient input, ItemStackIngredient output) {
        super(input, MekanismItems.ATOMIC_ALLOY.asStack());
        this.output = output;
    }

    public RecipeSerializer<BasicChemicalCrystallizerRecipe> getSerializer() {
        return (RecipeSerializer)MMPRecipeSerializers.TAG_CRYSTALLIZING.get();
    }

    @Override
    public ItemStackIngredient getTaggedResult() {
        return this.output;
    }

    @Override
    public ItemStack getItemStackResult() {
        int revision = MoreMekanismProcessing.TAGS_UPDATED_REVISION;
        if (this.revision != revision || this.cachedResult == null) {
            this.revision = revision;
            this.cachedResult = RepresentationUtils.getRepresentation(this.output);
        }
        return this.cachedResult;
    }

    public ItemStack getOutput(ChemicalStack input) {
        return this.getItemStackResult().copy();
    }

    public ItemStack getResultItem(@NotNull HolderLookup.Provider provider) {
        return this.getItemStackResult().copy();
    }

    public List<ItemStack> getOutputDefinition() {
        return Collections.singletonList(this.getItemStackResult());
    }

    public ItemStack getOutputRaw() {
        return this.getItemStackResult();
    }

    public static class Serializer
    implements RecipeSerializer<ChemicalCrystallizerTaggedOutputRecipe> {
        private final StreamCodec<RegistryFriendlyByteBuf, ChemicalCrystallizerTaggedOutputRecipe> streamCodec;
        private final MapCodec<ChemicalCrystallizerTaggedOutputRecipe> codec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IngredientCreatorAccess.chemicalStack().codec().fieldOf("input").forGetter(BasicChemicalCrystallizerRecipe::getInput), (App)ItemStackIngredient.CODEC.fieldOf("output").forGetter(ChemicalCrystallizerTaggedOutputRecipe::getTaggedResult)).apply((Applicative)instance, factory));

        public Serializer(BiFunction<ChemicalStackIngredient, ItemStackIngredient, ChemicalCrystallizerTaggedOutputRecipe> factory) {
            this.streamCodec = StreamCodec.composite((StreamCodec)IngredientCreatorAccess.chemicalStack().streamCodec(), BasicChemicalCrystallizerRecipe::getInput, (StreamCodec)ItemStackIngredient.STREAM_CODEC, ChemicalCrystallizerTaggedOutputRecipe::getTaggedResult, factory);
        }

        @NotNull
        public MapCodec<ChemicalCrystallizerTaggedOutputRecipe> codec() {
            return this.codec;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ChemicalCrystallizerTaggedOutputRecipe> streamCodec() {
            return this.streamCodec;
        }
    }
}

