/*
 * Decompiled with CFR 0.152.
 */
package gisellevonbingen.mmp.common.material;

import gisellevonbingen.mmp.common.MoreMekanismProcessing;
import gisellevonbingen.mmp.common.config.MMPConfigs;
import gisellevonbingen.mmp.common.material.MaterialResultShape;
import gisellevonbingen.mmp.common.material.MaterialState;
import gisellevonbingen.mmp.common.material.MaterialTypeBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import mekanism.common.registration.impl.ItemRegistryObject;
import mekanism.common.registries.MekanismItems;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.apache.commons.lang3.StringUtils;

public enum MaterialType {
    ALUMINUM(new MaterialTypeBuilder("aluminum").resultShape(MaterialResultShape.INGOT).displayName("Aluminum").color(10536152)),
    AMETHYST(new MaterialTypeBuilder("amethyst").resultShape(MaterialResultShape.GEM).displayName("Amethyst").color(0xCC33CC).presetItem(MaterialState.GEM, Items.AMETHYST_SHARD)),
    APATITE(new MaterialTypeBuilder("apatite").resultShape(MaterialResultShape.GEM).displayName("Apatite").color(3511730)),
    AZURESILER(new MaterialTypeBuilder("azure_silver").resultShape(MaterialResultShape.INGOT).displayName("Azure Silver").color(13540595)),
    BISMUTH(new MaterialTypeBuilder("bismuth").resultShape(MaterialResultShape.INGOT).displayName("Bismuth").color(0xE8D8E8)),
    BORON(new MaterialTypeBuilder("boron").resultShape(MaterialResultShape.INGOT).displayName("Boron").color(0x7C7C7C)),
    BORT(new MaterialTypeBuilder("bort").resultShape(MaterialResultShape.GEM).displayName("Bort").color(7640495)),
    CINNABAR(new MaterialTypeBuilder("cinnabar").resultShape(MaterialResultShape.GEM).displayName("Cinnabar").color(0x990F0F)),
    COBALT(new MaterialTypeBuilder("cobalt").resultShape(MaterialResultShape.INGOT).displayName("Cobalt").color(1992383)),
    CRIMSONIRON(new MaterialTypeBuilder("crimson_iron").resultShape(MaterialResultShape.INGOT).displayName("Crimson Iron").color(16009072)),
    DESH(new MaterialTypeBuilder("desh").resultShape(MaterialResultShape.INGOT).displayName("Desh").color(16752465)),
    DILITHIUM(new MaterialTypeBuilder("dilithium").resultShape(MaterialResultShape.GEM).displayName("Dilithium").color(14206148)),
    DRACONIUM(new MaterialTypeBuilder("draconium").resultShape(MaterialResultShape.INGOT).displayName("Draconium").color(10703308)),
    ELECTROTINE(new MaterialTypeBuilder("electrotine").resultShape(MaterialResultShape.DUST).displayName("Electrotine").color(832760)),
    GREENSAPPHIRE(new MaterialTypeBuilder("green_sapphire").resultShape(MaterialResultShape.GEM).displayName("Green Sapphire").color(0x33CC33)),
    IRIDIUM(new MaterialTypeBuilder("iridium").resultShape(MaterialResultShape.INGOT).displayName("Iridium").color(14211268)),
    LITHIUM(new MaterialTypeBuilder("lithium").resultShape(MaterialResultShape.INGOT).displayName("Lithium").color(0x808080).presetItem(MaterialState.DUST, (ItemRegistryObject<Item>)MekanismItems.LITHIUM_DUST)),
    MAGNESIUM(new MaterialTypeBuilder("magnesium").resultShape(MaterialResultShape.INGOT).displayName("Magnesium").color(15186405)),
    NICKEL(new MaterialTypeBuilder("nickel").resultShape(MaterialResultShape.INGOT).displayName("Nickel").color(15065246)),
    NITER(new MaterialTypeBuilder("niter").resultShape(MaterialResultShape.GEM).displayName("Niter").color(12103599)),
    PERIDOT(new MaterialTypeBuilder("peridot").resultShape(MaterialResultShape.GEM).displayName("Peridot").color(0x66FF66)),
    PLATINUM(new MaterialTypeBuilder("platinum").resultShape(MaterialResultShape.INGOT).displayName("Platinum").color(0xA0F0FF)),
    RUBY(new MaterialTypeBuilder("ruby").resultShape(MaterialResultShape.GEM).displayName("Ruby").color(0xCC3333)),
    SAPPHIRE(new MaterialTypeBuilder("sapphire").resultShape(MaterialResultShape.GEM).displayName("Sapphire").color(0x3333CC)),
    OSTRUM(new MaterialTypeBuilder("ostrum").resultShape(MaterialResultShape.INGOT).displayName("Ostrum").color(10445167)),
    CALORITE(new MaterialTypeBuilder("calorite").resultShape(MaterialResultShape.INGOT).displayName("Calorite").color(12862025)),
    SILVER(new MaterialTypeBuilder("silver").resultShape(MaterialResultShape.INGOT).displayName("Silver").color(14214381)),
    SULFUR(new MaterialTypeBuilder("sulfur").resultShape(MaterialResultShape.DUST).displayName("Sulfur").color(14208081).presetItem(MaterialState.DUST, (ItemRegistryObject<Item>)MekanismItems.SULFUR_DUST)),
    TITANIUM(new MaterialTypeBuilder("titanium").resultShape(MaterialResultShape.INGOT).displayName("Titanium").color(4214880)),
    TUNGSTEN(new MaterialTypeBuilder("tungsten").resultShape(MaterialResultShape.INGOT).displayName("Tungsten").color(0x333333)),
    THORIUM(new MaterialTypeBuilder("thorium").resultShape(MaterialResultShape.INGOT).displayName("Thorium").color(0x2E2E2E)),
    ZINC(new MaterialTypeBuilder("zinc").resultShape(MaterialResultShape.INGOT).displayName("Zinc").color(0xCCCC8E)),
    COAL(new MaterialTypeBuilder("coal").respect(true).resultShape(MaterialResultShape.DUST).displayName("Coal").color(0x2D2D2D).presetItem(MaterialState.DUST, (ItemRegistryObject<Item>)MekanismItems.COAL_DUST)),
    LAPIS(new MaterialTypeBuilder("lapis").respect(true).resultShape(MaterialResultShape.DUST).displayName("Lapis Lazuli").color(2910664).presetItem(MaterialState.DUST, (ItemRegistryObject<Item>)MekanismItems.LAPIS_LAZULI_DUST)),
    DIAMOND(new MaterialTypeBuilder("diamond").respect(true).resultShape(MaterialResultShape.DUST).displayName("Diamond").color(4844246).presetItem(MaterialState.DUST, (ItemRegistryObject<Item>)MekanismItems.DIAMOND_DUST)),
    REDSTONE(new MaterialTypeBuilder("redstone").respect(true).resultShape(MaterialResultShape.DUST).displayName("Redstone").color(0xFF0000).presetItem(MaterialState.DUST, Items.REDSTONE)),
    EMERALD(new MaterialTypeBuilder("emerald").respect(true).resultShape(MaterialResultShape.DUST).displayName("Emerald").color(1563233).presetItem(MaterialState.DUST, (ItemRegistryObject<Item>)MekanismItems.EMERALD_DUST)),
    QUARTZ(new MaterialTypeBuilder("quartz").respect(true).resultShape(MaterialResultShape.DUST).displayName("Nether Quartz").color(15459291).presetItem(MaterialState.DUST, (ItemRegistryObject<Item>)MekanismItems.QUARTZ_DUST));

    private final String baseName;
    private final Map<MaterialState, ResourceLocation> presetItems;
    private final MaterialResultShape resultShape;
    private final String displayName;
    private final int defaultColor;
    private final boolean respectMekanism;

    private MaterialType(MaterialTypeBuilder builder) {
        this.baseName = builder.baseName();
        this.resultShape = builder.resultShape();
        this.presetItems = new HashMap<MaterialState, ResourceLocation>(builder.presetItems());
        this.displayName = builder.displayName();
        this.defaultColor = builder.color();
        this.respectMekanism = builder.respect();
    }

    public static Optional<MaterialType> find(String name) {
        return Arrays.stream(MaterialType.values()).filter(t -> StringUtils.equals((CharSequence)t.getBaseName(), (CharSequence)name)).findAny();
    }

    public String getDescriptionId() {
        return MaterialType.makeDescriptionId(this.baseName);
    }

    public static String makeDescriptionId(String baseName) {
        return Util.makeDescriptionId((String)"materialType", (ResourceLocation)MoreMekanismProcessing.rl(baseName));
    }

    public String getBaseName() {
        return this.baseName;
    }

    public Map<MaterialState, ResourceLocation> getPresetItems() {
        return new HashMap<MaterialState, ResourceLocation>(this.presetItems);
    }

    public ResourceLocation getPresetItem(MaterialState materialState) {
        return this.presetItems.get((Object)materialState);
    }

    public MaterialResultShape getResultShape() {
        return this.resultShape;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getDefaultColor() {
        return this.defaultColor;
    }

    public int getColor() {
        Integer color = MMPConfigs.CLIENT.parsedColors.get((Object)this);
        return color != null ? color.intValue() : this.getDefaultColor();
    }

    public boolean isRespectMekanism() {
        return this.respectMekanism;
    }
}

