/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.enchantment;

import com.almostreliable.morejs.features.enchantment.EnchantmentMenuExtension;
import com.almostreliable.morejs.features.villager.IntRange;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;

public class EnchantmentData {
    private final List<EnchantmentInstance> enchantments;
    private final int dataSlotIndex;
    private final EnchantmentMenu menu;
    private final Level level;

    public EnchantmentData(List<EnchantmentInstance> enchantments, int dataSlotIndex, EnchantmentMenu menu, Level level) {
        this.enchantments = enchantments;
        this.dataSlotIndex = dataSlotIndex;
        this.menu = menu;
        this.level = level;
    }

    public int getRequiredLevel() {
        return this.menu.costs[this.dataSlotIndex];
    }

    public void setRequiredLevel(int level) {
        this.menu.costs[this.dataSlotIndex] = level;
    }

    @Nullable
    public EnchantmentInstance getClue() {
        Registry registry = this.level.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        EnchantmentMenuExtension ext = EnchantmentMenuExtension.morejs$cast(this.menu);
        int id = ext.morejs$getEnchantmentClues()[this.dataSlotIndex];
        int level = ext.morejs$getLevelClues()[this.dataSlotIndex];
        return registry.getHolder(id).map(enchantment -> new EnchantmentInstance((Holder)enchantment, level)).orElse(null);
    }

    public void setClue(Holder<Enchantment> enchantment, int enchantmentLevel) {
        Registry registry = this.level.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        EnchantmentMenuExtension ext = EnchantmentMenuExtension.morejs$cast(this.menu);
        ext.morejs$getEnchantmentClues()[this.dataSlotIndex] = registry.getId((Object)((Enchantment)enchantment.value()));
        ext.morejs$getLevelClues()[this.dataSlotIndex] = enchantmentLevel;
    }

    public void setClue(EnchantmentInstance ei) {
        this.setClue((Holder<Enchantment>)ei.enchantment, ei.level);
    }

    public void randomClue() {
        if (this.enchantments.isEmpty()) {
            this.clearClue();
            return;
        }
        EnchantmentMenuExtension ext = EnchantmentMenuExtension.morejs$cast(this.menu);
        EnchantmentInstance ei = this.enchantments.get(ext.morejs$getRandom().nextInt(this.enchantments.size()));
        this.setClue(ei);
    }

    public void clearClue() {
        EnchantmentMenuExtension ext = EnchantmentMenuExtension.morejs$cast(this.menu);
        ext.morejs$getEnchantmentClues()[this.dataSlotIndex] = -1;
        ext.morejs$getLevelClues()[this.dataSlotIndex] = 0;
    }

    public List<EnchantmentInstance> getEnchantments() {
        return this.enchantments;
    }

    public List<ResourceLocation> getEnchantmentIds() {
        return this.getEnchantments().stream().flatMap(e -> e.enchantment.unwrapKey().stream()).map(ResourceKey::location).toList();
    }

    public boolean hasEnchantment(ResourceLocation id) {
        return this.hasEnchantment(id, IntRange.all());
    }

    public boolean hasEnchantment(ResourceLocation id, IntRange range) {
        Registry registry = this.level.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        return registry.getHolder(id).filter(ref -> {
            for (EnchantmentInstance ei : this.getEnchantments()) {
                if (ei.enchantment != ref || !range.test(ei.level)) continue;
                return true;
            }
            return false;
        }).isPresent();
    }

    public void removeEnchantments(BiPredicate<Holder<Enchantment>, Integer> consumer) {
        this.getEnchantments().removeIf(i -> consumer.test(i.enchantment, i.level));
    }

    public void addEnchantment(Holder<Enchantment> enchantment, int level) {
        Objects.requireNonNull(enchantment, "Enchantment does not exist");
        this.getEnchantments().add(new EnchantmentInstance(enchantment, level));
    }
}

