/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities;

import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.EnergyData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.init.DEModules;
import com.brandon3055.draconicevolution.init.ItemData;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public class EnergyEntity
extends ModuleEntity<EnergyData> {
    private long energy = 0L;
    public static final Codec<EnergyEntity> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)DEModules.codec().fieldOf("module").forGetter(EnergyEntity::getModule), (App)Codec.INT.fieldOf("gridx").forGetter(ModuleEntity::getGridX), (App)Codec.INT.fieldOf("gridy").forGetter(ModuleEntity::getGridY), (App)Codec.LONG.fieldOf("energy").forGetter(e -> e.energy)).apply((Applicative)builder, EnergyEntity::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, EnergyEntity> STREAM_CODEC = StreamCodec.composite(DEModules.streamCodec(), ModuleEntity::getModule, (StreamCodec)ByteBufCodecs.INT, ModuleEntity::getGridX, (StreamCodec)ByteBufCodecs.INT, ModuleEntity::getGridY, (StreamCodec)ByteBufCodecs.VAR_LONG, e -> e.energy, EnergyEntity::new);

    public EnergyEntity(Module<EnergyData> module) {
        super(module);
    }

    EnergyEntity(Module<?> module, int gridX, int gridY, long energy) {
        super(module, gridX, gridY);
        this.energy = energy;
    }

    @Override
    public ModuleEntity<?> copy() {
        return new EnergyEntity(this.module, this.getGridX(), this.getGridY(), this.energy);
    }

    @Override
    public Module<EnergyData> getModule() {
        return super.getModule();
    }

    @Override
    public void onRemoved(ModuleContext context) {
        super.onRemoved(context);
        IOPStorage storage = context.getOpStorage();
        if (this.energy > 0L && storage != null) {
            storage.modifyEnergyStored(-this.energy);
        }
    }

    @Override
    public void onInstalled(ModuleContext context) {
        super.onInstalled(context);
        IOPStorage storage = context.getOpStorage();
        if (this.energy > 0L && storage != null) {
            storage.modifyEnergyStored(this.energy);
        }
    }

    @Override
    public void saveEntityToStack(ItemStack stack, ModuleContext context) {
        IOPStorage storage = context.getOpStorage();
        if (storage != null) {
            long moduleCap = ModuleTypes.ENERGY_STORAGE.getData(this.module).capacity();
            long newCapacity = storage.getMaxOPStored() - moduleCap;
            if (newCapacity < storage.getOPStored()) {
                this.energy = Math.min(storage.getOPStored() - newCapacity, moduleCap);
                stack.set(ItemData.ENERGY_MODULE_ENERGY, (Object)this.energy);
                this.markDirty();
            } else {
                this.energy = 0L;
            }
        }
    }

    @Override
    public void loadEntityFromStack(ItemStack stack, ModuleContext context) {
        this.energy = (Long)stack.getOrDefault(ItemData.ENERGY_MODULE_ENERGY, (Object)0L);
    }
}

