/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.entities;

import codechicken.lib.gui.modular.sprite.Material;
import com.brandon3055.brandonscore.api.BCStreamCodec;
import com.brandon3055.brandonscore.client.BCGuiTextures;
import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.data.NoData;
import com.brandon3055.draconicevolution.api.modules.entities.FilteredModuleEntity;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.init.DEModules;
import com.brandon3055.draconicevolution.init.ItemData;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class JunkFilterEntity
extends FilteredModuleEntity<NoData> {
    protected BooleanProperty filterEnabled = this.createEnabledProperty("junk_filter_mod", true);
    public static final Codec<JunkFilterEntity> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)DEModules.codec().fieldOf("module").forGetter(ModuleEntity::getModule), (App)Codec.INT.fieldOf("gridx").forGetter(ModuleEntity::getGridX), (App)Codec.INT.fieldOf("gridy").forGetter(ModuleEntity::getGridY), (App)FILTERS_CODEC.fieldOf("filters").forGetter(e -> e.filters), (App)BooleanProperty.CODEC.fieldOf("enabled").forGetter(e -> e.filterEnabled)).apply((Applicative)builder, JunkFilterEntity::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, JunkFilterEntity> STREAM_CODEC = BCStreamCodec.composite(DEModules.streamCodec(), ModuleEntity::getModule, (StreamCodec)ByteBufCodecs.INT, ModuleEntity::getGridX, (StreamCodec)ByteBufCodecs.INT, ModuleEntity::getGridY, (StreamCodec)FILTERS_STREAM_CODEC, e -> e.filters, BooleanProperty.STREAM_CODEC, e -> e.filterEnabled, JunkFilterEntity::new);

    public JunkFilterEntity(Module<NoData> module) {
        super(module, 9);
    }

    JunkFilterEntity(Module<?> module, int gridX, int gridY, List<FilteredModuleEntity.Filter> filters, BooleanProperty filterEnabled) {
        super(module, gridX, gridY, 9, filters);
        this.filterEnabled = filterEnabled;
    }

    @Override
    public ModuleEntity<?> copy() {
        return new JunkFilterEntity(this.module, this.getGridX(), this.getGridY(), this.copyFilters(this.filters), this.filterEnabled.copy());
    }

    @Override
    public void getEntityProperties(List<ConfigProperty> properties) {
        super.getEntityProperties(properties);
        properties.add(this.filterEnabled);
    }

    @Override
    protected List<FilteredModuleEntity.Slot> layoutSlots(int x, int y, int width, int height) {
        ArrayList<FilteredModuleEntity.Slot> slots = new ArrayList<FilteredModuleEntity.Slot>();
        double slotXSize = (double)width / 3.0;
        double slotYSize = (double)height / 3.0;
        for (int i = 0; i < this.slotsCount; ++i) {
            double xPos = (double)x + (double)(i % 3) * slotXSize;
            double yPos = (double)y + (double)(i / 3) * slotYSize;
            slots.add(new FilteredModuleEntity.Slot(i, xPos, yPos, slotXSize));
        }
        return slots;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected Material getSlotOverlay() {
        return BCGuiTextures.get((String)"slots/trash");
    }

    @Override
    public boolean isEnabled() {
        return this.filterEnabled.getValue();
    }

    @Override
    public void saveEntityToStack(ItemStack stack, ModuleContext context) {
        super.saveEntityToStack(stack, context);
        stack.set(ItemData.BOOL_ITEM_PROP_1, (Object)this.filterEnabled.copy());
    }

    @Override
    public void loadEntityFromStack(ItemStack stack, ModuleContext context) {
        super.loadEntityFromStack(stack, context);
        this.filterEnabled = ((BooleanProperty)stack.getOrDefault(ItemData.BOOL_ITEM_PROP_1, (Object)this.filterEnabled)).copy();
    }
}

