/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import codechicken.lib.gui.modular.ModularGui;
import codechicken.lib.gui.modular.ModularGuiContainer;
import codechicken.lib.gui.modular.elements.GuiButton;
import codechicken.lib.gui.modular.elements.GuiColourPicker;
import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.elements.GuiEnergyBar;
import codechicken.lib.gui.modular.elements.GuiManipulable;
import codechicken.lib.gui.modular.elements.GuiRectangle;
import codechicken.lib.gui.modular.elements.GuiSlots;
import codechicken.lib.gui.modular.elements.GuiText;
import codechicken.lib.gui.modular.elements.GuiTextField;
import codechicken.lib.gui.modular.elements.GuiTexture;
import codechicken.lib.gui.modular.lib.ColourState;
import codechicken.lib.gui.modular.lib.Constraints;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.lib.TextState;
import codechicken.lib.gui.modular.lib.container.ContainerGuiProvider;
import codechicken.lib.gui.modular.lib.container.ContainerScreenAccess;
import codechicken.lib.gui.modular.lib.container.SlotGroup;
import codechicken.lib.gui.modular.lib.geometry.ConstrainedGeometry;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.Direction;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import codechicken.lib.gui.modular.lib.geometry.GeoRef;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.BCConfig;
import com.brandon3055.brandonscore.api.power.IOInfo;
import com.brandon3055.brandonscore.client.BCGuiTextures;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.modulargui.ShaderEnergyBar;
import com.brandon3055.brandonscore.client.gui.modulargui.templates.ButtonRow;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedByte;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.lib.datamanager.ManagedString;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCore;
import com.brandon3055.draconicevolution.client.DEGuiTextures;
import com.brandon3055.draconicevolution.inventory.EnergyCoreMenu;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class EnergyCoreGui
extends ContainerGuiProvider<EnergyCoreMenu> {
    private static final GuiToolkit TOOLKIT = new GuiToolkit("gui.draconicevolution.energy_core");
    private final AtomicBoolean colourSelectMode;
    public static final int GUI_WIDTH = 180;
    public static final int GUI_HEIGHT = 200;
    private static final BigDecimal MAX_BIGINT = new BigDecimal("9999e9999");

    public EnergyCoreGui(AtomicBoolean hideJEI) {
        this.colourSelectMode = hideJEI;
    }

    public GuiElement<?> createRootElement(ModularGui gui) {
        GuiManipulable root = new GuiManipulable((GuiParent)gui).addMoveHandle(3).enableCursors(true);
        GuiTexture bg = (GuiTexture)new GuiTexture((GuiParent)root.getContentElement(), DEGuiTextures.themedGetter("energy_core")).setEnabled(() -> !this.colourSelectMode.get());
        Constraints.bind((ConstrainedGeometry)bg, (ConstrainedGeometry)root.getContentElement());
        return root;
    }

    public void buildGui(ModularGui gui, ContainerScreenAccess<EnergyCoreMenu> screenAccess) {
        gui.initStandardGui(180, 200);
        EnergyCoreMenu menu = (EnergyCoreMenu)screenAccess.getMenu();
        TileEnergyCore tile = (TileEnergyCore)menu.tile;
        GuiElement actualRoot = gui.getRoot();
        GuiElement root = new GuiElement((GuiParent)actualRoot).setEnabled(() -> !this.colourSelectMode.get());
        Constraints.bind((ConstrainedGeometry)root, (ConstrainedGeometry)actualRoot);
        GuiText title = TOOLKIT.createHeading((GuiParent)root, gui.getGuiTitle(), true).setTextSupplier(() -> TOOLKIT.translate("title", new Object[]{tile.tier.get()}));
        gui.renderScreenBackground(!this.colourSelectMode.get());
        ButtonRow buttonRow = ButtonRow.topRightInside((GuiElement)root, (Direction)Direction.DOWN, (int)3, (int)3).setSpacing(1.0);
        buttonRow.addButton(arg_0 -> ((GuiToolkit)TOOLKIT).createThemeButton(arg_0));
        GuiSlots.Player playInv = GuiSlots.player((GuiParent)root, screenAccess, (SlotGroup)menu.main, (SlotGroup)menu.hotBar);
        playInv.stream().forEach(e -> e.setSlotTexture(slot -> BCGuiTextures.getThemed((String)"slot")));
        Constraints.placeInside((ConstrainedGeometry)playInv.container(), (ConstrainedGeometry)root, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)-7.0);
        GuiText slotsTitle = TOOLKIT.playerInvTitle(playInv.container());
        GuiButton activate = ((GuiButton)TOOLKIT.createFlat3DButton((GuiParent)root, () -> TOOLKIT.translate(tile.active.get() ? "deactivate" : "activate", new Object[0])).setEnabled(() -> !tile.active.get() && tile.isStructureValid())).onPress(() -> tile.sendPacketToServer(e -> {}, 1));
        Constraints.size((ConstrainedGeometry)activate, (double)162.0, (double)14.0);
        Constraints.placeOutside((ConstrainedGeometry)activate, (ConstrainedGeometry)playInv.container(), (Constraints.LayoutPos)Constraints.LayoutPos.TOP_CENTER, (double)0.0, (double)-14.0);
        GuiButton tierDown = ((GuiButton)TOOLKIT.createFlat3DButton((GuiParent)root, () -> TOOLKIT.translate("tier_down", new Object[0])).setEnabled(() -> !tile.active.get())).setDisabled(() -> tile.tier.get() <= 1).onPress(() -> ((ManagedByte)tile.tier).dec());
        Constraints.size((ConstrainedGeometry)tierDown, (double)80.0, (double)14.0);
        Constraints.placeInside((ConstrainedGeometry)tierDown, (ConstrainedGeometry)activate, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_LEFT, (double)0.0, (double)-15.0);
        GuiButton tierUp = ((GuiButton)TOOLKIT.createFlat3DButton((GuiParent)root, () -> TOOLKIT.translate("tier_up", new Object[0])).setEnabled(() -> !tile.active.get())).setDisabled(() -> tile.tier.get() >= 8).onPress(() -> ((ManagedByte)tile.tier).inc());
        Constraints.size((ConstrainedGeometry)tierUp, (double)80.0, (double)14.0);
        Constraints.placeInside((ConstrainedGeometry)tierUp, (ConstrainedGeometry)activate, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_RIGHT, (double)0.0, (double)-15.0);
        GuiButton buildGuide = (GuiButton)TOOLKIT.createFlat3DButton((GuiParent)root, () -> TOOLKIT.translate("build_guide", new Object[0])).setToggleMode(() -> ((ManagedBool)tile.buildGuide).get()).onPress(() -> ((ManagedBool)tile.buildGuide).invert()).setEnabled(() -> !tile.active.get());
        Constraints.size((ConstrainedGeometry)buildGuide, (double)162.0, (double)14.0);
        Constraints.placeOutside((ConstrainedGeometry)buildGuide, (ConstrainedGeometry)activate, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_CENTER, (double)0.0, (double)-16.0);
        GuiButton assemble = (GuiButton)TOOLKIT.createFlat3DButton((GuiParent)root, () -> TOOLKIT.translate("assemble", new Object[0])).onPress(() -> tile.sendPacketToServer(e -> {}, 2)).setEnabled(() -> !tile.isStructureValid());
        Constraints.bind((ConstrainedGeometry)assemble, (ConstrainedGeometry)activate);
        GuiButton disable = (GuiButton)((GuiButton)TOOLKIT.createThemedIconButton((GuiParent)root, "pwr_btn").setEnabled(() -> ((ManagedBool)tile.active).get())).onPress(() -> tile.sendPacketToServer(e -> {}, 1)).setTooltip(new Component[]{TOOLKIT.translate("deactivate", new Object[0])});
        Constraints.placeInside((ConstrainedGeometry)disable, (ConstrainedGeometry)root, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_LEFT, (double)3.0, (double)3.0);
        GuiText coreInvalidLabel = (GuiText)TOOLKIT.createHeading((GuiParent)root, (Component)TOOLKIT.translate("core_invalid", new Object[0]).withStyle(ChatFormatting.RED)).setEnabled(() -> !tile.active.get() && !tile.coreValid.get());
        Constraints.size((ConstrainedGeometry)coreInvalidLabel, (double)playInv.container().xSize(), (double)8.0);
        Constraints.placeOutside((ConstrainedGeometry)coreInvalidLabel, (ConstrainedGeometry)title, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)5.0);
        GuiText stabInvalidLabel = (GuiText)TOOLKIT.createHeading((GuiParent)root, (Component)TOOLKIT.translate("stabilizers_invalid", new Object[0]).withStyle(ChatFormatting.RED)).setEnabled(() -> !tile.active.get() && !tile.stabilizersValid.get());
        Constraints.size((ConstrainedGeometry)stabInvalidLabel, (double)playInv.container().xSize(), (double)8.0);
        Constraints.placeOutside((ConstrainedGeometry)stabInvalidLabel, (ConstrainedGeometry)coreInvalidLabel, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)5.0);
        GuiText stabAdvLabel = (GuiText)TOOLKIT.createHeading((GuiParent)root, (Component)TOOLKIT.translate("stabilizers_advanced", new Object[0])).setEnabled(() -> !tile.active.get() && !tile.stabilizersValid.get() && tile.reqAdvStabilizers());
        Constraints.size((ConstrainedGeometry)stabAdvLabel, (double)playInv.container().xSize(), (double)8.0);
        Constraints.placeOutside((ConstrainedGeometry)stabAdvLabel, (ConstrainedGeometry)stabInvalidLabel, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)5.0);
        GuiRectangle display = (GuiRectangle)((GuiRectangle)((GuiRectangle)((GuiRectangle)((GuiRectangle)EnergyCoreGui.toolTipBackground(root, -267386864, () -> tile.tier.get() == 8 ? -43776 : -7864065).setEnabled(() -> ((ManagedBool)tile.active).get())).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)playInv.container().get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)playInv.container().get(GeoParam.RIGHT)))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)title.get(GeoParam.BOTTOM), (double)3.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)slotsTitle.get(GeoParam.TOP), (double)-2.0));
        GuiRectangle barSlot = new GuiRectangle((GuiParent)display).shadedRect(() -> BCConfig.darkMode ? -8355712 : -11513776, () -> -1, () -> 0);
        Constraints.size((ConstrainedGeometry)barSlot, (double)(display.xSize() - 6.0), (double)14.0);
        Constraints.placeInside((ConstrainedGeometry)barSlot, (ConstrainedGeometry)display, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)-3.0);
        GuiEnergyBar energyBar = (GuiEnergyBar)new ShaderEnergyBar((GuiParent)display).setCapacity(() -> 1000000L).setEnergy(() -> (long)(this.getEnergyDouble(tile) * 1000000.0)).setTooltipSingle(() -> {
            int p1000 = (int)(this.getEnergyDouble(tile) * 100000.0);
            return Component.translatable((String)"mod_gui.brandonscore.energy_bar.stored").withStyle(ChatFormatting.GOLD).append(": ").append((Component)Component.literal((String)(tile.energy.getScientific() + " (" + (double)p1000 / 1000.0 + "%)")).withStyle(ChatFormatting.GRAY));
        });
        Constraints.bind((ConstrainedGeometry)energyBar, (ConstrainedGeometry)barSlot, (double)1.0);
        GuiText opLabel = new GuiText((GuiParent)display, (Component)Component.translatable((String)"mod_gui.brandonscore.energy_bar.operational_potential").withStyle(ChatFormatting.DARK_AQUA));
        Constraints.size((ConstrainedGeometry)opLabel, (double)display.xSize(), (double)9.0);
        Constraints.placeInside((ConstrainedGeometry)opLabel, (ConstrainedGeometry)display, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_CENTER, (double)0.0, (double)5.0);
        GuiText energy = new GuiText((GuiParent)display).setTextSupplier(() -> Component.literal((String)(tile.energy.getReadable() + (tile.energy.getEnergyStored() < 1000000 ? " " : ""))).append((Component)Component.translatable((String)"mod_gui.brandonscore.energy_bar.op")).withStyle(ChatFormatting.GOLD));
        Constraints.size((ConstrainedGeometry)energy, (double)display.xSize(), (double)9.0);
        Constraints.placeOutside((ConstrainedGeometry)energy, (ConstrainedGeometry)opLabel, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)2.0);
        GuiText capLabel = (GuiText)new GuiText((GuiParent)display, (Component)Component.translatable((String)"mod_gui.brandonscore.energy_bar.capacity").withStyle(ChatFormatting.DARK_AQUA)).setEnabled(() -> !tile.energy.isUnlimited());
        Constraints.size((ConstrainedGeometry)capLabel, (double)display.xSize(), (double)9.0);
        Constraints.placeOutside((ConstrainedGeometry)capLabel, (ConstrainedGeometry)energy, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)3.0);
        GuiText capacity = (GuiText)new GuiText((GuiParent)display).setTextSupplier(() -> Component.literal((String)tile.energy.getReadableCapacity()).append((Component)Component.translatable((String)"mod_gui.brandonscore.energy_bar.op")).withStyle(ChatFormatting.GOLD)).setEnabled(() -> !tile.energy.isUnlimited());
        Constraints.size((ConstrainedGeometry)capacity, (double)display.xSize(), (double)9.0);
        Constraints.placeOutside((ConstrainedGeometry)capacity, (ConstrainedGeometry)capLabel, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)2.0);
        GuiText ioLabel = new GuiText((GuiParent)display, (Component)Component.translatable((String)"mod_gui.brandonscore.energy_bar.io").withStyle(ChatFormatting.DARK_AQUA));
        Constraints.size((ConstrainedGeometry)ioLabel, (double)display.xSize(), (double)9.0);
        Constraints.placeOutside((ConstrainedGeometry)ioLabel, (ConstrainedGeometry)capacity, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)3.0);
        ioLabel.constrain(GeoParam.TOP, (Constraint)Constraint.dynamic(() -> (tile.energy.isUnlimited() ? energy : capacity).yMax() + 3.0));
        GuiText io = new GuiText((GuiParent)display).setTextSupplier(() -> this.genIOText(tile));
        Constraints.size((ConstrainedGeometry)io, (double)display.xSize(), (double)9.0);
        Constraints.placeOutside((ConstrainedGeometry)io, (ConstrainedGeometry)ioLabel, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)2.0);
        GuiTextField.TextField target = GuiTextField.create((GuiElement)display, (int)-265289728, (int)-5723992, (int)14803941);
        target.container().setEnabled(() -> tile.energy.isUnlimited());
        ((GuiTextField)target.field().setSuggestion((Component)TOOLKIT.translate("energy_target", new Object[0])).setMaxLength(64).setTooltipSingle((Component)TOOLKIT.translate("energy_target_info", new Object[0]))).setFilter(s -> EnergyCoreGui.validBigInt(EnergyCoreGui.sanitizeNumStr(s))).setTextState(TextState.simpleState((String)tile.energyTarget.get(), arg_0 -> ((ManagedString)tile.energyTarget).set(arg_0)));
        Constraints.size((ConstrainedGeometry)target.container(), (double)barSlot.xSize(), (double)12.0);
        Constraints.placeOutside((ConstrainedGeometry)target.container(), (ConstrainedGeometry)energyBar, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_CENTER, (double)0.0, (double)-4.0);
        GuiButton legacy = (GuiButton)TOOLKIT.createThemedIconButton((GuiParent)root, 12, BCGuiTextures.getter((String)"legacy")).onPress(() -> ((ManagedBool)tile.legacyRender).invert()).setToggleMode(() -> ((ManagedBool)tile.legacyRender).get()).setTooltipSingle(() -> tile.customColour.get() ? TOOLKIT.translate("legacy_true", new Object[0]) : TOOLKIT.translate("legacy_false", new Object[0]));
        Constraints.placeOutside((ConstrainedGeometry)legacy, (ConstrainedGeometry)display, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_RIGHT, (double)-12.0, (double)0.0);
        GuiButton customColour = (GuiButton)((GuiButton)TOOLKIT.createThemedIconButton((GuiParent)root, 12, BCGuiTextures.getter((String)"rgb_checker")).setEnabled(() -> !legacy.toggleState())).onPress(() -> ((ManagedBool)tile.customColour).invert()).setToggleMode(() -> ((ManagedBool)tile.customColour).get()).setTooltipSingle(() -> tile.customColour.get() ? TOOLKIT.translate("custom_colour_true", new Object[0]) : TOOLKIT.translate("custom_colour_false", new Object[0]));
        Constraints.placeOutside((ConstrainedGeometry)customColour, (ConstrainedGeometry)legacy, (Constraints.LayoutPos)Constraints.LayoutPos.MIDDLE_LEFT, (double)0.0, (double)0.0);
        GuiButton setColour = (GuiButton)((GuiButton)TOOLKIT.createThemedIconButton((GuiParent)root, 12, BCGuiTextures.getter((String)"color_picker")).setEnabled(() -> customColour.toggleState() && !legacy.toggleState())).onPress(() -> this.setColourSelectMode(root, true)).setTooltipSingle(() -> TOOLKIT.translate("config_colour", new Object[0]));
        Constraints.placeOutside((ConstrainedGeometry)setColour, (ConstrainedGeometry)customColour, (Constraints.LayoutPos)Constraints.LayoutPos.MIDDLE_LEFT, (double)0.0, (double)0.0);
        this.setupColourPickers(gui.getDirectRoot(), tile);
    }

    private void setColourSelectMode(GuiElement<?> access, boolean enabled) {
        this.colourSelectMode.set(enabled);
        access.getModularGui().renderScreenBackground(!enabled);
    }

    private void setupColourPickers(GuiElement<?> root, TileEnergyCore tile) {
        GuiColourPicker frameColourDialog = GuiColourPicker.create(root, (ColourState)ColourState.create(() -> ((ManagedInt)tile.frameColour).get(), arg_0 -> ((ManagedInt)tile.frameColour).set(arg_0)), (boolean)false);
        frameColourDialog.constrain(GeoParam.TOP, (Constraint)Constraint.literal((double)0.0));
        frameColourDialog.constrain(GeoParam.LEFT, (Constraint)Constraint.literal((double)0.0));
        frameColourDialog.addMoveHandle((int)frameColourDialog.ySize());
        frameColourDialog.setEnabled(this.colourSelectMode::get);
        frameColourDialog.getCancelButton().setEnabled(false);
        frameColourDialog.getOkButton().onPress(() -> this.setColourSelectMode(root, false));
        GuiColourPicker triangleColourDialog = GuiColourPicker.create(root, (ColourState)ColourState.create(() -> ((ManagedInt)tile.innerColour).get(), arg_0 -> ((ManagedInt)tile.innerColour).set(arg_0)), (boolean)false);
        triangleColourDialog.constrain(GeoParam.TOP, (Constraint)Constraint.literal((double)100.0));
        triangleColourDialog.constrain(GeoParam.LEFT, (Constraint)Constraint.literal((double)0.0));
        triangleColourDialog.addMoveHandle((int)triangleColourDialog.ySize());
        triangleColourDialog.setEnabled(this.colourSelectMode::get);
        triangleColourDialog.getCancelButton().setEnabled(false);
        triangleColourDialog.getOkButton().onPress(() -> this.setColourSelectMode(root, false));
        GuiColourPicker effectColourDialog = GuiColourPicker.create(root, (ColourState)ColourState.create(() -> ((ManagedInt)tile.effectColour).get(), arg_0 -> ((ManagedInt)tile.effectColour).set(arg_0)), (boolean)false);
        effectColourDialog.constrain(GeoParam.TOP, (Constraint)Constraint.literal((double)200.0));
        effectColourDialog.constrain(GeoParam.LEFT, (Constraint)Constraint.literal((double)0.0));
        effectColourDialog.addMoveHandle((int)effectColourDialog.ySize());
        effectColourDialog.setEnabled(this.colourSelectMode::get);
        effectColourDialog.getCancelButton().setEnabled(false);
        effectColourDialog.getOkButton().onPress(() -> this.setColourSelectMode(root, false));
    }

    private double getEnergyDouble(TileEnergyCore tile) {
        if (tile.tier.get() < 8) {
            return (double)tile.energy.getOPStored() / (double)tile.energy.getMaxOPStored();
        }
        if (!EnergyCoreGui.validBigInt(EnergyCoreGui.sanitizeNumStr(tile.energyTarget.get()))) {
            return 0.0;
        }
        BigDecimal target = new BigDecimal(EnergyCoreGui.sanitizeNumStr(tile.energyTarget.get()));
        if (target.compareTo(BigDecimal.ONE) < 0) {
            return 0.0;
        }
        double val = new BigDecimal(tile.energy.getStoredBig()).divide(target, 6, RoundingMode.HALF_EVEN).doubleValue();
        return MathHelper.clip((double)val, (double)0.0, (double)1.0);
    }

    private Component genIOText(TileEnergyCore tile) {
        IOInfo ioInfo = tile.energy.getIOInfo();
        if (ioInfo == null) {
            return Component.literal((String)"[Not Available]");
        }
        String pfx = "mod_gui.brandonscore.energy_bar.";
        if (Screen.hasShiftDown()) {
            return Component.empty().copy().append((Component)Component.literal((String)"+").withStyle(ChatFormatting.GREEN).append(Utils.formatNumber((long)ioInfo.currentInput())).append(" ").append((Component)Component.translatable((String)(pfx + "op"))).append("/t, ")).append((Component)Component.literal((String)"-").withStyle(ChatFormatting.RED).append(Utils.formatNumber((long)ioInfo.currentOutput())).append(" ").append((Component)Component.translatable((String)(pfx + "op"))).append("/t, "));
        }
        long io = ioInfo.currentInput() - ioInfo.currentOutput();
        return Component.empty().copy().append(io > 0L ? "+" : "").append((Component)Component.literal((String)Utils.formatNumber((long)io))).append(" ").append((Component)Component.translatable((String)(pfx + "op"))).append("/t").withStyle(io > 0L ? ChatFormatting.GREEN : (io < 0L ? ChatFormatting.RED : ChatFormatting.GRAY));
    }

    public static boolean validBigInt(String value) {
        try {
            BigDecimal val = new BigDecimal(value);
            return val.compareTo(BigDecimal.ZERO) >= 0 && val.compareTo(MAX_BIGINT) <= 0;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static String sanitizeNumStr(String value) {
        if (((String)value).isEmpty() || ((String)value).toLowerCase(Locale.ENGLISH).endsWith("e")) {
            value = (String)value + "0";
        }
        return value;
    }

    public static GuiRectangle toolTipBackground(@NotNull GuiParent<?> parent, final int backgroundColour, final Supplier<Integer> borderColour) {
        final Supplier<Integer> borderEndColor = () -> ((Integer)borderColour.get() & 0xFEFEFE) >> 1 | (Integer)borderColour.get() & 0xFF000000;
        return new GuiRectangle(parent){

            public void renderBackground(GuiRender render, double mouseX, double mouseY, float partialTicks) {
                render.toolTipBackground(this.xMin(), this.yMin(), this.xSize(), this.ySize(), backgroundColour, backgroundColour, ((Integer)borderColour.get()).intValue(), ((Integer)borderEndColor.get()).intValue(), false);
            }
        };
    }

    public static class Screen
    extends ModularGuiContainer<EnergyCoreMenu> {
        public static AtomicBoolean hideJEI = new AtomicBoolean(false);

        public Screen(EnergyCoreMenu menu, Inventory inv, Component title) {
            super((AbstractContainerMenu)menu, inv, (ContainerGuiProvider)new EnergyCoreGui(hideJEI));
            this.getModularGui().setGuiTitle(title);
        }
    }
}

