/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.datagen;

import com.brandon3055.draconicevolution.blocks.DislocatorReceptacle;
import com.brandon3055.draconicevolution.blocks.Portal;
import com.brandon3055.draconicevolution.blocks.RainSensor;
import com.brandon3055.draconicevolution.blocks.machines.EnergyPylon;
import com.brandon3055.draconicevolution.blocks.machines.Generator;
import com.brandon3055.draconicevolution.blocks.machines.Grinder;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.loaders.CompositeModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockStateGenerator
extends BlockStateProvider {
    private static final Logger LOGGER = LogManager.getLogger();

    public BlockStateGenerator(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "draconicevolution", exFileHelper);
    }

    protected void registerStatesAndModels() {
        Direction[] BY_2D_DATA;
        this.simpleBlock((Supplier<? extends Block>)DEContent.DRACONIUM_BLOCK);
        this.simpleBlock((Supplier<? extends Block>)DEContent.AWAKENED_DRACONIUM_BLOCK, (ModelFile)this.models().cubeBottomTop("awakened_draconium_block", this.modLoc("block/awakened_draconium_block_side"), this.modLoc("block/awakened_draconium_block"), this.modLoc("block/awakened_draconium_block")));
        this.simpleBlock((Supplier<? extends Block>)DEContent.INFUSED_OBSIDIAN);
        this.simpleBlock((Supplier<? extends Block>)DEContent.ENERGY_CORE);
        this.simpleBlock((Supplier<? extends Block>)DEContent.ENERGY_CORE_STABILIZER, (ModelFile)this.models().getExistingFile(this.modLoc("block/energy_core_stabilizer")));
        this.simpleBlock((Supplier<? extends Block>)DEContent.CREATIVE_OP_CAPACITOR);
        this.simpleBlock((Supplier<? extends Block>)DEContent.STABILIZED_SPAWNER, (ModelFile)this.models().getExistingFile(this.modLoc("block/stabilized_spawner")));
        this.simpleBlock((Supplier<? extends Block>)DEContent.PARTICLE_GENERATOR, (ModelFile)this.models().getExistingFile(this.modLoc("block/particle_generator")));
        this.simpleBlock((Supplier<? extends Block>)DEContent.CRAFTING_CORE, (ModelFile)this.models().getExistingFile(this.modLoc("block/crafting/fusion_crafting_core")));
        this.simpleBlock((Supplier<? extends Block>)DEContent.DISLOCATION_INHIBITOR, (ModelFile)this.models().cubeBottomTop("dislocation_inhibitor", this.modLoc("block/dislocation_inhibitor"), this.modLoc("block/parts/machine_top"), this.modLoc("block/parts/machine_top")));
        this.simpleBlock((Supplier<? extends Block>)DEContent.OVERWORLD_DRACONIUM_ORE);
        this.simpleBlock((Supplier<? extends Block>)DEContent.NETHER_DRACONIUM_ORE);
        this.simpleBlock((Supplier<? extends Block>)DEContent.END_DRACONIUM_ORE);
        this.simpleBlock((Supplier<? extends Block>)DEContent.DEEPSLATE_DRACONIUM_ORE);
        this.directionalBlock((Supplier<? extends Block>)DEContent.BASIC_CRAFTING_INJECTOR, (ModelFile)this.models().getExistingFile(this.modLoc("block/crafting/crafting_injector_draconium")));
        this.directionalBlock((Supplier<? extends Block>)DEContent.WYVERN_CRAFTING_INJECTOR, (ModelFile)this.models().getExistingFile(this.modLoc("block/crafting/crafting_injector_wyvern")));
        this.directionalBlock((Supplier<? extends Block>)DEContent.AWAKENED_CRAFTING_INJECTOR, (ModelFile)this.models().getExistingFile(this.modLoc("block/crafting/crafting_injector_draconic")));
        this.directionalBlock((Supplier<? extends Block>)DEContent.CHAOTIC_CRAFTING_INJECTOR, (ModelFile)this.models().getExistingFile(this.modLoc("block/crafting/crafting_injector_chaotic")));
        this.directionalFromNorth((Supplier<? extends Block>)DEContent.FLUID_GATE, (ModelFile)this.models().getExistingFile(this.modLoc("block/fluid_gate")));
        this.directionalFromNorth((Supplier<? extends Block>)DEContent.FLUX_GATE, (ModelFile)this.models().getExistingFile(this.modLoc("block/flux_gate")));
        this.getVariantBuilder((Supplier<? extends Block>)DEContent.RAIN_SENSOR).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile((Boolean)state.getValue((Property)RainSensor.ACTIVE) != false ? this.modLoc("block/rain_sensor_active") : this.modLoc("block/rain_sensor"))).build());
        this.directionalBlock((Supplier<? extends Block>)DEContent.POTENTIOMETER, (ModelFile)this.models().getExistingFile(this.modLoc("block/potentiometer")));
        this.simpleBlock((Supplier<? extends Block>)DEContent.ENERGY_TRANSFUSER, (ModelFile)this.models().getExistingFile(this.modLoc("block/energy_transfuser")));
        this.simpleBlock((Supplier<? extends Block>)DEContent.DISENCHANTER, (ModelFile)this.models().getExistingFile(this.modLoc("block/disenchanter")));
        this.simpleBlock((Supplier<? extends Block>)DEContent.CELESTIAL_MANIPULATOR, (ModelFile)this.models().getExistingFile(this.modLoc("block/celestial_manipulator")));
        this.simpleBlock((Supplier<? extends Block>)DEContent.ENTITY_DETECTOR, (ModelFile)this.models().getExistingFile(this.modLoc("block/entity_detector")));
        this.simpleBlock((Supplier<? extends Block>)DEContent.ENTITY_DETECTOR_ADVANCED, (ModelFile)this.models().getExistingFile(this.modLoc("block/entity_detector_advanced")));
        this.dummyBlock((Supplier<? extends Block>)DEContent.BASIC_IO_CRYSTAL);
        this.dummyBlock((Supplier<? extends Block>)DEContent.WYVERN_IO_CRYSTAL);
        this.dummyBlock((Supplier<? extends Block>)DEContent.DRACONIC_IO_CRYSTAL);
        this.dummyBlock((Supplier<? extends Block>)DEContent.BASIC_RELAY_CRYSTAL);
        this.dummyBlock((Supplier<? extends Block>)DEContent.WYVERN_RELAY_CRYSTAL);
        this.dummyBlock((Supplier<? extends Block>)DEContent.DRACONIC_RELAY_CRYSTAL);
        this.dummyBlock((Supplier<? extends Block>)DEContent.BASIC_WIRELESS_CRYSTAL);
        this.dummyBlock((Supplier<? extends Block>)DEContent.WYVERN_WIRELESS_CRYSTAL);
        this.dummyBlock((Supplier<? extends Block>)DEContent.DRACONIC_WIRELESS_CRYSTAL);
        this.dummyBlock((Supplier<? extends Block>)DEContent.STRUCTURE_BLOCK);
        this.dummyBlock((Supplier<? extends Block>)DEContent.CHAOS_CRYSTAL);
        this.dummyBlock((Supplier<? extends Block>)DEContent.PLACED_ITEM);
        this.dummyBlock((Supplier<? extends Block>)DEContent.CHAOS_CRYSTAL_PART);
        this.dummyBlock((Supplier<? extends Block>)DEContent.COMET_SPAWNER);
        this.dummyBlock((Supplier<? extends Block>)DEContent.DRACONIUM_CHEST);
        this.dummyBlock((Supplier<? extends Block>)DEContent.REACTOR_CORE);
        this.dummyBlock((Supplier<? extends Block>)DEContent.REACTOR_STABILIZER);
        this.dummyBlock((Supplier<? extends Block>)DEContent.REACTOR_INJECTOR);
        VariantBlockStateBuilder pylonBuilder = this.getVariantBuilder((Supplier<? extends Block>)DEContent.ENERGY_PYLON);
        for (EnergyPylon.Mode mode : EnergyPylon.Mode.values()) {
            String io = mode == EnergyPylon.Mode.OUTPUT ? "output" : "input";
            ModelBuilder model = this.models().cubeBottomTop("energy_pylon_" + io, this.modLoc("block/energy_pylon/energy_pylon_" + io), this.modLoc("block/energy_pylon/energy_pylon_" + io), this.modLoc("block/energy_pylon/energy_pylon_active_face"));
            for (Direction dir : Direction.values()) {
                pylonBuilder.partialState().with((Property)EnergyPylon.FACING, (Comparable)dir).with(EnergyPylon.MODE, (Comparable)((Object)mode)).modelForState().modelFile((ModelFile)model).rotationY(dir.getAxis() == Direction.Axis.Y ? 0 : 180 + 90 * dir.get2DDataValue()).rotationX(dir == Direction.UP ? 0 : (dir == Direction.DOWN ? 180 : 90)).addModel();
            }
        }
        this.simpleBlock((Supplier<? extends Block>)DEContent.DISLOCATOR_PEDESTAL, (ModelFile)this.models().getExistingFile(this.modLoc("block/dislocator_pedestal")));
        VariantBlockStateBuilder receptacleBuilder = this.getVariantBuilder((Supplier<? extends Block>)DEContent.DISLOCATOR_RECEPTACLE);
        receptacleBuilder.addModels(receptacleBuilder.partialState().with((Property)DislocatorReceptacle.CAMO, (Comparable)Boolean.valueOf(true)), ConfiguredModel.builder().modelFile((ModelFile)this.models().cubeAll("infused_obsidian", this.modLoc("block/infused_obsidian"))).build());
        receptacleBuilder.addModels(receptacleBuilder.partialState().with((Property)DislocatorReceptacle.ACTIVE, (Comparable)Boolean.valueOf(false)).with((Property)DislocatorReceptacle.CAMO, (Comparable)Boolean.valueOf(false)), ConfiguredModel.builder().modelFile((ModelFile)this.models().cubeAll("dislocator_receptacle_inactive", this.modLoc("block/dislocator_receptacle_inactive"))).build());
        receptacleBuilder.addModels(receptacleBuilder.partialState().with((Property)DislocatorReceptacle.ACTIVE, (Comparable)Boolean.valueOf(true)).with((Property)DislocatorReceptacle.CAMO, (Comparable)Boolean.valueOf(false)), ConfiguredModel.builder().modelFile((ModelFile)this.models().cubeAll("dislocator_receptacle_active", this.modLoc("block/dislocator_receptacle_active"))).build());
        ModelFile.ExistingModelFile portalModel = this.models().getExistingFile(this.modLoc("block/portal/portal"));
        ModelFile.ExistingModelFile portalWallX = this.models().getExistingFile(this.modLoc("block/portal/portal_wall_x"));
        ModelFile.ExistingModelFile portalWallY = this.models().getExistingFile(this.modLoc("block/portal/portal_wall_y"));
        ModelFile.ExistingModelFile portalWallZ = this.models().getExistingFile(this.modLoc("block/portal/portal_wall_z"));
        MultiPartBlockStateBuilder portalBuilder = this.getMultipartBuilder((Supplier<? extends Block>)DEContent.PORTAL);
        for (Direction.Axis axis : Direction.Axis.values()) {
            ModelFile.ExistingModelFile wallWestEast = axis == Direction.Axis.Z ? portalWallX : (axis == Direction.Axis.Y ? portalWallY : portalWallZ);
            ModelFile.ExistingModelFile wallUpDown = axis == Direction.Axis.Z || axis == Direction.Axis.Y ? portalWallY : portalWallZ;
            ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)portalBuilder.part().modelFile((ModelFile)portalModel).rotationX(axis != Direction.Axis.Y ? 90 : 0).rotationY(axis == Direction.Axis.X ? 90 : 0).addModel()).condition((Property)Portal.VISIBLE, (Comparable[])new Boolean[]{true}).condition(Portal.AXIS, (Comparable[])new Direction.Axis[]{axis}).end().part().modelFile((ModelFile)wallUpDown).rotationX(axis == Direction.Axis.X || axis == Direction.Axis.Z ? -90 : 0).addModel()).condition((Property)Portal.DRAW_UP, (Comparable[])new Boolean[]{true}).condition(Portal.AXIS, (Comparable[])new Direction.Axis[]{axis}).end().part().modelFile((ModelFile)wallUpDown).rotationX(axis == Direction.Axis.X || axis == Direction.Axis.Z ? 90 : 0).rotationY(axis == Direction.Axis.Y ? 180 : 0).addModel()).condition((Property)Portal.DRAW_DOWN, (Comparable[])new Boolean[]{true}).condition(Portal.AXIS, (Comparable[])new Direction.Axis[]{axis}).end().part().modelFile((ModelFile)wallWestEast).rotationY(axis == Direction.Axis.Z ? 180 : (axis == Direction.Axis.Y ? -90 : 0)).addModel()).condition((Property)Portal.DRAW_WEST, (Comparable[])new Boolean[]{true}).condition(Portal.AXIS, (Comparable[])new Direction.Axis[]{axis}).end().part().modelFile((ModelFile)wallWestEast).rotationY(axis == Direction.Axis.Y ? 90 : 0).rotationX(axis == Direction.Axis.X ? 180 : 0).addModel()).condition((Property)Portal.DRAW_EAST, (Comparable[])new Boolean[]{true}).condition(Portal.AXIS, (Comparable[])new Direction.Axis[]{axis}).end();
        }
        ModelFile.ExistingModelFile modelGenerator = this.models().getExistingFile(this.modLoc("block/generator/generator"));
        ModelFile.ExistingModelFile modelGeneratorFlame = this.models().getExistingFile(this.modLoc("block/generator/generator_flame"));
        MultiPartBlockStateBuilder generatorBuilder = this.getMultipartBuilder((Supplier<? extends Block>)DEContent.GENERATOR);
        for (Direction dir : FenceGateBlock.FACING.getPossibleValues()) {
            int angle = (int)dir.getOpposite().toYRot();
            ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)generatorBuilder.part().modelFile((ModelFile)modelGenerator).rotationY(angle).addModel()).condition((Property)Generator.FACING, (Comparable[])new Direction[]{dir}).end().part().modelFile((ModelFile)modelGeneratorFlame).rotationY(angle).addModel()).condition((Property)Generator.FACING, (Comparable[])new Direction[]{dir}).condition((Property)Generator.ACTIVE, (Comparable[])new Boolean[]{true}).end();
        }
        ModelFile.ExistingModelFile modelGrinder = this.models().getExistingFile(this.modLoc("block/grinder/grinder"));
        ModelFile.ExistingModelFile modelGrinderActive = this.models().getExistingFile(this.modLoc("block/grinder/grinder_eyes"));
        MultiPartBlockStateBuilder grinderBuilder = this.getMultipartBuilder((Supplier<? extends Block>)DEContent.GRINDER);
        for (Direction dir : BY_2D_DATA = (Direction[])Arrays.stream(Direction.values()).filter(p_235685_ -> p_235685_.getAxis().isHorizontal()).sorted(Comparator.comparingInt(Direction::get2DDataValue)).toArray(Direction[]::new)) {
            int angle = (int)dir.getOpposite().toYRot();
            ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)grinderBuilder.part().modelFile((ModelFile)modelGrinder).rotationY(angle).addModel()).condition((Property)Grinder.FACING, (Comparable[])new Direction[]{dir}).end().part().modelFile((ModelFile)modelGrinderActive).rotationY(angle).addModel()).condition((Property)Grinder.FACING, (Comparable[])new Direction[]{dir}).condition((Property)Grinder.ACTIVE, (Comparable[])new Boolean[]{true}).end();
        }
    }

    private void dummyBlock(Supplier<? extends Block> block) {
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent("dummy", "block")).texture("particle", "minecraft:block/glass");
        this.simpleBlock(block.get(), (ModelFile)model);
    }

    public void directionalFromNorth(Supplier<? extends Block> block, ModelFile model) {
        this.directionalFromNorth(block, model, 180);
    }

    public void directionalFromNorth(Supplier<? extends Block> block, ModelFile model, int angleOffset) {
        this.directionalFromNorth(block, (BlockState $) -> model, angleOffset);
    }

    public void directionalFromNorth(Supplier<? extends Block> block, Function<BlockState, ModelFile> modelFunc) {
        this.directionalFromNorth(block, modelFunc, 180);
    }

    public void directionalFromNorth(Supplier<? extends Block> block, Function<BlockState, ModelFile> modelFunc, int angleOffset) {
        this.getVariantBuilder(block.get()).forAllStates(state -> {
            Direction dir = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(dir == Direction.DOWN ? 90 : (dir == Direction.UP ? -90 : 0)).rotationY(dir.getAxis().isVertical() ? 0 : ((int)dir.toYRot() + angleOffset) % 360).build();
        });
    }

    public void multiLayerBlock(Supplier<? extends Block> block, ResourceLocation solid, ResourceLocation overlay) {
        this.simpleBlock(block, (ModelFile)((CompositeModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(BuiltInRegistries.BLOCK.getKey((Object)block.get()).getPath())).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/block")))).texture("particle", solid)).customLoader(CompositeModelBuilder::begin)).child("base", (ModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/cube_all")))).renderType("solid")).texture("all", solid))).child("overlay", (ModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/cube_all")))).renderType("cutout_mipped")).texture("all", overlay))).end());
    }

    public MultiPartBlockStateBuilder getMultipartBuilder(Supplier<? extends Block> b) {
        return super.getMultipartBuilder(b.get());
    }

    public void simpleBlock(Supplier<? extends Block> block, ModelFile model) {
        super.simpleBlock(block.get(), model);
    }

    public VariantBlockStateBuilder getVariantBuilder(Supplier<? extends Block> b) {
        return super.getVariantBuilder(b.get());
    }

    public void directionalBlock(Supplier<? extends Block> block, ModelFile model) {
        super.directionalBlock(block.get(), model);
    }

    public void simpleBlock(Supplier<? extends Block> block) {
        super.simpleBlock(block.get());
    }

    public String getName() {
        return "Draconic Evolution Blockstates";
    }
}

