/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.handlers;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.jetbrains.annotations.Nullable;

public class EntityAttributeHandler<Data> {
    private final Map<ResourceLocation, AttribData> modifiers = new HashMap<ResourceLocation, AttribData>();

    public void register(ResourceLocation attribKey, Supplier<Holder<Attribute>> attribute, BiFunction<LivingEntity, Data, @Nullable AttributeModifier> modifierFunc) {
        this.modifiers.put(attribKey, new AttribData(attribute, (BiFunction)SneakyUtils.unsafeCast(modifierFunc)));
    }

    public void updateEntity(LivingEntity entity, Data extraData) {
        this.modifiers.forEach((uuid, data) -> {
            AttributeModifier newMod = data.modifierFunc.apply(entity, extraData);
            AttributeInstance attribute = entity.getAttribute(data.attribute.get());
            if (attribute == null) {
                return;
            }
            attribute.removeModifier(uuid);
            if (newMod != null) {
                attribute.addTransientModifier(newMod);
            }
        });
    }

    private record AttribData(Supplier<Holder<Attribute>> attribute, BiFunction<LivingEntity, Object, @Nullable AttributeModifier> modifierFunc) {
    }
}

