/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.integration.jei;

import codechicken.lib.inventory.InventoryUtils;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.api.crafting.IFusionInjector;
import com.brandon3055.draconicevolution.api.crafting.IFusionInventory;
import com.brandon3055.draconicevolution.api.crafting.IFusionRecipe;
import com.brandon3055.draconicevolution.api.crafting.StackIngredient;
import com.brandon3055.draconicevolution.blocks.tileentity.TileFusionCraftingCore;
import com.brandon3055.draconicevolution.integration.jei.DEJEIPlugin;
import com.brandon3055.draconicevolution.inventory.FusionCraftingCoreMenu;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FusionRecipeTransferHelper
implements IRecipeTransferHandler<FusionCraftingCoreMenu, RecipeHolder<IFusionRecipe>> {
    private final IStackHelper stackHelper;
    private final IRecipeTransferHandlerHelper handlerHelper;

    public FusionRecipeTransferHelper(IStackHelper stackHelper, IRecipeTransferHandlerHelper handlerHelper) {
        this.stackHelper = stackHelper;
        this.handlerHelper = handlerHelper;
    }

    @NotNull
    public Class<FusionCraftingCoreMenu> getContainerClass() {
        return FusionCraftingCoreMenu.class;
    }

    public Optional<MenuType<FusionCraftingCoreMenu>> getMenuType() {
        return Optional.empty();
    }

    public RecipeType<RecipeHolder<IFusionRecipe>> getRecipeType() {
        return DEJEIPlugin.getFusionRecipeType();
    }

    @Nullable
    public IRecipeTransferError transferRecipe(@NotNull FusionCraftingCoreMenu container, @NotNull RecipeHolder<IFusionRecipe> recipe, @NotNull IRecipeSlotsView recipeSlots, @NotNull Player player, boolean maxTransfer, boolean doTransfer) {
        TileFusionCraftingCore core = (TileFusionCraftingCore)container.tile;
        core.updateInjectors();
        int validInjectors = (int)core.getInjectors().stream().filter(e -> e.getInjectorTier().index >= ((IFusionRecipe)recipe.value()).getRecipeTier().index).count();
        if (validInjectors < ((IFusionRecipe)recipe.value()).fusionIngredients().size()) {
            return this.handlerHelper.createUserErrorWithTooltip((Component)Component.translatable((String)"gui.draconicevolution.fusion_craft.ne_tier_injectors", (Object[])new Object[]{((IFusionRecipe)recipe.value()).getRecipeTier().getDisplayName().getString()}));
        }
        HashMap<Integer, Slot> inventorySlots = new HashMap<Integer, Slot>();
        for (Slot slot : container.slots) {
            if (slot.index >= 36) continue;
            inventorySlots.put(slot.index, slot);
        }
        List coreStacks = core.getInjectors().stream().map(IFusionInjector::getInjectorStack).collect(Collectors.toList());
        coreStacks.add(core.getCatalystStack());
        coreStacks.add(core.getOutputStack());
        int inputCount = 0;
        List slotViews = recipeSlots.getSlotViews();
        for (IRecipeSlotView view : slotViews) {
            if (view.getRole() != RecipeIngredientRole.INPUT || view.isEmpty()) continue;
            ++inputCount;
        }
        HashMap<Integer, ItemStack> availableItemStacks = new HashMap<Integer, ItemStack>();
        int filledCraftSlotCount = 0;
        int emptySlotCount = 0;
        for (Object slot : inventorySlots.values()) {
            ItemStack stack = slot.getItem();
            if (!stack.isEmpty()) {
                availableItemStacks.put(((Slot)slot).index, stack.copy());
                continue;
            }
            ++emptySlotCount;
        }
        int lastIndex = 36;
        for (ItemStack stack : coreStacks) {
            if (stack.isEmpty()) continue;
            ++filledCraftSlotCount;
            availableItemStacks.put(lastIndex++, stack.copy());
        }
        if (filledCraftSlotCount - inputCount > emptySlotCount) {
            String message = I18n.get((String)"jei.tooltip.error.recipe.transfer.inventory.full", (Object[])new Object[0]);
            return this.handlerHelper.createUserErrorWithTooltip((Component)Component.literal((String)message));
        }
        List<IRecipeSlotView> missingStacks = this.checkForMissingIngredients(this.stackHelper, availableItemStacks, slotViews);
        if (missingStacks.size() > 0) {
            String message = I18n.get((String)"jei.tooltip.error.recipe.transfer.missing", (Object[])new Object[0]);
            return this.handlerHelper.createUserErrorForMissingSlots((Component)Component.literal((String)message), missingStacks);
        }
        if (doTransfer) {
            DraconicNetwork.sendFusionRecipeMove(player.registryAccess(), recipe, maxTransfer);
        }
        return null;
    }

    private List<IRecipeSlotView> checkForMissingIngredients(IStackHelper stackhelper, Map<Integer, ItemStack> availableItemStacks, List<IRecipeSlotView> slotViews) {
        ArrayList<IRecipeSlotView> missing = new ArrayList<IRecipeSlotView>();
        for (IRecipeSlotView slotView : slotViews) {
            List<ItemStack> requiredStacks;
            if (slotView.isEmpty() || slotView.getRole() != RecipeIngredientRole.INPUT || (requiredStacks = slotView.getAllIngredients().map(e -> e.getIngredient((IIngredientType)VanillaTypes.ITEM_STACK).orElse(ItemStack.EMPTY)).filter(e -> !e.isEmpty()).toList()).isEmpty()) continue;
            boolean foundIngredient = false;
            for (ItemStack stack : requiredStacks) {
                int required = stack.getCount();
                for (ItemStack available : availableItemStacks.values()) {
                    if (!stackhelper.isEquivalent(available, stack, UidContext.Ingredient)) continue;
                    int consume = Math.min(required, available.getCount());
                    available.shrink(consume);
                    if ((required -= consume) > 0) continue;
                    foundIngredient = true;
                    break;
                }
                availableItemStacks.entrySet().removeIf(e -> ((ItemStack)e.getValue()).getCount() <= 0);
                if (!foundIngredient) continue;
                break;
            }
            if (foundIngredient) continue;
            missing.add(slotView);
        }
        return missing;
    }

    public static void doServerSideTransfer(ServerPlayer player, FusionCraftingCoreMenu container, IFusionRecipe recipe, boolean maxTransfer) {
        TileFusionCraftingCore tile = (TileFusionCraftingCore)container.tile;
        IItemHandler playerItemHandler = (IItemHandler)player.getCapability(Capabilities.ItemHandler.ENTITY);
        if (playerItemHandler == null) {
            DraconicEvolution.LOGGER.error("FusionRecipeTransferHelper: Player has no inventory capability");
            return;
        }
        for (int i = 0; i < tile.itemHandler.getSlots(); ++i) {
            ItemStack stack = tile.itemHandler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            stack = InventoryUtils.insertItem((IItemHandler)playerItemHandler, (ItemStack)stack, (boolean)false);
            tile.itemHandler.setStackInSlot(i, stack);
            if (stack.isEmpty()) continue;
            DraconicEvolution.LOGGER.error("FusionRecipeTransferHelper: Failed to transfer core inventory to player.");
            return;
        }
        for (IFusionInjector injector : tile.getInjectors()) {
            ItemStack stack = injector.getInjectorStack();
            if (stack.isEmpty()) continue;
            stack = InventoryUtils.insertItem((IItemHandler)playerItemHandler, (ItemStack)stack, (boolean)false);
            injector.setInjectorStack(stack);
            if (stack.isEmpty()) continue;
            DraconicEvolution.LOGGER.error("FusionRecipeTransferHelper: Failed to transfer core inventory to player.");
            return;
        }
        FusionRecipeTransferHelper.transferIngredients(playerItemHandler, tile, recipe, maxTransfer);
    }

    private static void transferIngredients(IItemHandler playerInv, IFusionInventory fusionInv, IFusionRecipe recipe, boolean maxTransfer) {
        int n;
        ICustomIngredient iCustomIngredient;
        int fullSets;
        ArrayList<ItemStack> availableStacks = new ArrayList<ItemStack>();
        for (int i = 0; i < playerInv.getSlots(); ++i) {
            availableStacks.add(playerInv.getStackInSlot(i).copy());
        }
        for (fullSets = 0; (maxTransfer || fullSets == 0) && FusionRecipeTransferHelper.checkIngredient(availableStacks, recipe.getCatalyst(), true); ++fullSets) {
            boolean endCheck = false;
            for (IFusionRecipe.IFusionIngredient iFusionIngredient : recipe.fusionIngredients()) {
                if (FusionRecipeTransferHelper.checkIngredient(availableStacks, iFusionIngredient.get(), iFusionIngredient.consume())) continue;
                endCheck = true;
                break;
            }
            if (endCheck) break;
        }
        if ((iCustomIngredient = recipe.getCatalyst().getCustomIngredient()) instanceof StackIngredient) {
            StackIngredient stackIngredient = (StackIngredient)iCustomIngredient;
            n = stackIngredient.getCount();
        } else {
            n = 1;
        }
        int catCount = n;
        int maxStack = recipe.getCatalyst().getItems().length > 0 ? recipe.getCatalyst().getItems()[0].getMaxStackSize() : 1;
        fullSets = Math.min(fullSets, maxStack / catCount);
        List<Object> list = fusionInv.getInjectors().stream().sorted(Comparator.comparing(e -> ((IFusionInjector)e).getInjectorTier().index).reversed()).toList();
        List<IFusionRecipe.IFusionIngredient> ingredients = recipe.fusionIngredients();
        if (list.size() < ingredients.size()) {
            DraconicEvolution.LOGGER.error("FusionRecipeTransferHelper: Unexpected error while transferring recipe");
            return;
        }
        for (int i = 0; i < fullSets; ++i) {
            ItemStack catalyst = FusionRecipeTransferHelper.getIngredient(fusionInv.getCatalystStack(), recipe.getCatalyst(), playerInv);
            fusionInv.setCatalystStack(catalyst);
            for (int fi = 0; fi < ingredients.size(); ++fi) {
                IFusionInjector injector = (IFusionInjector)list.get(fi);
                IFusionRecipe.IFusionIngredient ingredient = ingredients.get(fi);
                if (!ingredient.consume() && i > 0) continue;
                ItemStack stack = FusionRecipeTransferHelper.getIngredient(injector.getInjectorStack(), ingredient.get(), playerInv);
                injector.setInjectorStack(stack);
            }
        }
    }

    private static ItemStack getIngredient(ItemStack existing, Ingredient ingred, IItemHandler playerInv) {
        int n;
        ICustomIngredient custom = ingred.getCustomIngredient();
        if (custom instanceof StackIngredient) {
            StackIngredient stackIngredient = (StackIngredient)custom;
            n = stackIngredient.getCount();
        } else {
            n = 1;
        }
        int count = n;
        for (int i = 0; i < playerInv.getSlots(); ++i) {
            ItemStack slot = playerInv.extractItem(i, count, true);
            if (!ingred.test(slot) || !InventoryUtils.canStack((ItemStack)existing, (ItemStack)slot)) continue;
            int maxInsert = existing.isEmpty() ? count : Math.min(count, existing.getMaxStackSize() - existing.getCount());
            ItemStack extracted = playerInv.extractItem(i, maxInsert, false);
            if (existing.isEmpty()) {
                existing = extracted;
            } else {
                existing.grow(extracted.getCount());
            }
            if ((count -= extracted.getCount()) > 0) continue;
            return existing;
        }
        return existing;
    }

    private static boolean checkIngredient(List<ItemStack> availableStacks, Ingredient ingred, boolean consume) {
        int n;
        ICustomIngredient custom = ingred.getCustomIngredient();
        if (custom instanceof StackIngredient) {
            StackIngredient stackIngredient = (StackIngredient)custom;
            n = stackIngredient.getCount();
        } else {
            n = 1;
        }
        int count = n;
        for (ItemStack stack : availableStacks) {
            if (!ingred.test(stack)) continue;
            int stackSize = stack.getCount();
            if (consume) {
                stack.shrink(Math.min(count, stack.getCount()));
            }
            if ((count -= stackSize) > 0) continue;
            availableStacks.removeIf(ItemStack::isEmpty);
            return true;
        }
        availableStacks.removeIf(ItemStack::isEmpty);
        return false;
    }
}

