/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.inventory;

import codechicken.lib.util.ArrayUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class InventoryCache
implements Container {
    private ItemStack[] inventoryStacks;

    public InventoryCache(int inventorySize) {
        this.inventoryStacks = new ItemStack[inventorySize];
    }

    public int getContainerSize() {
        return this.inventoryStacks.length;
    }

    public boolean isEmpty() {
        return ArrayUtils.isEmpty((Object[])this.inventoryStacks);
    }

    @Nonnull
    public ItemStack getItem(int index) {
        return this.inventoryStacks[index] == null ? ItemStack.EMPTY : this.inventoryStacks[index];
    }

    @Nullable
    public ItemStack removeItem(int index, int count) {
        ItemStack itemstack = this.getItem(index);
        if (!itemstack.isEmpty()) {
            if (itemstack.getCount() <= count) {
                this.setItem(index, ItemStack.EMPTY);
            } else if ((itemstack = itemstack.split(count)).getCount() == 0) {
                this.setItem(index, ItemStack.EMPTY);
            }
        }
        return itemstack;
    }

    @Nullable
    public ItemStack removeItemNoUpdate(int index) {
        ItemStack item = this.getItem(index);
        if (!item.isEmpty()) {
            this.setItem(index, ItemStack.EMPTY);
        }
        return item;
    }

    public void setItem(int index, @Nonnull ItemStack stack) {
        if (index < 0 || index >= this.inventoryStacks.length) {
            return;
        }
        this.inventoryStacks[index] = stack;
        if (!stack.isEmpty() && stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
    }

    public int getMaxStackSize() {
        return 64;
    }

    public void setChanged() {
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void startOpen(Player player) {
    }

    public void stopOpen(Player player) {
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return false;
    }

    public void clearContent() {
        for (int i = 0; i < this.inventoryStacks.length; ++i) {
            this.inventoryStacks[i] = ItemStack.EMPTY;
        }
    }
}

