/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.config.BooleanProperty;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.config.DecimalProperty;
import com.brandon3055.draconicevolution.api.config.IntegerProperty;
import com.brandon3055.draconicevolution.api.crafting.IFusionDataTransfer;
import com.brandon3055.draconicevolution.api.event.ModularItemInitEvent;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.AOEData;
import com.brandon3055.draconicevolution.api.modules.data.SpeedData;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostImpl;
import com.brandon3055.draconicevolution.api.modules.lib.StackModuleContext;
import com.brandon3055.draconicevolution.client.keybinding.KeyBindings;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.init.ItemData;
import com.brandon3055.draconicevolution.items.equipment.IModularArmor;
import com.brandon3055.draconicevolution.items.equipment.IModularEnergyItem;
import com.brandon3055.draconicevolution.items.equipment.IModularMelee;
import com.brandon3055.draconicevolution.items.equipment.IModularMiningTool;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.extensions.IItemExtension;
import org.jetbrains.annotations.NotNull;

public interface IModularItem
extends IItemExtension,
IFusionDataTransfer {
    public TechLevel getTechLevel();

    default public ModuleHostImpl createHostCapForRegistration(ItemStack stack) {
        ModuleHostImpl host = this.instantiateHost(stack);
        if (this instanceof IModularEnergyItem) {
            host.addCategories(ModuleCategory.ENERGY);
        }
        if (this instanceof IModularMiningTool) {
            host.addCategories(ModuleCategory.MINING_TOOL);
            host.addPropertyBuilder(props -> {
                props.add(new DecimalProperty("mining_speed", 1.0).range(0.0, 1.0).setFormatter(ConfigProperty.DecimalFormatter.PERCENT_1));
                AOEData aoe = host.getModuleData(ModuleTypes.AOE);
                if (aoe != null) {
                    props.add(new IntegerProperty("mining_aoe", aoe.aoe()).range(0, aoe.aoe()).setFormatter(ConfigProperty.IntegerFormatter.AOE));
                    props.add(new BooleanProperty("aoe_safe", false).setFormatter(ConfigProperty.BooleanFormatter.ENABLED_DISABLED));
                }
            });
        }
        if (this instanceof IModularMelee) {
            host.addCategories(ModuleCategory.MELEE_WEAPON);
            host.addPropertyBuilder(props -> {
                AOEData aoe = host.getModuleData(ModuleTypes.AOE);
                if (aoe != null) {
                    props.add(new DecimalProperty("attack_aoe", (double)aoe.aoe() * 1.5).range(0.0, (double)aoe.aoe() * 1.5).setFormatter(ConfigProperty.DecimalFormatter.AOE_1));
                }
            });
        }
        NeoForge.EVENT_BUS.post((Event)new ModularItemInitEvent(stack, host, host));
        return host;
    }

    @NotNull
    public ModuleHostImpl instantiateHost(ItemStack var1);

    @NotNull
    public ModularOPStorage instantiateOPStorage(ItemStack var1, Supplier<ModuleHost> var2);

    @OnlyIn(value=Dist.CLIENT)
    default public void addModularItemInformation(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        ModuleHost host;
        if (!Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"[Modular Item]").withStyle(ChatFormatting.BLUE));
        }
        if ((host = DECapabilities.getHost(stack)) != null) {
            host.getModuleEntities().forEach(e -> e.addHostHoverText(stack, context, tooltip, flagIn));
            host.getInstalledTypes().map(host::getModuleData).filter(Objects::nonNull).forEach(data -> data.addHostHoverText(stack, context.level(), tooltip, flagIn));
        }
        EnergyUtils.addEnergyInfo((ItemStack)stack, tooltip);
        if (EnergyUtils.isEnergyItem((ItemStack)stack) && EnergyUtils.getMaxEnergyStored((ItemStack)stack) == 0L) {
            tooltip.add((Component)Component.translatable((String)"modular_item.draconicevolution.requires_energy").withStyle(ChatFormatting.RED));
            if (KeyBindings.toolModules != null && KeyBindings.toolModules.getTranslatedKeyMessage() != null) {
                tooltip.add((Component)Component.translatable((String)"modular_item.draconicevolution.requires_energy_press", (Object[])new Object[]{KeyBindings.toolModules.getTranslatedKeyMessage().getString()}).withStyle(ChatFormatting.BLUE));
            }
        }
    }

    default public void handleTick(ModuleHost host, ItemStack stack, LivingEntity entity, @Nullable EquipmentSlot slot, boolean inEquipModSlot) {
        host.handleTick(new StackModuleContext(stack, entity, slot).setInEquipModSlot(inEquipModSlot));
        if (!(this instanceof IModularMiningTool)) {
            return;
        }
        SpeedData data = host.getModuleData(ModuleTypes.SPEED);
        float moduleValue = data == null ? 0.0f : (float)data.speedMultiplier();
        float multiplier = MathHelper.map((float)((moduleValue + 1.0f) * (moduleValue + 1.0f)), (float)1.0f, (float)2.0f, (float)1.0f, (float)1.65f);
        float speedSetting = 1.0f;
        if (host instanceof PropertyProvider && host.hasDecimal("mining_speed")) {
            speedSetting = (float)host.getDecimal("mining_speed").getValue();
            speedSetting *= speedSetting;
        }
        float aoeSetting = host.getModuleData(ModuleTypes.AOE, new AOEData(0)).aoe();
        if (host instanceof PropertyProvider && host.hasInt("mining_aoe")) {
            aoeSetting = host.getInt("mining_aoe").getValue();
        }
        if (this.getEnergyStored(stack) < (long)EquipCfg.energyHarvest) {
            multiplier = 0.0f;
        } else if (aoeSetting > 0.0f) {
            float userTarget = multiplier * speedSetting;
            multiplier = Math.min(userTarget, multiplier / (1.0f + aoeSetting * 10.0f));
        } else {
            multiplier *= speedSetting;
        }
        stack.set(ItemData.DESTROY_SPEED_DATA, (Object)new DestroySpeedData(multiplier, speedSetting, aoeSetting));
    }

    default public boolean isEquipped(ItemStack stack, @Nullable EquipmentSlot slot, boolean inEquipSlot) {
        if (this instanceof IModularArmor) {
            return slot != null && slot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR || inEquipSlot;
        }
        return true;
    }

    default public float getDestroySpeed(ItemStack stack, BlockState state) {
        DestroySpeedData data = (DestroySpeedData)stack.get(ItemData.DESTROY_SPEED_DATA);
        if (data == null) {
            return 0.0f;
        }
        if (IModularItem.isCorrectToolForDrops(stack, state) && (data.multiplier > 0.0f || data.speedSetting == 0.0f)) {
            return this.getBaseEfficiency() * data.multiplier;
        }
        return data.speedSetting == 0.0f ? 0.0f : 1.0f;
    }

    public static boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        Tool tool = (Tool)stack.get(DataComponents.TOOL);
        return tool != null && tool.isCorrectForDrops(state);
    }

    default public float getBaseEfficiency() {
        return 1.0f;
    }

    default public long getEnergyStored(ItemStack stack) {
        return EnergyUtils.getEnergyStored((ItemStack)stack);
    }

    default public long extractEnergy(Player player, ItemStack stack, long amount) {
        if (player != null && player.getAbilities().instabuild) {
            return amount;
        }
        IOPStorage storage = EnergyUtils.getStorage((ItemStack)stack);
        if (storage != null) {
            return storage.modifyEnergyStored(-amount);
        }
        return 0L;
    }

    default public boolean damageBarVisible(ItemStack stack) {
        long max = EnergyUtils.getMaxEnergyStored((ItemStack)stack);
        return max > 0L && EnergyUtils.getEnergyStored((ItemStack)stack) < max;
    }

    default public int damageBarWidth(ItemStack stack) {
        float charge = (float)EnergyUtils.getEnergyStored((ItemStack)stack) / (float)EnergyUtils.getMaxEnergyStored((ItemStack)stack);
        return Math.round(13.0f * charge);
    }

    default public int damageBarColour(ItemStack stack) {
        float maxEnergy = EnergyUtils.getMaxEnergyStored((ItemStack)stack);
        float energy = EnergyUtils.getEnergyStored((ItemStack)stack);
        float f = Math.max(0.0f, energy / maxEnergy);
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    default public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.getItem() != newStack.getItem() || slotChanged;
    }

    public record DestroySpeedData(float multiplier, float speedSetting, float aoeSetting) {
        public static final Codec<DestroySpeedData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("multiplier").forGetter(DestroySpeedData::multiplier), (App)Codec.FLOAT.fieldOf("speedSetting").forGetter(DestroySpeedData::speedSetting), (App)Codec.FLOAT.fieldOf("aoeSetting").forGetter(DestroySpeedData::aoeSetting)).apply((Applicative)instance, DestroySpeedData::new));
    }
}

