/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.DamageData;
import com.brandon3055.draconicevolution.api.modules.data.SpeedData;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.init.ItemData;
import com.brandon3055.draconicevolution.items.equipment.DETier;
import com.brandon3055.draconicevolution.items.equipment.IModularItem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.jetbrains.annotations.Nullable;

public interface IModularTieredItem
extends IModularItem {
    public DETier getItemTier();

    @Override
    default public void handleTick(ModuleHost host, ItemStack stack, LivingEntity entity, @Nullable EquipmentSlot slot, boolean inEquipModSlot) {
        IModularItem.super.handleTick(host, stack, entity, slot, inEquipModSlot);
        double damage = this.getAttackDamage(host, stack);
        double speed = 1.0 + host.getModuleData(ModuleTypes.SPEED, new SpeedData(0.0)).speedMultiplier();
        stack.set(ItemData.ATTRIBUTE_DATA, (Object)new AttributeData(damage, speed));
    }

    default public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        AttributeData data = (AttributeData)stack.get(ItemData.ATTRIBUTE_DATA);
        if (data != null) {
            DETier tier = this.getItemTier();
            builder.add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, data.damage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
            builder.add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, (double)tier.getAttackSpeed() * this.getSwingSpeedMultiplier() * data.speed - 4.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        }
        return builder.build();
    }

    default public double getAttackDamage(ModuleHost host, ItemStack stack) {
        double damage = host.getModuleData(ModuleTypes.DAMAGE, new DamageData(0.0)).damagePoints();
        if ((double)this.getEnergyStored(stack) < (double)EquipCfg.energyAttack * damage) {
            damage = 0.0;
        }
        return damage + ((double)this.getItemTier().getAttackDamageBonus() * this.getDamageMultiplier() - 1.0);
    }

    public double getSwingSpeedMultiplier();

    public double getDamageMultiplier();

    public record AttributeData(double damage, double speed) {
        public static final Codec<AttributeData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("damage").forGetter(AttributeData::damage), (App)Codec.DOUBLE.fieldOf("speed").forGetter(AttributeData::speed)).apply((Applicative)instance, AttributeData::new));
    }
}

