/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.lib;

import com.brandon3055.brandonscore.handlers.IProcess;
import com.brandon3055.brandonscore.multiblock.MultiBlockDefinition;
import com.brandon3055.brandonscore.multiblock.MultiBlockPart;
import com.brandon3055.draconicevolution.blocks.tileentity.MultiBlockController;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class MultiBlockBuilder
implements IProcess {
    private final Level level;
    private final BlockPos inWorldOrigin;
    private final MultiBlockDefinition definition;
    private final Player player;
    private MultiBlockController controller;
    private boolean isDead = false;
    private Map<BlockPos, MultiBlockPart> workList = new HashMap<BlockPos, MultiBlockPart>();
    private LinkedList<BlockPos> workOrder = new LinkedList();

    public MultiBlockBuilder(Level level, BlockPos inWorldOrigin, MultiBlockDefinition definition, Player player, @Nullable MultiBlockController controller) {
        this.level = level;
        this.inWorldOrigin = inWorldOrigin;
        this.definition = definition;
        this.player = player;
        this.controller = controller;
        this.buildWorkList();
    }

    private void buildWorkList() {
        Map structureBlocks = this.definition.getBlocksAt(this.inWorldOrigin);
        for (Map.Entry entry : structureBlocks.entrySet()) {
            BlockPos pos = (BlockPos)entry.getKey();
            MultiBlockPart part = (MultiBlockPart)entry.getValue();
            if (part.isMatch(this.level, pos)) continue;
            if (this.level.isEmptyBlock(pos)) {
                this.workList.put(pos, part);
                continue;
            }
            this.isDead = true;
            this.player.sendSystemMessage((Component)Component.translatable((String)"struct_build.brandonscore.found_invalid", (Object[])new Object[]{this.level.getBlockState(pos).getBlock().getName(), "[X: " + pos.getX() + ", Y: " + pos.getY() + ", Z: " + pos.getZ() + "]"}).withStyle(ChatFormatting.RED));
            return;
        }
        this.workOrder.addAll(this.workList.keySet());
        this.workOrder.sort(Comparator.comparingInt(value -> (int)value.distSqr((Vec3i)this.inWorldOrigin)));
    }

    public void updateProcess() {
        if (this.workOrder.isEmpty() || !this.player.isAlive() || this.player.level() != this.level) {
            this.isDead = true;
            if (this.controller != null) {
                this.controller.validateStructure();
            }
            return;
        }
        BlockPos pos = this.workOrder.poll();
        MultiBlockPart part = this.workList.get(pos);
        if (part.isMatch(this.level, pos)) {
            return;
        }
        if (!this.level.isEmptyBlock(pos)) {
            this.player.sendSystemMessage((Component)Component.translatable((String)"struct_build.brandonscore.found_invalid", (Object[])new Object[]{this.level.getBlockState(pos).getBlock().getName(), "[X: " + pos.getX() + ", Y: " + pos.getY() + ", Z: " + pos.getZ() + "]"}).withStyle(ChatFormatting.RED));
            this.isDead = true;
            return;
        }
        Block placeBlock = this.extractPart(this.player, part);
        if (placeBlock != null) {
            this.level.setBlockAndUpdate(pos, placeBlock.defaultBlockState());
            SoundType soundtype = placeBlock.getSoundType(placeBlock.defaultBlockState(), (LevelReader)this.level, pos, (Entity)this.player);
            this.level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
        } else {
            this.player.sendSystemMessage((Component)Component.translatable((String)"struct_build.brandonscore.missing_required", (Object[])new Object[]{part.getFirstValidBlock().getName()}).withStyle(ChatFormatting.RED));
            this.isDead = true;
        }
    }

    @Nullable
    private Block extractPart(Player player, MultiBlockPart part) {
        if (player.getAbilities().instabuild) {
            return part.getFirstValidBlock();
        }
        IItemHandler handler = (IItemHandler)player.getCapability(Capabilities.ItemHandler.ENTITY);
        if (handler != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack extracted;
                ItemStack inSlot = handler.getStackInSlot(i);
                if (inSlot.isEmpty() || !(inSlot.getItem() instanceof BlockItem)) continue;
                Block slotBlock = ((BlockItem)inSlot.getItem()).getBlock();
                if (!part.validBlocks().contains(slotBlock) || (extracted = handler.extractItem(i, 1, false)).isEmpty() || !(extracted.getItem() instanceof BlockItem) || ((BlockItem)extracted.getItem()).getBlock() != slotBlock) continue;
                return slotBlock;
            }
        }
        return null;
    }

    public boolean isDead() {
        return this.isDead;
    }
}

