/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.util.Utils;

public class AddMana {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"addmahou").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"mana", (ArgumentType)IntegerArgumentType.integer((int)-1000000000, (int)1000000000)).then(((RequiredArgumentBuilder)Commands.argument((String)"overDrainHurts", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0E9f)).then(Commands.argument((String)"damagetype", (ArgumentType)IntegerArgumentType.integer((int)0, (int)2)).executes(ctx -> AddMana.run((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"mana"), FloatArgumentType.getFloat((CommandContext)ctx, (String)"overDrainHurts"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"damagetype"))))).requires(cs -> cs.hasPermission(2))))));
    }

    public static int run(CommandContext<CommandSourceStack> context, int mana, float overhurts, int damagetype) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(context, (String)"player");
        IMahou mahou = Utils.getPlayerMahou((Player)player);
        if (mahou != null) {
            if (mana < 0) {
                mana = -mana;
                int spent = PlayerManaManager.drainMana((Player)player, mana, false, false, false, false, true);
                DamageSource type = switch (damagetype) {
                    case 0 -> player.damageSources().generic();
                    case 1 -> player.damageSources().magic();
                    case 2 -> player.damageSources().fellOutOfWorld();
                    default -> player.damageSources().magic();
                };
                if (spent < mana && overhurts > 0.0f) {
                    float dmg = overhurts * (float)(mana - spent);
                    player.hurt(type, dmg);
                }
            } else {
                mahou.setStoredMana(Math.min(mahou.getMaxMana(), mahou.getStoredMana() + mana));
            }
            PlayerManaManager.updateClientMahou(player, mahou);
        }
        return 1;
    }
}

