/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import stepsword.mahoutsukai.networking.MahouPackets;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.util.EffectUtil;

public class AuthorityAttackPacket
implements CustomPacketPayload {
    public int entityId;
    public static final StreamCodec<ByteBuf, AuthorityAttackPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, p -> p.entityId, AuthorityAttackPacket::new);

    public AuthorityAttackPacket(Entity e) {
        this.entityId = e.getId();
    }

    public AuthorityAttackPacket(int i) {
        this.entityId = i;
    }

    public static void handle(AuthorityAttackPacket message, IPayloadContext context) {
        Player player = context.player();
        Level world = player.level();
        Entity e = world.getEntity(message.entityId);
        AuthorityAttackPacket.doAttack(player, e);
    }

    public static void doAttack(Player player, Entity entity) {
        if (entity != null && player != null && entity != player && entity instanceof LivingEntity && EffectUtil.hasBuff((LivingEntity)player, ModEffects.BORROWED_AUTHORITY) && !EffectUtil.hasBuff((LivingEntity)entity, ModEffects.BA_COOLDOWN) && entity.isAlive()) {
            player.attack(entity);
        }
    }

    public CustomPacketPayload.Type<AuthorityAttackPacket> type() {
        return MahouPackets.AUTHORITY_ATTACK_TYPE;
    }
}

